/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53profiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfileAssociationsRequest extends Route53ProfilesRequest implements
        ToCopyableBuilder<ListProfileAssociationsRequest.Builder, ListProfileAssociationsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListProfileAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListProfileAssociationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(ListProfileAssociationsRequest::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("profileId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ListProfileAssociationsRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, PROFILE_ID_FIELD, RESOURCE_ID_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String profileId;

    private final String resourceId;

    private ListProfileAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.profileId = builder.profileId;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * The maximum number of objects that you want to return for this request. If more objects are available, in the
     * response, a <code>NextToken</code> value, which you can use in a subsequent call to get the next batch of
     * objects, is provided.
     * </p>
     * <p>
     * If you don't specify a value for <code>MaxResults</code>, up to 100 objects are returned.
     * </p>
     * 
     * @return The maximum number of objects that you want to return for this request. If more objects are available, in
     *         the response, a <code>NextToken</code> value, which you can use in a subsequent call to get the next
     *         batch of objects, is provided.</p>
     *         <p>
     *         If you don't specify a value for <code>MaxResults</code>, up to 100 objects are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * For the first call to this list request, omit this value.
     * </p>
     * <p>
     * When you request a list of objects, at most the number of objects specified by <code>MaxResults</code> is
     * returned. If more objects are available for retrieval, a <code>NextToken</code> value is returned in the
     * response. To retrieve the next batch of objects, use the token that was returned for the prior request in your
     * next request.
     * </p>
     * 
     * @return For the first call to this list request, omit this value. </p>
     *         <p>
     *         When you request a list of objects, at most the number of objects specified by <code>MaxResults</code> is
     *         returned. If more objects are available for retrieval, a <code>NextToken</code> value is returned in the
     *         response. To retrieve the next batch of objects, use the token that was returned for the prior request in
     *         your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * ID of the Profile.
     * </p>
     * 
     * @return ID of the Profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * ID of the VPC.
     * </p>
     * 
     * @return ID of the VPC.
     */
    public final String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileAssociationsRequest)) {
            return false;
        }
        ListProfileAssociationsRequest other = (ListProfileAssociationsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(profileId(), other.profileId()) && Objects.equals(resourceId(), other.resourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfileAssociationsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ProfileId", profileId()).add("ResourceId", resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfileAssociationsRequest, T> g) {
        return obj -> g.apply((ListProfileAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProfileAssociationsRequest> {
        /**
         * <p>
         * The maximum number of objects that you want to return for this request. If more objects are available, in the
         * response, a <code>NextToken</code> value, which you can use in a subsequent call to get the next batch of
         * objects, is provided.
         * </p>
         * <p>
         * If you don't specify a value for <code>MaxResults</code>, up to 100 objects are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of objects that you want to return for this request. If more objects are available,
         *        in the response, a <code>NextToken</code> value, which you can use in a subsequent call to get the
         *        next batch of objects, is provided.</p>
         *        <p>
         *        If you don't specify a value for <code>MaxResults</code>, up to 100 objects are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * For the first call to this list request, omit this value.
         * </p>
         * <p>
         * When you request a list of objects, at most the number of objects specified by <code>MaxResults</code> is
         * returned. If more objects are available for retrieval, a <code>NextToken</code> value is returned in the
         * response. To retrieve the next batch of objects, use the token that was returned for the prior request in
         * your next request.
         * </p>
         * 
         * @param nextToken
         *        For the first call to this list request, omit this value. </p>
         *        <p>
         *        When you request a list of objects, at most the number of objects specified by <code>MaxResults</code>
         *        is returned. If more objects are available for retrieval, a <code>NextToken</code> value is returned
         *        in the response. To retrieve the next batch of objects, use the token that was returned for the prior
         *        request in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * ID of the Profile.
         * </p>
         * 
         * @param profileId
         *        ID of the Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * ID of the VPC.
         * </p>
         * 
         * @param resourceId
         *        ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ProfilesRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String profileId;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileAssociationsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            profileId(model.profileId);
            resourceId(model.resourceId);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProfileAssociationsRequest build() {
            return new ListProfileAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
