/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53profiles.model.Route53ProfilesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProfileResourceAssociationRequest
extends Route53ProfilesRequest
implements ToCopyableBuilder<Builder, UpdateProfileResourceAssociationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateProfileResourceAssociationRequest.getter(UpdateProfileResourceAssociationRequest::name)).setter(UpdateProfileResourceAssociationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PROFILE_RESOURCE_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileResourceAssociationId").getter(UpdateProfileResourceAssociationRequest.getter(UpdateProfileResourceAssociationRequest::profileResourceAssociationId)).setter(UpdateProfileResourceAssociationRequest.setter(Builder::profileResourceAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ProfileResourceAssociationId").build()}).build();
    private static final SdkField<String> RESOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceProperties").getter(UpdateProfileResourceAssociationRequest.getter(UpdateProfileResourceAssociationRequest::resourceProperties)).setter(UpdateProfileResourceAssociationRequest.setter(Builder::resourceProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PROFILE_RESOURCE_ASSOCIATION_ID_FIELD, RESOURCE_PROPERTIES_FIELD));
    private final String name;
    private final String profileResourceAssociationId;
    private final String resourceProperties;

    private UpdateProfileResourceAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.profileResourceAssociationId = builder.profileResourceAssociationId;
        this.resourceProperties = builder.resourceProperties;
    }

    public final String name() {
        return this.name;
    }

    public final String profileResourceAssociationId() {
        return this.profileResourceAssociationId;
    }

    public final String resourceProperties() {
        return this.resourceProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileResourceAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileResourceAssociationRequest)) {
            return false;
        }
        UpdateProfileResourceAssociationRequest other = (UpdateProfileResourceAssociationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.profileResourceAssociationId(), other.profileResourceAssociationId()) && Objects.equals(this.resourceProperties(), other.resourceProperties());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProfileResourceAssociationRequest").add("Name", (Object)this.name()).add("ProfileResourceAssociationId", (Object)this.profileResourceAssociationId()).add("ResourceProperties", (Object)this.resourceProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ProfileResourceAssociationId": {
                return Optional.ofNullable(clazz.cast(this.profileResourceAssociationId()));
            }
            case "ResourceProperties": {
                return Optional.ofNullable(clazz.cast(this.resourceProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfileResourceAssociationRequest, T> g) {
        return obj -> g.apply((UpdateProfileResourceAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ProfilesRequest.BuilderImpl
    implements Builder {
        private String name;
        private String profileResourceAssociationId;
        private String resourceProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileResourceAssociationRequest model) {
            super(model);
            this.name(model.name);
            this.profileResourceAssociationId(model.profileResourceAssociationId);
            this.resourceProperties(model.resourceProperties);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProfileResourceAssociationId() {
            return this.profileResourceAssociationId;
        }

        public final void setProfileResourceAssociationId(String profileResourceAssociationId) {
            this.profileResourceAssociationId = profileResourceAssociationId;
        }

        @Override
        public final Builder profileResourceAssociationId(String profileResourceAssociationId) {
            this.profileResourceAssociationId = profileResourceAssociationId;
            return this;
        }

        public final String getResourceProperties() {
            return this.resourceProperties;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfileResourceAssociationRequest build() {
            return new UpdateProfileResourceAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProfileResourceAssociationRequest> {
        public Builder name(String var1);

        public Builder profileResourceAssociationId(String var1);

        public Builder resourceProperties(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

