/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53profiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The association between a Route 53 Profile and resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileResourceAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfileResourceAssociation.Builder, ProfileResourceAssociation> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ProfileResourceAssociation::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ProfileResourceAssociation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModificationTime").getter(getter(ProfileResourceAssociation::modificationTime))
            .setter(setter(Builder::modificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ProfileResourceAssociation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(ProfileResourceAssociation::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(ProfileResourceAssociation::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ProfileResourceAssociation::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_PROPERTIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceProperties").getter(getter(ProfileResourceAssociation::resourceProperties))
            .setter(setter(Builder::resourceProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceProperties").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ProfileResourceAssociation::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProfileResourceAssociation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ProfileResourceAssociation::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, ID_FIELD,
            MODIFICATION_TIME_FIELD, NAME_FIELD, OWNER_ID_FIELD, PROFILE_ID_FIELD, RESOURCE_ARN_FIELD, RESOURCE_PROPERTIES_FIELD,
            RESOURCE_TYPE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String id;

    private final Instant modificationTime;

    private final String name;

    private final String ownerId;

    private final String profileId;

    private final String resourceArn;

    private final String resourceProperties;

    private final String resourceType;

    private final String status;

    private final String statusMessage;

    private ProfileResourceAssociation(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.modificationTime = builder.modificationTime;
        this.name = builder.name;
        this.ownerId = builder.ownerId;
        this.profileId = builder.profileId;
        this.resourceArn = builder.resourceArn;
        this.resourceProperties = builder.resourceProperties;
        this.resourceType = builder.resourceType;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The date and time that the Profile resource association was created, in Unix time format and Coordinated
     * Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the Profile resource association was created, in Unix time format and Coordinated
     *         Universal Time (UTC).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * ID of the Profile resource association.
     * </p>
     * 
     * @return ID of the Profile resource association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time that the Profile resource association was modified, in Unix time format and Coordinated
     * Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the Profile resource association was modified, in Unix time format and Coordinated
     *         Universal Time (UTC).
     */
    public final Instant modificationTime() {
        return modificationTime;
    }

    /**
     * <p>
     * Name of the Profile resource association.
     * </p>
     * 
     * @return Name of the Profile resource association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Amazon Web Services account ID of the Profile resource association owner.
     * </p>
     * 
     * @return Amazon Web Services account ID of the Profile resource association owner.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * Profile ID of the Profile that the resources are associated with.
     * </p>
     * 
     * @return Profile ID of the Profile that the resources are associated with.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource association.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * If the DNS resource is a DNS Firewall rule group, this indicates the priority.
     * </p>
     * 
     * @return If the DNS resource is a DNS Firewall rule group, this indicates the priority.
     */
    public final String resourceProperties() {
        return resourceProperties;
    }

    /**
     * <p>
     * Resource type, such as a private hosted zone, or DNS Firewall rule group.
     * </p>
     * 
     * @return Resource type, such as a private hosted zone, or DNS Firewall rule group.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Status of the Profile resource association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the Profile resource association.
     * @see ProfileStatus
     */
    public final ProfileStatus status() {
        return ProfileStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the Profile resource association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the Profile resource association.
     * @see ProfileStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the Profile resource association.
     * </p>
     * 
     * @return Additional information about the Profile resource association.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(modificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileResourceAssociation)) {
            return false;
        }
        ProfileResourceAssociation other = (ProfileResourceAssociation) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(id(), other.id())
                && Objects.equals(modificationTime(), other.modificationTime()) && Objects.equals(name(), other.name())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(profileId(), other.profileId())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourceProperties(), other.resourceProperties())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileResourceAssociation").add("CreationTime", creationTime()).add("Id", id())
                .add("ModificationTime", modificationTime()).add("Name", name()).add("OwnerId", ownerId())
                .add("ProfileId", profileId()).add("ResourceArn", resourceArn()).add("ResourceProperties", resourceProperties())
                .add("ResourceType", resourceType()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ModificationTime":
            return Optional.ofNullable(clazz.cast(modificationTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceProperties":
            return Optional.ofNullable(clazz.cast(resourceProperties()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfileResourceAssociation, T> g) {
        return obj -> g.apply((ProfileResourceAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileResourceAssociation> {
        /**
         * <p>
         * The date and time that the Profile resource association was created, in Unix time format and Coordinated
         * Universal Time (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the Profile resource association was created, in Unix time format and
         *        Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * ID of the Profile resource association.
         * </p>
         * 
         * @param id
         *        ID of the Profile resource association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time that the Profile resource association was modified, in Unix time format and Coordinated
         * Universal Time (UTC).
         * </p>
         * 
         * @param modificationTime
         *        The date and time that the Profile resource association was modified, in Unix time format and
         *        Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationTime(Instant modificationTime);

        /**
         * <p>
         * Name of the Profile resource association.
         * </p>
         * 
         * @param name
         *        Name of the Profile resource association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Amazon Web Services account ID of the Profile resource association owner.
         * </p>
         * 
         * @param ownerId
         *        Amazon Web Services account ID of the Profile resource association owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Profile ID of the Profile that the resources are associated with.
         * </p>
         * 
         * @param profileId
         *        Profile ID of the Profile that the resources are associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource association.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * If the DNS resource is a DNS Firewall rule group, this indicates the priority.
         * </p>
         * 
         * @param resourceProperties
         *        If the DNS resource is a DNS Firewall rule group, this indicates the priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceProperties(String resourceProperties);

        /**
         * <p>
         * Resource type, such as a private hosted zone, or DNS Firewall rule group.
         * </p>
         * 
         * @param resourceType
         *        Resource type, such as a private hosted zone, or DNS Firewall rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Status of the Profile resource association.
         * </p>
         * 
         * @param status
         *        Status of the Profile resource association.
         * @see ProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the Profile resource association.
         * </p>
         * 
         * @param status
         *        Status of the Profile resource association.
         * @see ProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileStatus
         */
        Builder status(ProfileStatus status);

        /**
         * <p>
         * Additional information about the Profile resource association.
         * </p>
         * 
         * @param statusMessage
         *        Additional information about the Profile resource association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String id;

        private Instant modificationTime;

        private String name;

        private String ownerId;

        private String profileId;

        private String resourceArn;

        private String resourceProperties;

        private String resourceType;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileResourceAssociation model) {
            creationTime(model.creationTime);
            id(model.id);
            modificationTime(model.modificationTime);
            name(model.name);
            ownerId(model.ownerId);
            profileId(model.profileId);
            resourceArn(model.resourceArn);
            resourceProperties(model.resourceProperties);
            resourceType(model.resourceType);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getModificationTime() {
            return modificationTime;
        }

        public final void setModificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceProperties() {
            return resourceProperties;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public ProfileResourceAssociation build() {
            return new ProfileResourceAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
