/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53profiles;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.route53profiles.auth.scheme.Route53ProfilesAuthSchemeProvider;
import software.amazon.awssdk.services.route53profiles.endpoints.Route53ProfilesEndpointProvider;

/**
 * This includes configuration specific to Route 53 Profiles that is supported by both
 * {@link Route53ProfilesClientBuilder} and {@link Route53ProfilesAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface Route53ProfilesBaseClientBuilder<B extends Route53ProfilesBaseClientBuilder<B, C>, C> extends
        AwsClientBuilder<B, C> {
    /**
     * Set the {@link Route53ProfilesEndpointProvider} implementation that will be used by the client to determine the
     * endpoint for each request. This is optional; if none is provided a default implementation will be used the SDK.
     */
    default B endpointProvider(Route53ProfilesEndpointProvider endpointProvider) {
        throw new UnsupportedOperationException();
    }

    /**
     * Set the {@link Route53ProfilesAuthSchemeProvider} implementation that will be used by the client to resolve the
     * auth scheme for each request. This is optional; if none is provided a default implementation will be used the
     * SDK.
     */
    default B authSchemeProvider(Route53ProfilesAuthSchemeProvider authSchemeProvider) {
        throw new UnsupportedOperationException();
    }
}
