/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53profiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProfileAssociationRequest extends Route53ProfilesRequest implements
        ToCopyableBuilder<GetProfileAssociationRequest.Builder, GetProfileAssociationRequest> {
    private static final SdkField<String> PROFILE_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileAssociationId").getter(getter(GetProfileAssociationRequest::profileAssociationId))
            .setter(setter(Builder::profileAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ProfileAssociationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ASSOCIATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String profileAssociationId;

    private GetProfileAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.profileAssociationId = builder.profileAssociationId;
    }

    /**
     * <p>
     * The identifier of the association you want to get information about.
     * </p>
     * 
     * @return The identifier of the association you want to get information about.
     */
    public final String profileAssociationId() {
        return profileAssociationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileAssociationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileAssociationRequest)) {
            return false;
        }
        GetProfileAssociationRequest other = (GetProfileAssociationRequest) obj;
        return Objects.equals(profileAssociationId(), other.profileAssociationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProfileAssociationRequest").add("ProfileAssociationId", profileAssociationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileAssociationId":
            return Optional.ofNullable(clazz.cast(profileAssociationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProfileAssociationId", PROFILE_ASSOCIATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProfileAssociationRequest, T> g) {
        return obj -> g.apply((GetProfileAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProfileAssociationRequest> {
        /**
         * <p>
         * The identifier of the association you want to get information about.
         * </p>
         * 
         * @param profileAssociationId
         *        The identifier of the association you want to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileAssociationId(String profileAssociationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ProfilesRequest.BuilderImpl implements Builder {
        private String profileAssociationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileAssociationRequest model) {
            super(model);
            profileAssociationId(model.profileAssociationId);
        }

        public final String getProfileAssociationId() {
            return profileAssociationId;
        }

        public final void setProfileAssociationId(String profileAssociationId) {
            this.profileAssociationId = profileAssociationId;
        }

        @Override
        public final Builder profileAssociationId(String profileAssociationId) {
            this.profileAssociationId = profileAssociationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProfileAssociationRequest build() {
            return new GetProfileAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
