/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53profiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that includes settings for a Route 53 Profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Profile implements SdkPojo, Serializable, ToCopyableBuilder<Profile.Builder, Profile> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Profile::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(Profile::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Profile::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Profile::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModificationTime").getter(getter(Profile::modificationTime)).setter(setter(Builder::modificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Profile::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(Profile::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareStatus").getter(getter(Profile::shareStatusAsString)).setter(setter(Builder::shareStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Profile::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(Profile::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CLIENT_TOKEN_FIELD,
            CREATION_TIME_FIELD, ID_FIELD, MODIFICATION_TIME_FIELD, NAME_FIELD, OWNER_ID_FIELD, SHARE_STATUS_FIELD, STATUS_FIELD,
            STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String clientToken;

    private final Instant creationTime;

    private final String id;

    private final Instant modificationTime;

    private final String name;

    private final String ownerId;

    private final String shareStatus;

    private final String status;

    private final String statusMessage;

    private Profile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.modificationTime = builder.modificationTime;
        this.name = builder.name;
        this.ownerId = builder.ownerId;
        this.shareStatus = builder.shareStatus;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Profile.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The <code>ClientToken</code> value that was assigned when the Profile was created.
     * </p>
     * 
     * @return The <code>ClientToken</code> value that was assigned when the Profile was created.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The date and time that the Profile was created, in Unix time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the Profile was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * ID of the Profile.
     * </p>
     * 
     * @return ID of the Profile.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time that the Profile was modified, in Unix time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the Profile was modified, in Unix time format and Coordinated Universal Time
     *         (UTC).
     */
    public final Instant modificationTime() {
        return modificationTime;
    }

    /**
     * <p>
     * Name of the Profile.
     * </p>
     * 
     * @return Name of the Profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Amazon Web Services account ID of the Profile owner.
     * </p>
     * 
     * @return Amazon Web Services account ID of the Profile owner.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * Sharing status for the Profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return Sharing status for the Profile.
     * @see ShareStatus
     */
    public final ShareStatus shareStatus() {
        return ShareStatus.fromValue(shareStatus);
    }

    /**
     * <p>
     * Sharing status for the Profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return Sharing status for the Profile.
     * @see ShareStatus
     */
    public final String shareStatusAsString() {
        return shareStatus;
    }

    /**
     * <p>
     * The status for the Profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for the Profile.
     * @see ProfileStatus
     */
    public final ProfileStatus status() {
        return ProfileStatus.fromValue(status);
    }

    /**
     * <p>
     * The status for the Profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for the Profile.
     * @see ProfileStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Status message that includes additiona information about the Profile.
     * </p>
     * 
     * @return Status message that includes additiona information about the Profile.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(modificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(shareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile other = (Profile) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(id(), other.id())
                && Objects.equals(modificationTime(), other.modificationTime()) && Objects.equals(name(), other.name())
                && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(shareStatusAsString(), other.shareStatusAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Profile").add("Arn", arn()).add("ClientToken", clientToken())
                .add("CreationTime", creationTime()).add("Id", id()).add("ModificationTime", modificationTime())
                .add("Name", name()).add("OwnerId", ownerId()).add("ShareStatus", shareStatusAsString())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ModificationTime":
            return Optional.ofNullable(clazz.cast(modificationTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "ShareStatus":
            return Optional.ofNullable(clazz.cast(shareStatusAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("ModificationTime", MODIFICATION_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("ShareStatus", SHARE_STATUS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Profile, T> g) {
        return obj -> g.apply((Profile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Profile> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Profile.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The <code>ClientToken</code> value that was assigned when the Profile was created.
         * </p>
         * 
         * @param clientToken
         *        The <code>ClientToken</code> value that was assigned when the Profile was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The date and time that the Profile was created, in Unix time format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the Profile was created, in Unix time format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * ID of the Profile.
         * </p>
         * 
         * @param id
         *        ID of the Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time that the Profile was modified, in Unix time format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param modificationTime
         *        The date and time that the Profile was modified, in Unix time format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationTime(Instant modificationTime);

        /**
         * <p>
         * Name of the Profile.
         * </p>
         * 
         * @param name
         *        Name of the Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Amazon Web Services account ID of the Profile owner.
         * </p>
         * 
         * @param ownerId
         *        Amazon Web Services account ID of the Profile owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Sharing status for the Profile.
         * </p>
         * 
         * @param shareStatus
         *        Sharing status for the Profile.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(String shareStatus);

        /**
         * <p>
         * Sharing status for the Profile.
         * </p>
         * 
         * @param shareStatus
         *        Sharing status for the Profile.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(ShareStatus shareStatus);

        /**
         * <p>
         * The status for the Profile.
         * </p>
         * 
         * @param status
         *        The status for the Profile.
         * @see ProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status for the Profile.
         * </p>
         * 
         * @param status
         *        The status for the Profile.
         * @see ProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileStatus
         */
        Builder status(ProfileStatus status);

        /**
         * <p>
         * Status message that includes additiona information about the Profile.
         * </p>
         * 
         * @param statusMessage
         *        Status message that includes additiona information about the Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String clientToken;

        private Instant creationTime;

        private String id;

        private Instant modificationTime;

        private String name;

        private String ownerId;

        private String shareStatus;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Profile model) {
            arn(model.arn);
            clientToken(model.clientToken);
            creationTime(model.creationTime);
            id(model.id);
            modificationTime(model.modificationTime);
            name(model.name);
            ownerId(model.ownerId);
            shareStatus(model.shareStatus);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getModificationTime() {
            return modificationTime;
        }

        public final void setModificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getShareStatus() {
            return shareStatus;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        @Override
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus == null ? null : shareStatus.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public Profile build() {
            return new Profile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
