/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53profiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An association between a Route 53 Profile and a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfileAssociation.Builder, ProfileAssociation> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ProfileAssociation::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ProfileAssociation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModificationTime").getter(getter(ProfileAssociation::modificationTime))
            .setter(setter(Builder::modificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ProfileAssociation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(ProfileAssociation::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(ProfileAssociation::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ProfileAssociation::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProfileAssociation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ProfileAssociation::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, ID_FIELD,
            MODIFICATION_TIME_FIELD, NAME_FIELD, OWNER_ID_FIELD, PROFILE_ID_FIELD, RESOURCE_ID_FIELD, STATUS_FIELD,
            STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String id;

    private final Instant modificationTime;

    private final String name;

    private final String ownerId;

    private final String profileId;

    private final String resourceId;

    private final String status;

    private final String statusMessage;

    private ProfileAssociation(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.modificationTime = builder.modificationTime;
        this.name = builder.name;
        this.ownerId = builder.ownerId;
        this.profileId = builder.profileId;
        this.resourceId = builder.resourceId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The date and time that the Profile association was created, in Unix time format and Coordinated Universal Time
     * (UTC).
     * </p>
     * 
     * @return The date and time that the Profile association was created, in Unix time format and Coordinated Universal
     *         Time (UTC).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * ID of the Profile association.
     * </p>
     * 
     * @return ID of the Profile association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time that the Profile association was modified, in Unix time format and Coordinated Universal Time
     * (UTC).
     * </p>
     * 
     * @return The date and time that the Profile association was modified, in Unix time format and Coordinated
     *         Universal Time (UTC).
     */
    public final Instant modificationTime() {
        return modificationTime;
    }

    /**
     * <p>
     * Name of the Profile association.
     * </p>
     * 
     * @return Name of the Profile association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Amazon Web Services account ID of the Profile association owner.
     * </p>
     * 
     * @return Amazon Web Services account ID of the Profile association owner.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * ID of the Profile.
     * </p>
     * 
     * @return ID of the Profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the VPC.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the VPC.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Status of the Profile association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the Profile association.
     * @see ProfileStatus
     */
    public final ProfileStatus status() {
        return ProfileStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the Profile association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the Profile association.
     * @see ProfileStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the Profile association.
     * </p>
     * 
     * @return Additional information about the Profile association.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(modificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileAssociation)) {
            return false;
        }
        ProfileAssociation other = (ProfileAssociation) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(id(), other.id())
                && Objects.equals(modificationTime(), other.modificationTime()) && Objects.equals(name(), other.name())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(profileId(), other.profileId())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileAssociation").add("CreationTime", creationTime()).add("Id", id())
                .add("ModificationTime", modificationTime()).add("Name", name()).add("OwnerId", ownerId())
                .add("ProfileId", profileId()).add("ResourceId", resourceId()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ModificationTime":
            return Optional.ofNullable(clazz.cast(modificationTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("ModificationTime", MODIFICATION_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileAssociation, T> g) {
        return obj -> g.apply((ProfileAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileAssociation> {
        /**
         * <p>
         * The date and time that the Profile association was created, in Unix time format and Coordinated Universal
         * Time (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the Profile association was created, in Unix time format and Coordinated
         *        Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * ID of the Profile association.
         * </p>
         * 
         * @param id
         *        ID of the Profile association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time that the Profile association was modified, in Unix time format and Coordinated Universal
         * Time (UTC).
         * </p>
         * 
         * @param modificationTime
         *        The date and time that the Profile association was modified, in Unix time format and Coordinated
         *        Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationTime(Instant modificationTime);

        /**
         * <p>
         * Name of the Profile association.
         * </p>
         * 
         * @param name
         *        Name of the Profile association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Amazon Web Services account ID of the Profile association owner.
         * </p>
         * 
         * @param ownerId
         *        Amazon Web Services account ID of the Profile association owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * ID of the Profile.
         * </p>
         * 
         * @param profileId
         *        ID of the Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the VPC.
         * </p>
         * 
         * @param resourceId
         *        The Amazon Resource Name (ARN) of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Status of the Profile association.
         * </p>
         * 
         * @param status
         *        Status of the Profile association.
         * @see ProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the Profile association.
         * </p>
         * 
         * @param status
         *        Status of the Profile association.
         * @see ProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileStatus
         */
        Builder status(ProfileStatus status);

        /**
         * <p>
         * Additional information about the Profile association.
         * </p>
         * 
         * @param statusMessage
         *        Additional information about the Profile association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String id;

        private Instant modificationTime;

        private String name;

        private String ownerId;

        private String profileId;

        private String resourceId;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileAssociation model) {
            creationTime(model.creationTime);
            id(model.id);
            modificationTime(model.modificationTime);
            name(model.name);
            ownerId(model.ownerId);
            profileId(model.profileId);
            resourceId(model.resourceId);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getModificationTime() {
            return modificationTime;
        }

        public final void setModificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public ProfileAssociation build() {
            return new ProfileAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
