/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53profiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProfileResourceAssociationRequest extends Route53ProfilesRequest implements
        ToCopyableBuilder<UpdateProfileResourceAssociationRequest.Builder, UpdateProfileResourceAssociationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateProfileResourceAssociationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PROFILE_RESOURCE_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("ProfileResourceAssociationId")
            .getter(getter(UpdateProfileResourceAssociationRequest::profileResourceAssociationId))
            .setter(setter(Builder::profileResourceAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ProfileResourceAssociationId").build())
            .build();

    private static final SdkField<String> RESOURCE_PROPERTIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceProperties").getter(getter(UpdateProfileResourceAssociationRequest::resourceProperties))
            .setter(setter(Builder::resourceProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PROFILE_RESOURCE_ASSOCIATION_ID_FIELD, RESOURCE_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String profileResourceAssociationId;

    private final String resourceProperties;

    private UpdateProfileResourceAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.profileResourceAssociationId = builder.profileResourceAssociationId;
        this.resourceProperties = builder.resourceProperties;
    }

    /**
     * <p>
     * Name of the resource association.
     * </p>
     * 
     * @return Name of the resource association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * ID of the resource association.
     * </p>
     * 
     * @return ID of the resource association.
     */
    public final String profileResourceAssociationId() {
        return profileResourceAssociationId;
    }

    /**
     * <p>
     * If you are adding a DNS Firewall rule group, include also a priority. The priority indicates the processing order
     * for the rule groups, starting with the priority assinged the lowest value.
     * </p>
     * <p>
     * The allowed values for priority are between 100 and 9900.
     * </p>
     * 
     * @return If you are adding a DNS Firewall rule group, include also a priority. The priority indicates the
     *         processing order for the rule groups, starting with the priority assinged the lowest value. </p>
     *         <p>
     *         The allowed values for priority are between 100 and 9900.
     */
    public final String resourceProperties() {
        return resourceProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(profileResourceAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileResourceAssociationRequest)) {
            return false;
        }
        UpdateProfileResourceAssociationRequest other = (UpdateProfileResourceAssociationRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(profileResourceAssociationId(), other.profileResourceAssociationId())
                && Objects.equals(resourceProperties(), other.resourceProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProfileResourceAssociationRequest").add("Name", name())
                .add("ProfileResourceAssociationId", profileResourceAssociationId())
                .add("ResourceProperties", resourceProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProfileResourceAssociationId":
            return Optional.ofNullable(clazz.cast(profileResourceAssociationId()));
        case "ResourceProperties":
            return Optional.ofNullable(clazz.cast(resourceProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ProfileResourceAssociationId", PROFILE_RESOURCE_ASSOCIATION_ID_FIELD);
        map.put("ResourceProperties", RESOURCE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfileResourceAssociationRequest, T> g) {
        return obj -> g.apply((UpdateProfileResourceAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProfileResourceAssociationRequest> {
        /**
         * <p>
         * Name of the resource association.
         * </p>
         * 
         * @param name
         *        Name of the resource association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * ID of the resource association.
         * </p>
         * 
         * @param profileResourceAssociationId
         *        ID of the resource association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileResourceAssociationId(String profileResourceAssociationId);

        /**
         * <p>
         * If you are adding a DNS Firewall rule group, include also a priority. The priority indicates the processing
         * order for the rule groups, starting with the priority assinged the lowest value.
         * </p>
         * <p>
         * The allowed values for priority are between 100 and 9900.
         * </p>
         * 
         * @param resourceProperties
         *        If you are adding a DNS Firewall rule group, include also a priority. The priority indicates the
         *        processing order for the rule groups, starting with the priority assinged the lowest value. </p>
         *        <p>
         *        The allowed values for priority are between 100 and 9900.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceProperties(String resourceProperties);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ProfilesRequest.BuilderImpl implements Builder {
        private String name;

        private String profileResourceAssociationId;

        private String resourceProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileResourceAssociationRequest model) {
            super(model);
            name(model.name);
            profileResourceAssociationId(model.profileResourceAssociationId);
            resourceProperties(model.resourceProperties);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProfileResourceAssociationId() {
            return profileResourceAssociationId;
        }

        public final void setProfileResourceAssociationId(String profileResourceAssociationId) {
            this.profileResourceAssociationId = profileResourceAssociationId;
        }

        @Override
        public final Builder profileResourceAssociationId(String profileResourceAssociationId) {
            this.profileResourceAssociationId = profileResourceAssociationId;
            return this;
        }

        public final String getResourceProperties() {
            return resourceProperties;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfileResourceAssociationRequest build() {
            return new UpdateProfileResourceAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
