/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53profiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProfileResourceAssociationResponse extends Route53ProfilesResponse implements
        ToCopyableBuilder<UpdateProfileResourceAssociationResponse.Builder, UpdateProfileResourceAssociationResponse> {
    private static final SdkField<ProfileResourceAssociation> PROFILE_RESOURCE_ASSOCIATION_FIELD = SdkField
            .<ProfileResourceAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("ProfileResourceAssociation")
            .getter(getter(UpdateProfileResourceAssociationResponse::profileResourceAssociation))
            .setter(setter(Builder::profileResourceAssociation))
            .constructor(ProfileResourceAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileResourceAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROFILE_RESOURCE_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ProfileResourceAssociation profileResourceAssociation;

    private UpdateProfileResourceAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.profileResourceAssociation = builder.profileResourceAssociation;
    }

    /**
     * <p>
     * Information about the <code>UpdateProfileResourceAssociation</code> request, including a status message.
     * </p>
     * 
     * @return Information about the <code>UpdateProfileResourceAssociation</code> request, including a status message.
     */
    public final ProfileResourceAssociation profileResourceAssociation() {
        return profileResourceAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileResourceAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileResourceAssociationResponse)) {
            return false;
        }
        UpdateProfileResourceAssociationResponse other = (UpdateProfileResourceAssociationResponse) obj;
        return Objects.equals(profileResourceAssociation(), other.profileResourceAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProfileResourceAssociationResponse")
                .add("ProfileResourceAssociation", profileResourceAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileResourceAssociation":
            return Optional.ofNullable(clazz.cast(profileResourceAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProfileResourceAssociation", PROFILE_RESOURCE_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfileResourceAssociationResponse, T> g) {
        return obj -> g.apply((UpdateProfileResourceAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProfileResourceAssociationResponse> {
        /**
         * <p>
         * Information about the <code>UpdateProfileResourceAssociation</code> request, including a status message.
         * </p>
         * 
         * @param profileResourceAssociation
         *        Information about the <code>UpdateProfileResourceAssociation</code> request, including a status
         *        message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileResourceAssociation(ProfileResourceAssociation profileResourceAssociation);

        /**
         * <p>
         * Information about the <code>UpdateProfileResourceAssociation</code> request, including a status message.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileResourceAssociation.Builder}
         * avoiding the need to create one manually via {@link ProfileResourceAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileResourceAssociation.Builder#build()} is called immediately
         * and its result is passed to {@link #profileResourceAssociation(ProfileResourceAssociation)}.
         * 
         * @param profileResourceAssociation
         *        a consumer that will call methods on {@link ProfileResourceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profileResourceAssociation(ProfileResourceAssociation)
         */
        default Builder profileResourceAssociation(Consumer<ProfileResourceAssociation.Builder> profileResourceAssociation) {
            return profileResourceAssociation(ProfileResourceAssociation.builder().applyMutation(profileResourceAssociation)
                    .build());
        }
    }

    static final class BuilderImpl extends Route53ProfilesResponse.BuilderImpl implements Builder {
        private ProfileResourceAssociation profileResourceAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileResourceAssociationResponse model) {
            super(model);
            profileResourceAssociation(model.profileResourceAssociation);
        }

        public final ProfileResourceAssociation.Builder getProfileResourceAssociation() {
            return profileResourceAssociation != null ? profileResourceAssociation.toBuilder() : null;
        }

        public final void setProfileResourceAssociation(ProfileResourceAssociation.BuilderImpl profileResourceAssociation) {
            this.profileResourceAssociation = profileResourceAssociation != null ? profileResourceAssociation.build() : null;
        }

        @Override
        public final Builder profileResourceAssociation(ProfileResourceAssociation profileResourceAssociation) {
            this.profileResourceAssociation = profileResourceAssociation;
            return this;
        }

        @Override
        public UpdateProfileResourceAssociationResponse build() {
            return new UpdateProfileResourceAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
