/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53profiles.Route53ProfilesAsyncClient;
import software.amazon.awssdk.services.route53profiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53profiles.model.ListProfileAssociationsRequest;
import software.amazon.awssdk.services.route53profiles.model.ListProfileAssociationsResponse;
import software.amazon.awssdk.services.route53profiles.model.ProfileAssociation;

public class ListProfileAssociationsPublisher
implements SdkPublisher<ListProfileAssociationsResponse> {
    private final Route53ProfilesAsyncClient client;
    private final ListProfileAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProfileAssociationsPublisher(Route53ProfilesAsyncClient client, ListProfileAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProfileAssociationsPublisher(Route53ProfilesAsyncClient client, ListProfileAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProfileAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProfileAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProfileAssociation> profileAssociations() {
        Function<ListProfileAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.profileAssociations() != null) {
                return response.profileAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProfileAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProfileAssociationsResponseFetcher
    implements AsyncPageFetcher<ListProfileAssociationsResponse> {
        private ListProfileAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListProfileAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProfileAssociationsResponse> nextPage(ListProfileAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListProfileAssociationsPublisher.this.client.listProfileAssociations(ListProfileAssociationsPublisher.this.firstRequest);
            }
            return ListProfileAssociationsPublisher.this.client.listProfileAssociations((ListProfileAssociationsRequest)((Object)ListProfileAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

