/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53profiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a Route 53 Profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileSummary implements SdkPojo, Serializable, ToCopyableBuilder<ProfileSummary.Builder, ProfileSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ProfileSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ProfileSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ProfileSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareStatus").getter(getter(ProfileSummary::shareStatusAsString)).setter(setter(Builder::shareStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NAME_FIELD, SHARE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String name;

    private final String shareStatus;

    private ProfileSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.shareStatus = builder.shareStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Profile.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * ID of the Profile.
     * </p>
     * 
     * @return ID of the Profile.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Name of the Profile.
     * </p>
     * 
     * @return Name of the Profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Share status of the Profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return Share status of the Profile.
     * @see ShareStatus
     */
    public final ShareStatus shareStatus() {
        return ShareStatus.fromValue(shareStatus);
    }

    /**
     * <p>
     * Share status of the Profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return Share status of the Profile.
     * @see ShareStatus
     */
    public final String shareStatusAsString() {
        return shareStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(shareStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileSummary)) {
            return false;
        }
        ProfileSummary other = (ProfileSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(shareStatusAsString(), other.shareStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileSummary").add("Arn", arn()).add("Id", id()).add("Name", name())
                .add("ShareStatus", shareStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ShareStatus":
            return Optional.ofNullable(clazz.cast(shareStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ShareStatus", SHARE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileSummary, T> g) {
        return obj -> g.apply((ProfileSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Profile.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * ID of the Profile.
         * </p>
         * 
         * @param id
         *        ID of the Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Name of the Profile.
         * </p>
         * 
         * @param name
         *        Name of the Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Share status of the Profile.
         * </p>
         * 
         * @param shareStatus
         *        Share status of the Profile.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(String shareStatus);

        /**
         * <p>
         * Share status of the Profile.
         * </p>
         * 
         * @param shareStatus
         *        Share status of the Profile.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(ShareStatus shareStatus);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private String shareStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileSummary model) {
            arn(model.arn);
            id(model.id);
            name(model.name);
            shareStatus(model.shareStatus);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShareStatus() {
            return shareStatus;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        @Override
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus == null ? null : shareStatus.toString());
            return this;
        }

        @Override
        public ProfileSummary build() {
            return new ProfileSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
