/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycluster.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRoutingControlStateRequest extends Route53RecoveryClusterRequest implements
        ToCopyableBuilder<UpdateRoutingControlStateRequest.Builder, UpdateRoutingControlStateRequest> {
    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlArn").getter(getter(UpdateRoutingControlStateRequest::routingControlArn))
            .setter(setter(Builder::routingControlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlArn").build()).build();

    private static final SdkField<String> ROUTING_CONTROL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlState").getter(getter(UpdateRoutingControlStateRequest::routingControlStateAsString))
            .setter(setter(Builder::routingControlState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlState").build())
            .build();

    private static final SdkField<List<String>> SAFETY_RULES_TO_OVERRIDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SafetyRulesToOverride")
            .getter(getter(UpdateRoutingControlStateRequest::safetyRulesToOverride))
            .setter(setter(Builder::safetyRulesToOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafetyRulesToOverride").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_CONTROL_ARN_FIELD,
            ROUTING_CONTROL_STATE_FIELD, SAFETY_RULES_TO_OVERRIDE_FIELD));

    private final String routingControlArn;

    private final String routingControlState;

    private final List<String> safetyRulesToOverride;

    private UpdateRoutingControlStateRequest(BuilderImpl builder) {
        super(builder);
        this.routingControlArn = builder.routingControlArn;
        this.routingControlState = builder.routingControlState;
        this.safetyRulesToOverride = builder.safetyRulesToOverride;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the routing control that you want to update the state for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the routing control that you want to update the state for.
     */
    public final String routingControlArn() {
        return routingControlArn;
    }

    /**
     * <p>
     * The state of the routing control. You can set the value to be On or Off.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routingControlState} will return {@link RoutingControlState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #routingControlStateAsString}.
     * </p>
     * 
     * @return The state of the routing control. You can set the value to be On or Off.
     * @see RoutingControlState
     */
    public final RoutingControlState routingControlState() {
        return RoutingControlState.fromValue(routingControlState);
    }

    /**
     * <p>
     * The state of the routing control. You can set the value to be On or Off.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routingControlState} will return {@link RoutingControlState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #routingControlStateAsString}.
     * </p>
     * 
     * @return The state of the routing control. You can set the value to be On or Off.
     * @see RoutingControlState
     */
    public final String routingControlStateAsString() {
        return routingControlState;
    }

    /**
     * For responses, this returns true if the service returned a value for the SafetyRulesToOverride property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSafetyRulesToOverride() {
        return safetyRulesToOverride != null && !(safetyRulesToOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating the state of
     * a routing control. You can override one safety rule or multiple safety rules by including one or more ARNs,
     * separated by commas.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html"> Override
     * safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSafetyRulesToOverride} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating the
     *         state of a routing control. You can override one safety rule or multiple safety rules by including one or
     *         more ARNs, separated by commas.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html">
     *         Override safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller
     *         Developer Guide.
     */
    public final List<String> safetyRulesToOverride() {
        return safetyRulesToOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routingControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(routingControlStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSafetyRulesToOverride() ? safetyRulesToOverride() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingControlStateRequest)) {
            return false;
        }
        UpdateRoutingControlStateRequest other = (UpdateRoutingControlStateRequest) obj;
        return Objects.equals(routingControlArn(), other.routingControlArn())
                && Objects.equals(routingControlStateAsString(), other.routingControlStateAsString())
                && hasSafetyRulesToOverride() == other.hasSafetyRulesToOverride()
                && Objects.equals(safetyRulesToOverride(), other.safetyRulesToOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRoutingControlStateRequest").add("RoutingControlArn", routingControlArn())
                .add("RoutingControlState", routingControlStateAsString())
                .add("SafetyRulesToOverride", hasSafetyRulesToOverride() ? safetyRulesToOverride() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoutingControlArn":
            return Optional.ofNullable(clazz.cast(routingControlArn()));
        case "RoutingControlState":
            return Optional.ofNullable(clazz.cast(routingControlStateAsString()));
        case "SafetyRulesToOverride":
            return Optional.ofNullable(clazz.cast(safetyRulesToOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoutingControlStateRequest, T> g) {
        return obj -> g.apply((UpdateRoutingControlStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryClusterRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRoutingControlStateRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the routing control that you want to update the state for.
         * </p>
         * 
         * @param routingControlArn
         *        The Amazon Resource Name (ARN) for the routing control that you want to update the state for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingControlArn(String routingControlArn);

        /**
         * <p>
         * The state of the routing control. You can set the value to be On or Off.
         * </p>
         * 
         * @param routingControlState
         *        The state of the routing control. You can set the value to be On or Off.
         * @see RoutingControlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingControlState
         */
        Builder routingControlState(String routingControlState);

        /**
         * <p>
         * The state of the routing control. You can set the value to be On or Off.
         * </p>
         * 
         * @param routingControlState
         *        The state of the routing control. You can set the value to be On or Off.
         * @see RoutingControlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingControlState
         */
        Builder routingControlState(RoutingControlState routingControlState);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating the
         * state of a routing control. You can override one safety rule or multiple safety rules by including one or
         * more ARNs, separated by commas.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html"> Override
         * safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.
         * </p>
         * 
         * @param safetyRulesToOverride
         *        The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating
         *        the state of a routing control. You can override one safety rule or multiple safety rules by including
         *        one or more ARNs, separated by commas.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html">
         *        Override safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller
         *        Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder safetyRulesToOverride(Collection<String> safetyRulesToOverride);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating the
         * state of a routing control. You can override one safety rule or multiple safety rules by including one or
         * more ARNs, separated by commas.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html"> Override
         * safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.
         * </p>
         * 
         * @param safetyRulesToOverride
         *        The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating
         *        the state of a routing control. You can override one safety rule or multiple safety rules by including
         *        one or more ARNs, separated by commas.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html">
         *        Override safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller
         *        Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder safetyRulesToOverride(String... safetyRulesToOverride);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryClusterRequest.BuilderImpl implements Builder {
        private String routingControlArn;

        private String routingControlState;

        private List<String> safetyRulesToOverride = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoutingControlStateRequest model) {
            super(model);
            routingControlArn(model.routingControlArn);
            routingControlState(model.routingControlState);
            safetyRulesToOverride(model.safetyRulesToOverride);
        }

        public final String getRoutingControlArn() {
            return routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        public final String getRoutingControlState() {
            return routingControlState;
        }

        public final void setRoutingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
        }

        @Override
        public final Builder routingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
            return this;
        }

        @Override
        public final Builder routingControlState(RoutingControlState routingControlState) {
            this.routingControlState(routingControlState == null ? null : routingControlState.toString());
            return this;
        }

        public final Collection<String> getSafetyRulesToOverride() {
            if (safetyRulesToOverride instanceof SdkAutoConstructList) {
                return null;
            }
            return safetyRulesToOverride;
        }

        public final void setSafetyRulesToOverride(Collection<String> safetyRulesToOverride) {
            this.safetyRulesToOverride = ArnsCopier.copy(safetyRulesToOverride);
        }

        @Override
        public final Builder safetyRulesToOverride(Collection<String> safetyRulesToOverride) {
            this.safetyRulesToOverride = ArnsCopier.copy(safetyRulesToOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder safetyRulesToOverride(String... safetyRulesToOverride) {
            safetyRulesToOverride(Arrays.asList(safetyRulesToOverride));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoutingControlStateRequest build() {
            return new UpdateRoutingControlStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
