/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycluster.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRoutingControlStatesRequest extends Route53RecoveryClusterRequest implements
        ToCopyableBuilder<UpdateRoutingControlStatesRequest.Builder, UpdateRoutingControlStatesRequest> {
    private static final SdkField<List<UpdateRoutingControlStateEntry>> UPDATE_ROUTING_CONTROL_STATE_ENTRIES_FIELD = SdkField
            .<List<UpdateRoutingControlStateEntry>> builder(MarshallingType.LIST)
            .memberName("UpdateRoutingControlStateEntries")
            .getter(getter(UpdateRoutingControlStatesRequest::updateRoutingControlStateEntries))
            .setter(setter(Builder::updateRoutingControlStateEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateRoutingControlStateEntries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateRoutingControlStateEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateRoutingControlStateEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SAFETY_RULES_TO_OVERRIDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SafetyRulesToOverride")
            .getter(getter(UpdateRoutingControlStatesRequest::safetyRulesToOverride))
            .setter(setter(Builder::safetyRulesToOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafetyRulesToOverride").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            UPDATE_ROUTING_CONTROL_STATE_ENTRIES_FIELD, SAFETY_RULES_TO_OVERRIDE_FIELD));

    private final List<UpdateRoutingControlStateEntry> updateRoutingControlStateEntries;

    private final List<String> safetyRulesToOverride;

    private UpdateRoutingControlStatesRequest(BuilderImpl builder) {
        super(builder);
        this.updateRoutingControlStateEntries = builder.updateRoutingControlStateEntries;
        this.safetyRulesToOverride = builder.safetyRulesToOverride;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpdateRoutingControlStateEntries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasUpdateRoutingControlStateEntries() {
        return updateRoutingControlStateEntries != null && !(updateRoutingControlStateEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of routing control entries that you want to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdateRoutingControlStateEntries}
     * method.
     * </p>
     * 
     * @return A set of routing control entries that you want to update.
     */
    public final List<UpdateRoutingControlStateEntry> updateRoutingControlStateEntries() {
        return updateRoutingControlStateEntries;
    }

    /**
     * For responses, this returns true if the service returned a value for the SafetyRulesToOverride property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSafetyRulesToOverride() {
        return safetyRulesToOverride != null && !(safetyRulesToOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating routing
     * control states. You can override one safety rule or multiple safety rules by including one or more ARNs,
     * separated by commas.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html"> Override
     * safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSafetyRulesToOverride} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating
     *         routing control states. You can override one safety rule or multiple safety rules by including one or
     *         more ARNs, separated by commas.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html">
     *         Override safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller
     *         Developer Guide.
     */
    public final List<String> safetyRulesToOverride() {
        return safetyRulesToOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasUpdateRoutingControlStateEntries() ? updateRoutingControlStateEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSafetyRulesToOverride() ? safetyRulesToOverride() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingControlStatesRequest)) {
            return false;
        }
        UpdateRoutingControlStatesRequest other = (UpdateRoutingControlStatesRequest) obj;
        return hasUpdateRoutingControlStateEntries() == other.hasUpdateRoutingControlStateEntries()
                && Objects.equals(updateRoutingControlStateEntries(), other.updateRoutingControlStateEntries())
                && hasSafetyRulesToOverride() == other.hasSafetyRulesToOverride()
                && Objects.equals(safetyRulesToOverride(), other.safetyRulesToOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateRoutingControlStatesRequest")
                .add("UpdateRoutingControlStateEntries",
                        hasUpdateRoutingControlStateEntries() ? updateRoutingControlStateEntries() : null)
                .add("SafetyRulesToOverride", hasSafetyRulesToOverride() ? safetyRulesToOverride() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateRoutingControlStateEntries":
            return Optional.ofNullable(clazz.cast(updateRoutingControlStateEntries()));
        case "SafetyRulesToOverride":
            return Optional.ofNullable(clazz.cast(safetyRulesToOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoutingControlStatesRequest, T> g) {
        return obj -> g.apply((UpdateRoutingControlStatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryClusterRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRoutingControlStatesRequest> {
        /**
         * <p>
         * A set of routing control entries that you want to update.
         * </p>
         * 
         * @param updateRoutingControlStateEntries
         *        A set of routing control entries that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateRoutingControlStateEntries(Collection<UpdateRoutingControlStateEntry> updateRoutingControlStateEntries);

        /**
         * <p>
         * A set of routing control entries that you want to update.
         * </p>
         * 
         * @param updateRoutingControlStateEntries
         *        A set of routing control entries that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateRoutingControlStateEntries(UpdateRoutingControlStateEntry... updateRoutingControlStateEntries);

        /**
         * <p>
         * A set of routing control entries that you want to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <UpdateRoutingControlStateEntry>.Builder} avoiding the need to create one manually via {@link List
         * <UpdateRoutingControlStateEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateRoutingControlStateEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #updateRoutingControlStateEntries(List<UpdateRoutingControlStateEntry>)}.
         * 
         * @param updateRoutingControlStateEntries
         *        a consumer that will call methods on {@link List<UpdateRoutingControlStateEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateRoutingControlStateEntries(List<UpdateRoutingControlStateEntry>)
         */
        Builder updateRoutingControlStateEntries(
                Consumer<UpdateRoutingControlStateEntry.Builder>... updateRoutingControlStateEntries);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating routing
         * control states. You can override one safety rule or multiple safety rules by including one or more ARNs,
         * separated by commas.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html"> Override
         * safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.
         * </p>
         * 
         * @param safetyRulesToOverride
         *        The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating
         *        routing control states. You can override one safety rule or multiple safety rules by including one or
         *        more ARNs, separated by commas.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html">
         *        Override safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller
         *        Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder safetyRulesToOverride(Collection<String> safetyRulesToOverride);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating routing
         * control states. You can override one safety rule or multiple safety rules by including one or more ARNs,
         * separated by commas.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html"> Override
         * safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.
         * </p>
         * 
         * @param safetyRulesToOverride
         *        The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating
         *        routing control states. You can override one safety rule or multiple safety rules by including one or
         *        more ARNs, separated by commas.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html">
         *        Override safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller
         *        Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder safetyRulesToOverride(String... safetyRulesToOverride);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryClusterRequest.BuilderImpl implements Builder {
        private List<UpdateRoutingControlStateEntry> updateRoutingControlStateEntries = DefaultSdkAutoConstructList.getInstance();

        private List<String> safetyRulesToOverride = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoutingControlStatesRequest model) {
            super(model);
            updateRoutingControlStateEntries(model.updateRoutingControlStateEntries);
            safetyRulesToOverride(model.safetyRulesToOverride);
        }

        public final List<UpdateRoutingControlStateEntry.Builder> getUpdateRoutingControlStateEntries() {
            List<UpdateRoutingControlStateEntry.Builder> result = UpdateRoutingControlStateEntriesCopier
                    .copyToBuilder(this.updateRoutingControlStateEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdateRoutingControlStateEntries(
                Collection<UpdateRoutingControlStateEntry.BuilderImpl> updateRoutingControlStateEntries) {
            this.updateRoutingControlStateEntries = UpdateRoutingControlStateEntriesCopier
                    .copyFromBuilder(updateRoutingControlStateEntries);
        }

        @Override
        public final Builder updateRoutingControlStateEntries(
                Collection<UpdateRoutingControlStateEntry> updateRoutingControlStateEntries) {
            this.updateRoutingControlStateEntries = UpdateRoutingControlStateEntriesCopier.copy(updateRoutingControlStateEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateRoutingControlStateEntries(UpdateRoutingControlStateEntry... updateRoutingControlStateEntries) {
            updateRoutingControlStateEntries(Arrays.asList(updateRoutingControlStateEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateRoutingControlStateEntries(
                Consumer<UpdateRoutingControlStateEntry.Builder>... updateRoutingControlStateEntries) {
            updateRoutingControlStateEntries(Stream.of(updateRoutingControlStateEntries)
                    .map(c -> UpdateRoutingControlStateEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSafetyRulesToOverride() {
            if (safetyRulesToOverride instanceof SdkAutoConstructList) {
                return null;
            }
            return safetyRulesToOverride;
        }

        public final void setSafetyRulesToOverride(Collection<String> safetyRulesToOverride) {
            this.safetyRulesToOverride = ArnsCopier.copy(safetyRulesToOverride);
        }

        @Override
        public final Builder safetyRulesToOverride(Collection<String> safetyRulesToOverride) {
            this.safetyRulesToOverride = ArnsCopier.copy(safetyRulesToOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder safetyRulesToOverride(String... safetyRulesToOverride) {
            safetyRulesToOverride(Arrays.asList(safetyRulesToOverride));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoutingControlStatesRequest build() {
            return new UpdateRoutingControlStatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
