/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycluster;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateRequest;
import software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateResponse;
import software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateRequest;
import software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateResponse;
import software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest;
import software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesResponse;

/**
 * Service client for accessing Route53 Recovery Cluster asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Welcome to the Amazon Route 53 Application Recovery Controller API Reference Guide for Recovery Control Data Plane .
 * </p>
 * <p>
 * Recovery control in Route 53 Application Recovery Controller includes extremely reliable routing controls that enable
 * you to recover applications by rerouting traffic, for example, across Availability Zones or AWS Regions. Routing
 * controls are simple on/off switches hosted on a cluster. A cluster is a set of five redundant regional endpoints
 * against which you can execute API calls to update or get the state of routing controls. You use routing controls to
 * failover traffic to recover your application across Availability Zones or Regions.
 * </p>
 * <p>
 * This API guide includes information about how to get and update routing control states in Route 53 Application
 * Recovery Controller.
 * </p>
 * <p>
 * For more information about Route 53 Application Recovery Controller, see the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * You can create clusters, routing controls, and control panels by using the control plane API for Recovery Control.
 * For more information, see <a href="https://docs.aws.amazon.com/recovery-cluster/latest/api/">Amazon Route 53
 * Application Recovery Controller Recovery Control API Reference</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Route 53 Application Recovery Controller also provides continuous readiness checks to ensure that your applications
 * are scaled to handle failover traffic. For more information about the related API actions, see <a
 * href="https://docs.aws.amazon.com/recovery-readiness/latest/api/">Amazon Route 53 Application Recovery Controller
 * Recovery Readiness API Reference</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For more information about creating resilient applications and preparing for recovery readiness with Route 53
 * Application Recovery Controller, see the <a href="r53recovery/latest/dg/">Amazon Route 53 Application Recovery
 * Controller Developer Guide</a>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Route53RecoveryClusterAsyncClient extends SdkClient {
    String SERVICE_NAME = "route53-recovery-cluster";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "route53-recovery-cluster";

    /**
     * Create a {@link Route53RecoveryClusterAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Route53RecoveryClusterAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Route53RecoveryClusterAsyncClient}.
     */
    static Route53RecoveryClusterAsyncClientBuilder builder() {
        return new DefaultRoute53RecoveryClusterAsyncClientBuilder();
    }

    /**
     * <p>
     * Get the state for a routing control. A routing control is a simple on/off switch that you can use to route
     * traffic to cells. When the state is On, traffic flows to a cell. When it's off, traffic does not flow.
     * </p>
     * <p>
     * Before you can create a routing control, you first must create a cluster to host the control. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/recovery-cluster/latest/api/cluster.html">CreateCluster</a>. Access one of the
     * endpoints for the cluster to get or update the routing control state to redirect traffic.
     * </p>
     * <p>
     * For more information about working with routing controls, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Routing control</a> in the Route 53
     * Application Recovery Controller Developer Guide.
     * </p>
     *
     * @param getRoutingControlStateRequest
     * @return A Java Future containing the result of the GetRoutingControlState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to query the routing control state.</li>
     *         <li>InternalServerException There was an unexpected error during processing of the request.</li>
     *         <li>ResourceNotFoundException The request references a routing control that was not found.</li>
     *         <li>ValidationException There was a validation error on the request.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>EndpointTemporarilyUnavailableException The cluster endpoint isn't available. Try another cluster
     *         endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryClusterException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryClusterAsyncClient.GetRoutingControlState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/GetRoutingControlState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRoutingControlStateResponse> getRoutingControlState(
            GetRoutingControlStateRequest getRoutingControlStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the state for a routing control. A routing control is a simple on/off switch that you can use to route
     * traffic to cells. When the state is On, traffic flows to a cell. When it's off, traffic does not flow.
     * </p>
     * <p>
     * Before you can create a routing control, you first must create a cluster to host the control. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/recovery-cluster/latest/api/cluster.html">CreateCluster</a>. Access one of the
     * endpoints for the cluster to get or update the routing control state to redirect traffic.
     * </p>
     * <p>
     * For more information about working with routing controls, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Routing control</a> in the Route 53
     * Application Recovery Controller Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRoutingControlStateRequest.Builder} avoiding the
     * need to create one manually via {@link GetRoutingControlStateRequest#builder()}
     * </p>
     *
     * @param getRoutingControlStateRequest
     *        A {@link Consumer} that will call methods on {@link GetRoutingControlStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRoutingControlState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to query the routing control state.</li>
     *         <li>InternalServerException There was an unexpected error during processing of the request.</li>
     *         <li>ResourceNotFoundException The request references a routing control that was not found.</li>
     *         <li>ValidationException There was a validation error on the request.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>EndpointTemporarilyUnavailableException The cluster endpoint isn't available. Try another cluster
     *         endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryClusterException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryClusterAsyncClient.GetRoutingControlState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/GetRoutingControlState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRoutingControlStateResponse> getRoutingControlState(
            Consumer<GetRoutingControlStateRequest.Builder> getRoutingControlStateRequest) {
        return getRoutingControlState(GetRoutingControlStateRequest.builder().applyMutation(getRoutingControlStateRequest)
                .build());
    }

    /**
     * <p>
     * Set the state of the routing control to reroute traffic. You can set the value to be On or Off. When the state is
     * On, traffic flows to a cell. When it's off, traffic does not flow.
     * </p>
     * <p>
     * For more information about working with routing controls, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Routing control</a> in the Route 53
     * Application Recovery Controller Developer Guide.
     * </p>
     *
     * @param updateRoutingControlStateRequest
     * @return A Java Future containing the result of the UpdateRoutingControlState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to query the routing control state.</li>
     *         <li>InternalServerException There was an unexpected error during processing of the request.</li>
     *         <li>ResourceNotFoundException The request references a routing control that was not found.</li>
     *         <li>ValidationException There was a validation error on the request.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>EndpointTemporarilyUnavailableException The cluster endpoint isn't available. Try another cluster
     *         endpoint.</li>
     *         <li>ConflictException There was a conflict with this request. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryClusterException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryClusterAsyncClient.UpdateRoutingControlState
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRoutingControlStateResponse> updateRoutingControlState(
            UpdateRoutingControlStateRequest updateRoutingControlStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the state of the routing control to reroute traffic. You can set the value to be On or Off. When the state is
     * On, traffic flows to a cell. When it's off, traffic does not flow.
     * </p>
     * <p>
     * For more information about working with routing controls, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Routing control</a> in the Route 53
     * Application Recovery Controller Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRoutingControlStateRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateRoutingControlStateRequest#builder()}
     * </p>
     *
     * @param updateRoutingControlStateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRoutingControlStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRoutingControlState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to query the routing control state.</li>
     *         <li>InternalServerException There was an unexpected error during processing of the request.</li>
     *         <li>ResourceNotFoundException The request references a routing control that was not found.</li>
     *         <li>ValidationException There was a validation error on the request.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>EndpointTemporarilyUnavailableException The cluster endpoint isn't available. Try another cluster
     *         endpoint.</li>
     *         <li>ConflictException There was a conflict with this request. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryClusterException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryClusterAsyncClient.UpdateRoutingControlState
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRoutingControlStateResponse> updateRoutingControlState(
            Consumer<UpdateRoutingControlStateRequest.Builder> updateRoutingControlStateRequest) {
        return updateRoutingControlState(UpdateRoutingControlStateRequest.builder()
                .applyMutation(updateRoutingControlStateRequest).build());
    }

    /**
     * <p>
     * Set multiple routing control states. You can set the value for each state to be On or Off. When the state is On,
     * traffic flows to a cell. When it's off, traffic does not flow.
     * </p>
     * <p>
     * For more information about working with routing controls, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Routing control</a> in the Route 53
     * Application Recovery Controller Developer Guide.
     * </p>
     *
     * @param updateRoutingControlStatesRequest
     * @return A Java Future containing the result of the UpdateRoutingControlStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to query the routing control state.</li>
     *         <li>InternalServerException There was an unexpected error during processing of the request.</li>
     *         <li>ResourceNotFoundException The request references a routing control that was not found.</li>
     *         <li>ValidationException There was a validation error on the request.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>EndpointTemporarilyUnavailableException The cluster endpoint isn't available. Try another cluster
     *         endpoint.</li>
     *         <li>ConflictException There was a conflict with this request. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryClusterException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryClusterAsyncClient.UpdateRoutingControlStates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlStates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRoutingControlStatesResponse> updateRoutingControlStates(
            UpdateRoutingControlStatesRequest updateRoutingControlStatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set multiple routing control states. You can set the value for each state to be On or Off. When the state is On,
     * traffic flows to a cell. When it's off, traffic does not flow.
     * </p>
     * <p>
     * For more information about working with routing controls, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Routing control</a> in the Route 53
     * Application Recovery Controller Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRoutingControlStatesRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateRoutingControlStatesRequest#builder()}
     * </p>
     *
     * @param updateRoutingControlStatesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRoutingControlStatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRoutingControlStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to query the routing control state.</li>
     *         <li>InternalServerException There was an unexpected error during processing of the request.</li>
     *         <li>ResourceNotFoundException The request references a routing control that was not found.</li>
     *         <li>ValidationException There was a validation error on the request.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>EndpointTemporarilyUnavailableException The cluster endpoint isn't available. Try another cluster
     *         endpoint.</li>
     *         <li>ConflictException There was a conflict with this request. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryClusterException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryClusterAsyncClient.UpdateRoutingControlStates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlStates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRoutingControlStatesResponse> updateRoutingControlStates(
            Consumer<UpdateRoutingControlStatesRequest.Builder> updateRoutingControlStatesRequest) {
        return updateRoutingControlStates(UpdateRoutingControlStatesRequest.builder()
                .applyMutation(updateRoutingControlStatesRequest).build());
    }
}
