/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycluster.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRoutingControlStateResponse extends Route53RecoveryClusterResponse implements
        ToCopyableBuilder<GetRoutingControlStateResponse.Builder, GetRoutingControlStateResponse> {
    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlArn").getter(getter(GetRoutingControlStateResponse::routingControlArn))
            .setter(setter(Builder::routingControlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlArn").build()).build();

    private static final SdkField<String> ROUTING_CONTROL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlState").getter(getter(GetRoutingControlStateResponse::routingControlStateAsString))
            .setter(setter(Builder::routingControlState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlState").build())
            .build();

    private static final SdkField<String> ROUTING_CONTROL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlName").getter(getter(GetRoutingControlStateResponse::routingControlName))
            .setter(setter(Builder::routingControlName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_CONTROL_ARN_FIELD,
            ROUTING_CONTROL_STATE_FIELD, ROUTING_CONTROL_NAME_FIELD));

    private final String routingControlArn;

    private final String routingControlState;

    private final String routingControlName;

    private GetRoutingControlStateResponse(BuilderImpl builder) {
        super(builder);
        this.routingControlArn = builder.routingControlArn;
        this.routingControlState = builder.routingControlState;
        this.routingControlName = builder.routingControlName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the response.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the response.
     */
    public final String routingControlArn() {
        return routingControlArn;
    }

    /**
     * <p>
     * The state of the routing control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routingControlState} will return {@link RoutingControlState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #routingControlStateAsString}.
     * </p>
     * 
     * @return The state of the routing control.
     * @see RoutingControlState
     */
    public final RoutingControlState routingControlState() {
        return RoutingControlState.fromValue(routingControlState);
    }

    /**
     * <p>
     * The state of the routing control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routingControlState} will return {@link RoutingControlState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #routingControlStateAsString}.
     * </p>
     * 
     * @return The state of the routing control.
     * @see RoutingControlState
     */
    public final String routingControlStateAsString() {
        return routingControlState;
    }

    /**
     * <p>
     * The routing control name.
     * </p>
     * 
     * @return The routing control name.
     */
    public final String routingControlName() {
        return routingControlName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routingControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(routingControlStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(routingControlName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRoutingControlStateResponse)) {
            return false;
        }
        GetRoutingControlStateResponse other = (GetRoutingControlStateResponse) obj;
        return Objects.equals(routingControlArn(), other.routingControlArn())
                && Objects.equals(routingControlStateAsString(), other.routingControlStateAsString())
                && Objects.equals(routingControlName(), other.routingControlName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRoutingControlStateResponse").add("RoutingControlArn", routingControlArn())
                .add("RoutingControlState", routingControlStateAsString()).add("RoutingControlName", routingControlName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoutingControlArn":
            return Optional.ofNullable(clazz.cast(routingControlArn()));
        case "RoutingControlState":
            return Optional.ofNullable(clazz.cast(routingControlStateAsString()));
        case "RoutingControlName":
            return Optional.ofNullable(clazz.cast(routingControlName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRoutingControlStateResponse, T> g) {
        return obj -> g.apply((GetRoutingControlStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryClusterResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRoutingControlStateResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the response.
         * </p>
         * 
         * @param routingControlArn
         *        The Amazon Resource Name (ARN) of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingControlArn(String routingControlArn);

        /**
         * <p>
         * The state of the routing control.
         * </p>
         * 
         * @param routingControlState
         *        The state of the routing control.
         * @see RoutingControlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingControlState
         */
        Builder routingControlState(String routingControlState);

        /**
         * <p>
         * The state of the routing control.
         * </p>
         * 
         * @param routingControlState
         *        The state of the routing control.
         * @see RoutingControlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingControlState
         */
        Builder routingControlState(RoutingControlState routingControlState);

        /**
         * <p>
         * The routing control name.
         * </p>
         * 
         * @param routingControlName
         *        The routing control name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingControlName(String routingControlName);
    }

    static final class BuilderImpl extends Route53RecoveryClusterResponse.BuilderImpl implements Builder {
        private String routingControlArn;

        private String routingControlState;

        private String routingControlName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRoutingControlStateResponse model) {
            super(model);
            routingControlArn(model.routingControlArn);
            routingControlState(model.routingControlState);
            routingControlName(model.routingControlName);
        }

        public final String getRoutingControlArn() {
            return routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        public final String getRoutingControlState() {
            return routingControlState;
        }

        public final void setRoutingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
        }

        @Override
        public final Builder routingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
            return this;
        }

        @Override
        public final Builder routingControlState(RoutingControlState routingControlState) {
            this.routingControlState(routingControlState == null ? null : routingControlState.toString());
            return this;
        }

        public final String getRoutingControlName() {
            return routingControlName;
        }

        public final void setRoutingControlName(String routingControlName) {
            this.routingControlName = routingControlName;
        }

        @Override
        public final Builder routingControlName(String routingControlName) {
            this.routingControlName = routingControlName;
            return this;
        }

        @Override
        public GetRoutingControlStateResponse build() {
            return new GetRoutingControlStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
