/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycluster.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request can't update that many routing control states at the same time. Try again with fewer routing control
 * states.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLimitExceededException extends Route53RecoveryClusterException implements
        ToCopyableBuilder<ServiceLimitExceededException.Builder, ServiceLimitExceededException> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(ServiceLimitExceededException::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ServiceLimitExceededException::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> LIMIT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("limitCode").getter(getter(ServiceLimitExceededException::limitCode)).setter(setter(Builder::limitCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limitCode").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(ServiceLimitExceededException::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD, LIMIT_CODE_FIELD, SERVICE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String resourceType;

    private final String limitCode;

    private final String serviceCode;

    private ServiceLimitExceededException(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.limitCode = builder.limitCode;
        this.serviceCode = builder.serviceCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The resource identifier of the limit that was exceeded.
     * </p>
     * 
     * @return The resource identifier of the limit that was exceeded.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The resource type of the limit that was exceeded.
     * </p>
     * 
     * @return The resource type of the limit that was exceeded.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The code of the limit that was exceeded.
     * </p>
     * 
     * @return The code of the limit that was exceeded.
     */
    public String limitCode() {
        return limitCode;
    }

    /**
     * <p>
     * The service code of the limit that was exceeded.
     * </p>
     * 
     * @return The service code of the limit that was exceeded.
     */
    public String serviceCode() {
        return serviceCode;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLimitExceededException, T> g) {
        return obj -> g.apply((ServiceLimitExceededException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLimitExceededException>,
            Route53RecoveryClusterException.Builder {
        /**
         * <p>
         * The resource identifier of the limit that was exceeded.
         * </p>
         * 
         * @param resourceId
         *        The resource identifier of the limit that was exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The resource type of the limit that was exceeded.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the limit that was exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The code of the limit that was exceeded.
         * </p>
         * 
         * @param limitCode
         *        The code of the limit that was exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitCode(String limitCode);

        /**
         * <p>
         * The service code of the limit that was exceeded.
         * </p>
         * 
         * @param serviceCode
         *        The service code of the limit that was exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends Route53RecoveryClusterException.BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private String limitCode;

        private String serviceCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLimitExceededException model) {
            super(model);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            limitCode(model.limitCode);
            serviceCode(model.serviceCode);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getLimitCode() {
            return limitCode;
        }

        public final void setLimitCode(String limitCode) {
            this.limitCode = limitCode;
        }

        @Override
        public final Builder limitCode(String limitCode) {
            this.limitCode = limitCode;
            return this;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ServiceLimitExceededException build() {
            return new ServiceLimitExceededException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
