/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycluster.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutingControl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutingControl> {
    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlPanelArn").getter(RoutingControl.getter(RoutingControl::controlPanelArn)).setter(RoutingControl.setter(Builder::controlPanelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()}).build();
    private static final SdkField<String> CONTROL_PANEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlPanelName").getter(RoutingControl.getter(RoutingControl::controlPanelName)).setter(RoutingControl.setter(Builder::controlPanelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelName").build()}).build();
    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingControlArn").getter(RoutingControl.getter(RoutingControl::routingControlArn)).setter(RoutingControl.setter(Builder::routingControlArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlArn").build()}).build();
    private static final SdkField<String> ROUTING_CONTROL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingControlName").getter(RoutingControl.getter(RoutingControl::routingControlName)).setter(RoutingControl.setter(Builder::routingControlName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlName").build()}).build();
    private static final SdkField<String> ROUTING_CONTROL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingControlState").getter(RoutingControl.getter(RoutingControl::routingControlStateAsString)).setter(RoutingControl.setter(Builder::routingControlState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlState").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(RoutingControl.getter(RoutingControl::owner)).setter(RoutingControl.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_PANEL_ARN_FIELD, CONTROL_PANEL_NAME_FIELD, ROUTING_CONTROL_ARN_FIELD, ROUTING_CONTROL_NAME_FIELD, ROUTING_CONTROL_STATE_FIELD, OWNER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String controlPanelArn;
    private final String controlPanelName;
    private final String routingControlArn;
    private final String routingControlName;
    private final String routingControlState;
    private final String owner;

    private RoutingControl(BuilderImpl builder) {
        this.controlPanelArn = builder.controlPanelArn;
        this.controlPanelName = builder.controlPanelName;
        this.routingControlArn = builder.routingControlArn;
        this.routingControlName = builder.routingControlName;
        this.routingControlState = builder.routingControlState;
        this.owner = builder.owner;
    }

    public final String controlPanelArn() {
        return this.controlPanelArn;
    }

    public final String controlPanelName() {
        return this.controlPanelName;
    }

    public final String routingControlArn() {
        return this.routingControlArn;
    }

    public final String routingControlName() {
        return this.routingControlName;
    }

    public final RoutingControlState routingControlState() {
        return RoutingControlState.fromValue(this.routingControlState);
    }

    public final String routingControlStateAsString() {
        return this.routingControlState;
    }

    public final String owner() {
        return this.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlPanelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingControlName());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingControlStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingControl)) {
            return false;
        }
        RoutingControl other = (RoutingControl)obj;
        return Objects.equals(this.controlPanelArn(), other.controlPanelArn()) && Objects.equals(this.controlPanelName(), other.controlPanelName()) && Objects.equals(this.routingControlArn(), other.routingControlArn()) && Objects.equals(this.routingControlName(), other.routingControlName()) && Objects.equals(this.routingControlStateAsString(), other.routingControlStateAsString()) && Objects.equals(this.owner(), other.owner());
    }

    public final String toString() {
        return ToString.builder((String)"RoutingControl").add("ControlPanelArn", (Object)this.controlPanelArn()).add("ControlPanelName", (Object)this.controlPanelName()).add("RoutingControlArn", (Object)this.routingControlArn()).add("RoutingControlName", (Object)this.routingControlName()).add("RoutingControlState", (Object)this.routingControlStateAsString()).add("Owner", (Object)this.owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ControlPanelArn": {
                return Optional.ofNullable(clazz.cast(this.controlPanelArn()));
            }
            case "ControlPanelName": {
                return Optional.ofNullable(clazz.cast(this.controlPanelName()));
            }
            case "RoutingControlArn": {
                return Optional.ofNullable(clazz.cast(this.routingControlArn()));
            }
            case "RoutingControlName": {
                return Optional.ofNullable(clazz.cast(this.routingControlName()));
            }
            case "RoutingControlState": {
                return Optional.ofNullable(clazz.cast(this.routingControlStateAsString()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoutingControl, T> g) {
        return obj -> g.apply((RoutingControl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String controlPanelArn;
        private String controlPanelName;
        private String routingControlArn;
        private String routingControlName;
        private String routingControlState;
        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingControl model) {
            this.controlPanelArn(model.controlPanelArn);
            this.controlPanelName(model.controlPanelName);
            this.routingControlArn(model.routingControlArn);
            this.routingControlName(model.routingControlName);
            this.routingControlState(model.routingControlState);
            this.owner(model.owner);
        }

        public final String getControlPanelArn() {
            return this.controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final String getControlPanelName() {
            return this.controlPanelName;
        }

        public final void setControlPanelName(String controlPanelName) {
            this.controlPanelName = controlPanelName;
        }

        @Override
        public final Builder controlPanelName(String controlPanelName) {
            this.controlPanelName = controlPanelName;
            return this;
        }

        public final String getRoutingControlArn() {
            return this.routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        public final String getRoutingControlName() {
            return this.routingControlName;
        }

        public final void setRoutingControlName(String routingControlName) {
            this.routingControlName = routingControlName;
        }

        @Override
        public final Builder routingControlName(String routingControlName) {
            this.routingControlName = routingControlName;
            return this;
        }

        public final String getRoutingControlState() {
            return this.routingControlState;
        }

        public final void setRoutingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
        }

        @Override
        public final Builder routingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
            return this;
        }

        @Override
        public final Builder routingControlState(RoutingControlState routingControlState) {
            this.routingControlState(routingControlState == null ? null : routingControlState.toString());
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public RoutingControl build() {
            return new RoutingControl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutingControl> {
        public Builder controlPanelArn(String var1);

        public Builder controlPanelName(String var1);

        public Builder routingControlArn(String var1);

        public Builder routingControlName(String var1);

        public Builder routingControlState(String var1);

        public Builder routingControlState(RoutingControlState var1);

        public Builder owner(String var1);
    }
}

