/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycluster.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoverycluster.model.Route53RecoveryClusterResponse;
import software.amazon.awssdk.services.route53recoverycluster.model.RoutingControl;
import software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoutingControlsResponse
extends Route53RecoveryClusterResponse
implements ToCopyableBuilder<Builder, ListRoutingControlsResponse> {
    private static final SdkField<List<RoutingControl>> ROUTING_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutingControls").getter(ListRoutingControlsResponse.getter(ListRoutingControlsResponse::routingControls)).setter(ListRoutingControlsResponse.setter(Builder::routingControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRoutingControlsResponse.getter(ListRoutingControlsResponse::nextToken)).setter(ListRoutingControlsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_CONTROLS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RoutingControls", ROUTING_CONTROLS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<RoutingControl> routingControls;
    private final String nextToken;

    private ListRoutingControlsResponse(BuilderImpl builder) {
        super(builder);
        this.routingControls = builder.routingControls;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRoutingControls() {
        return this.routingControls != null && !(this.routingControls instanceof SdkAutoConstructList);
    }

    public final List<RoutingControl> routingControls() {
        return this.routingControls;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingControls() ? this.routingControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutingControlsResponse)) {
            return false;
        }
        ListRoutingControlsResponse other = (ListRoutingControlsResponse)((Object)obj);
        return this.hasRoutingControls() == other.hasRoutingControls() && Objects.equals(this.routingControls(), other.routingControls()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRoutingControlsResponse").add("RoutingControls", this.hasRoutingControls() ? this.routingControls() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutingControls": {
                return Optional.ofNullable(clazz.cast(this.routingControls()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRoutingControlsResponse, T> g) {
        return obj -> g.apply((ListRoutingControlsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryClusterResponse.BuilderImpl
    implements Builder {
        private List<RoutingControl> routingControls = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoutingControlsResponse model) {
            super(model);
            this.routingControls(model.routingControls);
            this.nextToken(model.nextToken);
        }

        public final List<RoutingControl.Builder> getRoutingControls() {
            List<RoutingControl.Builder> result = RoutingControlsCopier.copyToBuilder(this.routingControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingControls(Collection<RoutingControl.BuilderImpl> routingControls) {
            this.routingControls = RoutingControlsCopier.copyFromBuilder(routingControls);
        }

        @Override
        public final Builder routingControls(Collection<RoutingControl> routingControls) {
            this.routingControls = RoutingControlsCopier.copy(routingControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingControls(RoutingControl ... routingControls) {
            this.routingControls(Arrays.asList(routingControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingControls(Consumer<RoutingControl.Builder> ... routingControls) {
            this.routingControls(Stream.of(routingControls).map(c -> (RoutingControl)((RoutingControl.Builder)RoutingControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRoutingControlsResponse build() {
            return new ListRoutingControlsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53RecoveryClusterResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoutingControlsResponse> {
        public Builder routingControls(Collection<RoutingControl> var1);

        public Builder routingControls(RoutingControl ... var1);

        public Builder routingControls(Consumer<RoutingControl.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

