/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycluster.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A routing control state entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRoutingControlStateEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateRoutingControlStateEntry.Builder, UpdateRoutingControlStateEntry> {
    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlArn").getter(getter(UpdateRoutingControlStateEntry::routingControlArn))
            .setter(setter(Builder::routingControlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlArn").build()).build();

    private static final SdkField<String> ROUTING_CONTROL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlState").getter(getter(UpdateRoutingControlStateEntry::routingControlStateAsString))
            .setter(setter(Builder::routingControlState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_CONTROL_ARN_FIELD,
            ROUTING_CONTROL_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String routingControlArn;

    private final String routingControlState;

    private UpdateRoutingControlStateEntry(BuilderImpl builder) {
        this.routingControlArn = builder.routingControlArn;
        this.routingControlState = builder.routingControlState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a routing control state entry.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a routing control state entry.
     */
    public final String routingControlArn() {
        return routingControlArn;
    }

    /**
     * <p>
     * The routing control state in a set of routing control state entries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routingControlState} will return {@link RoutingControlState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #routingControlStateAsString}.
     * </p>
     * 
     * @return The routing control state in a set of routing control state entries.
     * @see RoutingControlState
     */
    public final RoutingControlState routingControlState() {
        return RoutingControlState.fromValue(routingControlState);
    }

    /**
     * <p>
     * The routing control state in a set of routing control state entries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routingControlState} will return {@link RoutingControlState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #routingControlStateAsString}.
     * </p>
     * 
     * @return The routing control state in a set of routing control state entries.
     * @see RoutingControlState
     */
    public final String routingControlStateAsString() {
        return routingControlState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(routingControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(routingControlStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingControlStateEntry)) {
            return false;
        }
        UpdateRoutingControlStateEntry other = (UpdateRoutingControlStateEntry) obj;
        return Objects.equals(routingControlArn(), other.routingControlArn())
                && Objects.equals(routingControlStateAsString(), other.routingControlStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRoutingControlStateEntry").add("RoutingControlArn", routingControlArn())
                .add("RoutingControlState", routingControlStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoutingControlArn":
            return Optional.ofNullable(clazz.cast(routingControlArn()));
        case "RoutingControlState":
            return Optional.ofNullable(clazz.cast(routingControlStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoutingControlArn", ROUTING_CONTROL_ARN_FIELD);
        map.put("RoutingControlState", ROUTING_CONTROL_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoutingControlStateEntry, T> g) {
        return obj -> g.apply((UpdateRoutingControlStateEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateRoutingControlStateEntry> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for a routing control state entry.
         * </p>
         * 
         * @param routingControlArn
         *        The Amazon Resource Name (ARN) for a routing control state entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingControlArn(String routingControlArn);

        /**
         * <p>
         * The routing control state in a set of routing control state entries.
         * </p>
         * 
         * @param routingControlState
         *        The routing control state in a set of routing control state entries.
         * @see RoutingControlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingControlState
         */
        Builder routingControlState(String routingControlState);

        /**
         * <p>
         * The routing control state in a set of routing control state entries.
         * </p>
         * 
         * @param routingControlState
         *        The routing control state in a set of routing control state entries.
         * @see RoutingControlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingControlState
         */
        Builder routingControlState(RoutingControlState routingControlState);
    }

    static final class BuilderImpl implements Builder {
        private String routingControlArn;

        private String routingControlState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoutingControlStateEntry model) {
            routingControlArn(model.routingControlArn);
            routingControlState(model.routingControlState);
        }

        public final String getRoutingControlArn() {
            return routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        public final String getRoutingControlState() {
            return routingControlState;
        }

        public final void setRoutingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
        }

        @Override
        public final Builder routingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
            return this;
        }

        @Override
        public final Builder routingControlState(RoutingControlState routingControlState) {
            this.routingControlState(routingControlState == null ? null : routingControlState.toString());
            return this;
        }

        @Override
        public UpdateRoutingControlStateEntry build() {
            return new UpdateRoutingControlStateEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
