/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycluster.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A routing control, which is a simple on/off switch that you can use to route traffic to cells. When a routing control
 * state is set to ON, traffic flows to a cell. When the state is set to OFF, traffic does not flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingControl implements SdkPojo, Serializable, ToCopyableBuilder<RoutingControl.Builder, RoutingControl> {
    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlPanelArn").getter(getter(RoutingControl::controlPanelArn))
            .setter(setter(Builder::controlPanelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()).build();

    private static final SdkField<String> CONTROL_PANEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlPanelName").getter(getter(RoutingControl::controlPanelName))
            .setter(setter(Builder::controlPanelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelName").build()).build();

    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlArn").getter(getter(RoutingControl::routingControlArn))
            .setter(setter(Builder::routingControlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlArn").build()).build();

    private static final SdkField<String> ROUTING_CONTROL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlName").getter(getter(RoutingControl::routingControlName))
            .setter(setter(Builder::routingControlName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlName").build())
            .build();

    private static final SdkField<String> ROUTING_CONTROL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlState").getter(getter(RoutingControl::routingControlStateAsString))
            .setter(setter(Builder::routingControlState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlState").build())
            .build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(RoutingControl::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_PANEL_ARN_FIELD,
            CONTROL_PANEL_NAME_FIELD, ROUTING_CONTROL_ARN_FIELD, ROUTING_CONTROL_NAME_FIELD, ROUTING_CONTROL_STATE_FIELD,
            OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String controlPanelArn;

    private final String controlPanelName;

    private final String routingControlArn;

    private final String routingControlName;

    private final String routingControlState;

    private final String owner;

    private RoutingControl(BuilderImpl builder) {
        this.controlPanelArn = builder.controlPanelArn;
        this.controlPanelName = builder.controlPanelName;
        this.routingControlArn = builder.routingControlArn;
        this.routingControlName = builder.routingControlName;
        this.routingControlState = builder.routingControlState;
        this.owner = builder.owner;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the control panel where the routing control is located.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the control panel where the routing control is located.
     */
    public final String controlPanelArn() {
        return controlPanelArn;
    }

    /**
     * <p>
     * The name of the control panel where the routing control is located. Only ASCII characters are supported for
     * control panel names.
     * </p>
     * 
     * @return The name of the control panel where the routing control is located. Only ASCII characters are supported
     *         for control panel names.
     */
    public final String controlPanelName() {
        return controlPanelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the routing control.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the routing control.
     */
    public final String routingControlArn() {
        return routingControlArn;
    }

    /**
     * <p>
     * The name of the routing control.
     * </p>
     * 
     * @return The name of the routing control.
     */
    public final String routingControlName() {
        return routingControlName;
    }

    /**
     * <p>
     * The current state of the routing control. When a routing control state is set to ON, traffic flows to a cell.
     * When the state is set to OFF, traffic does not flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routingControlState} will return {@link RoutingControlState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #routingControlStateAsString}.
     * </p>
     * 
     * @return The current state of the routing control. When a routing control state is set to ON, traffic flows to a
     *         cell. When the state is set to OFF, traffic does not flow.
     * @see RoutingControlState
     */
    public final RoutingControlState routingControlState() {
        return RoutingControlState.fromValue(routingControlState);
    }

    /**
     * <p>
     * The current state of the routing control. When a routing control state is set to ON, traffic flows to a cell.
     * When the state is set to OFF, traffic does not flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routingControlState} will return {@link RoutingControlState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #routingControlStateAsString}.
     * </p>
     * 
     * @return The current state of the routing control. When a routing control state is set to ON, traffic flows to a
     *         cell. When the state is set to OFF, traffic does not flow.
     * @see RoutingControlState
     */
    public final String routingControlStateAsString() {
        return routingControlState;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the routing control owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the routing control owner.
     */
    public final String owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(controlPanelName());
        hashCode = 31 * hashCode + Objects.hashCode(routingControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(routingControlName());
        hashCode = 31 * hashCode + Objects.hashCode(routingControlStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingControl)) {
            return false;
        }
        RoutingControl other = (RoutingControl) obj;
        return Objects.equals(controlPanelArn(), other.controlPanelArn())
                && Objects.equals(controlPanelName(), other.controlPanelName())
                && Objects.equals(routingControlArn(), other.routingControlArn())
                && Objects.equals(routingControlName(), other.routingControlName())
                && Objects.equals(routingControlStateAsString(), other.routingControlStateAsString())
                && Objects.equals(owner(), other.owner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingControl").add("ControlPanelArn", controlPanelArn())
                .add("ControlPanelName", controlPanelName()).add("RoutingControlArn", routingControlArn())
                .add("RoutingControlName", routingControlName()).add("RoutingControlState", routingControlStateAsString())
                .add("Owner", owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlPanelArn":
            return Optional.ofNullable(clazz.cast(controlPanelArn()));
        case "ControlPanelName":
            return Optional.ofNullable(clazz.cast(controlPanelName()));
        case "RoutingControlArn":
            return Optional.ofNullable(clazz.cast(routingControlArn()));
        case "RoutingControlName":
            return Optional.ofNullable(clazz.cast(routingControlName()));
        case "RoutingControlState":
            return Optional.ofNullable(clazz.cast(routingControlStateAsString()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ControlPanelArn", CONTROL_PANEL_ARN_FIELD);
        map.put("ControlPanelName", CONTROL_PANEL_NAME_FIELD);
        map.put("RoutingControlArn", ROUTING_CONTROL_ARN_FIELD);
        map.put("RoutingControlName", ROUTING_CONTROL_NAME_FIELD);
        map.put("RoutingControlState", ROUTING_CONTROL_STATE_FIELD);
        map.put("Owner", OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingControl, T> g) {
        return obj -> g.apply((RoutingControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingControl> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the control panel where the routing control is located.
         * </p>
         * 
         * @param controlPanelArn
         *        The Amazon Resource Name (ARN) of the control panel where the routing control is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPanelArn(String controlPanelArn);

        /**
         * <p>
         * The name of the control panel where the routing control is located. Only ASCII characters are supported for
         * control panel names.
         * </p>
         * 
         * @param controlPanelName
         *        The name of the control panel where the routing control is located. Only ASCII characters are
         *        supported for control panel names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPanelName(String controlPanelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the routing control.
         * </p>
         * 
         * @param routingControlArn
         *        The Amazon Resource Name (ARN) of the routing control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingControlArn(String routingControlArn);

        /**
         * <p>
         * The name of the routing control.
         * </p>
         * 
         * @param routingControlName
         *        The name of the routing control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingControlName(String routingControlName);

        /**
         * <p>
         * The current state of the routing control. When a routing control state is set to ON, traffic flows to a cell.
         * When the state is set to OFF, traffic does not flow.
         * </p>
         * 
         * @param routingControlState
         *        The current state of the routing control. When a routing control state is set to ON, traffic flows to
         *        a cell. When the state is set to OFF, traffic does not flow.
         * @see RoutingControlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingControlState
         */
        Builder routingControlState(String routingControlState);

        /**
         * <p>
         * The current state of the routing control. When a routing control state is set to ON, traffic flows to a cell.
         * When the state is set to OFF, traffic does not flow.
         * </p>
         * 
         * @param routingControlState
         *        The current state of the routing control. When a routing control state is set to ON, traffic flows to
         *        a cell. When the state is set to OFF, traffic does not flow.
         * @see RoutingControlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingControlState
         */
        Builder routingControlState(RoutingControlState routingControlState);

        /**
         * <p>
         * The Amazon Web Services account ID of the routing control owner.
         * </p>
         * 
         * @param owner
         *        The Amazon Web Services account ID of the routing control owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);
    }

    static final class BuilderImpl implements Builder {
        private String controlPanelArn;

        private String controlPanelName;

        private String routingControlArn;

        private String routingControlName;

        private String routingControlState;

        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingControl model) {
            controlPanelArn(model.controlPanelArn);
            controlPanelName(model.controlPanelName);
            routingControlArn(model.routingControlArn);
            routingControlName(model.routingControlName);
            routingControlState(model.routingControlState);
            owner(model.owner);
        }

        public final String getControlPanelArn() {
            return controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final String getControlPanelName() {
            return controlPanelName;
        }

        public final void setControlPanelName(String controlPanelName) {
            this.controlPanelName = controlPanelName;
        }

        @Override
        public final Builder controlPanelName(String controlPanelName) {
            this.controlPanelName = controlPanelName;
            return this;
        }

        public final String getRoutingControlArn() {
            return routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        public final String getRoutingControlName() {
            return routingControlName;
        }

        public final void setRoutingControlName(String routingControlName) {
            this.routingControlName = routingControlName;
        }

        @Override
        public final Builder routingControlName(String routingControlName) {
            this.routingControlName = routingControlName;
            return this;
        }

        public final String getRoutingControlState() {
            return routingControlState;
        }

        public final void setRoutingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
        }

        @Override
        public final Builder routingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
            return this;
        }

        @Override
        public final Builder routingControlState(RoutingControlState routingControlState) {
            this.routingControlState(routingControlState == null ? null : routingControlState.toString());
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public RoutingControl build() {
            return new RoutingControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
