/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeControlPanelRequest extends Route53RecoveryControlConfigRequest implements
        ToCopyableBuilder<DescribeControlPanelRequest.Builder, DescribeControlPanelRequest> {
    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlPanelArn").getter(getter(DescribeControlPanelRequest::controlPanelArn))
            .setter(setter(Builder::controlPanelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ControlPanelArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_PANEL_ARN_FIELD));

    private final String controlPanelArn;

    private DescribeControlPanelRequest(BuilderImpl builder) {
        super(builder);
        this.controlPanelArn = builder.controlPanelArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the control panel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the control panel.
     */
    public final String controlPanelArn() {
        return controlPanelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(controlPanelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeControlPanelRequest)) {
            return false;
        }
        DescribeControlPanelRequest other = (DescribeControlPanelRequest) obj;
        return Objects.equals(controlPanelArn(), other.controlPanelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeControlPanelRequest").add("ControlPanelArn", controlPanelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlPanelArn":
            return Optional.ofNullable(clazz.cast(controlPanelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeControlPanelRequest, T> g) {
        return obj -> g.apply((DescribeControlPanelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryControlConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeControlPanelRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the control panel.
         * </p>
         * 
         * @param controlPanelArn
         *        The Amazon Resource Name (ARN) of the control panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPanelArn(String controlPanelArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryControlConfigRequest.BuilderImpl implements Builder {
        private String controlPanelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeControlPanelRequest model) {
            super(model);
            controlPanelArn(model.controlPanelArn);
        }

        public final String getControlPanelArn() {
            return controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        @Transient
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeControlPanelRequest build() {
            return new DescribeControlPanelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
