/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A new assertion rule for a control panel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewAssertionRule implements SdkPojo, Serializable,
        ToCopyableBuilder<NewAssertionRule.Builder, NewAssertionRule> {
    private static final SdkField<List<String>> ASSERTED_CONTROLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssertedControls")
            .getter(getter(NewAssertionRule::assertedControls))
            .setter(setter(Builder::assertedControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssertedControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlPanelArn").getter(getter(NewAssertionRule::controlPanelArn))
            .setter(setter(Builder::controlPanelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(NewAssertionRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<RuleConfig> RULE_CONFIG_FIELD = SdkField.<RuleConfig> builder(MarshallingType.SDK_POJO)
            .memberName("RuleConfig").getter(getter(NewAssertionRule::ruleConfig)).setter(setter(Builder::ruleConfig))
            .constructor(RuleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleConfig").build()).build();

    private static final SdkField<Integer> WAIT_PERIOD_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WaitPeriodMs").getter(getter(NewAssertionRule::waitPeriodMs)).setter(setter(Builder::waitPeriodMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitPeriodMs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSERTED_CONTROLS_FIELD,
            CONTROL_PANEL_ARN_FIELD, NAME_FIELD, RULE_CONFIG_FIELD, WAIT_PERIOD_MS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> assertedControls;

    private final String controlPanelArn;

    private final String name;

    private final RuleConfig ruleConfig;

    private final Integer waitPeriodMs;

    private NewAssertionRule(BuilderImpl builder) {
        this.assertedControls = builder.assertedControls;
        this.controlPanelArn = builder.controlPanelArn;
        this.name = builder.name;
        this.ruleConfig = builder.ruleConfig;
        this.waitPeriodMs = builder.waitPeriodMs;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssertedControls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssertedControls() {
        return assertedControls != null && !(assertedControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routing controls that are part of transactions that are evaluated to determine if a request to change a
     * routing control state is allowed. For example, you might include three routing controls, one for each of three
     * Amazon Web Services Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssertedControls} method.
     * </p>
     * 
     * @return The routing controls that are part of transactions that are evaluated to determine if a request to change
     *         a routing control state is allowed. For example, you might include three routing controls, one for each
     *         of three Amazon Web Services Regions.
     */
    public final List<String> assertedControls() {
        return assertedControls;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the control panel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the control panel.
     */
    public final String controlPanelArn() {
        return controlPanelArn;
    }

    /**
     * <p>
     * The name of the assertion rule. You can use any non-white space character in the name.
     * </p>
     * 
     * @return The name of the assertion rule. You can use any non-white space character in the name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The criteria that you set for specific assertion controls (routing controls) that designate how many control
     * states must be ON as the result of a transaction. For example, if you have three assertion controls, you might
     * specify ATLEAST 2for your rule configuration. This means that at least two assertion controls must be ON, so that
     * at least two Amazon Web Services Regions have traffic flowing to them.
     * </p>
     * 
     * @return The criteria that you set for specific assertion controls (routing controls) that designate how many
     *         control states must be ON as the result of a transaction. For example, if you have three assertion
     *         controls, you might specify ATLEAST 2for your rule configuration. This means that at least two assertion
     *         controls must be ON, so that at least two Amazon Web Services Regions have traffic flowing to them.
     */
    public final RuleConfig ruleConfig() {
        return ruleConfig;
    }

    /**
     * <p>
     * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will
     * fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom
     * value.
     * </p>
     * 
     * @return An evaluation period, in milliseconds (ms), during which any request against the target routing controls
     *         will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can
     *         choose a custom value.
     */
    public final Integer waitPeriodMs() {
        return waitPeriodMs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssertedControls() ? assertedControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(waitPeriodMs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewAssertionRule)) {
            return false;
        }
        NewAssertionRule other = (NewAssertionRule) obj;
        return hasAssertedControls() == other.hasAssertedControls()
                && Objects.equals(assertedControls(), other.assertedControls())
                && Objects.equals(controlPanelArn(), other.controlPanelArn()) && Objects.equals(name(), other.name())
                && Objects.equals(ruleConfig(), other.ruleConfig()) && Objects.equals(waitPeriodMs(), other.waitPeriodMs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NewAssertionRule").add("AssertedControls", hasAssertedControls() ? assertedControls() : null)
                .add("ControlPanelArn", controlPanelArn()).add("Name", name()).add("RuleConfig", ruleConfig())
                .add("WaitPeriodMs", waitPeriodMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssertedControls":
            return Optional.ofNullable(clazz.cast(assertedControls()));
        case "ControlPanelArn":
            return Optional.ofNullable(clazz.cast(controlPanelArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuleConfig":
            return Optional.ofNullable(clazz.cast(ruleConfig()));
        case "WaitPeriodMs":
            return Optional.ofNullable(clazz.cast(waitPeriodMs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NewAssertionRule, T> g) {
        return obj -> g.apply((NewAssertionRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NewAssertionRule> {
        /**
         * <p>
         * The routing controls that are part of transactions that are evaluated to determine if a request to change a
         * routing control state is allowed. For example, you might include three routing controls, one for each of
         * three Amazon Web Services Regions.
         * </p>
         * 
         * @param assertedControls
         *        The routing controls that are part of transactions that are evaluated to determine if a request to
         *        change a routing control state is allowed. For example, you might include three routing controls, one
         *        for each of three Amazon Web Services Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assertedControls(Collection<String> assertedControls);

        /**
         * <p>
         * The routing controls that are part of transactions that are evaluated to determine if a request to change a
         * routing control state is allowed. For example, you might include three routing controls, one for each of
         * three Amazon Web Services Regions.
         * </p>
         * 
         * @param assertedControls
         *        The routing controls that are part of transactions that are evaluated to determine if a request to
         *        change a routing control state is allowed. For example, you might include three routing controls, one
         *        for each of three Amazon Web Services Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assertedControls(String... assertedControls);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the control panel.
         * </p>
         * 
         * @param controlPanelArn
         *        The Amazon Resource Name (ARN) for the control panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPanelArn(String controlPanelArn);

        /**
         * <p>
         * The name of the assertion rule. You can use any non-white space character in the name.
         * </p>
         * 
         * @param name
         *        The name of the assertion rule. You can use any non-white space character in the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The criteria that you set for specific assertion controls (routing controls) that designate how many control
         * states must be ON as the result of a transaction. For example, if you have three assertion controls, you
         * might specify ATLEAST 2for your rule configuration. This means that at least two assertion controls must be
         * ON, so that at least two Amazon Web Services Regions have traffic flowing to them.
         * </p>
         * 
         * @param ruleConfig
         *        The criteria that you set for specific assertion controls (routing controls) that designate how many
         *        control states must be ON as the result of a transaction. For example, if you have three assertion
         *        controls, you might specify ATLEAST 2for your rule configuration. This means that at least two
         *        assertion controls must be ON, so that at least two Amazon Web Services Regions have traffic flowing
         *        to them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleConfig(RuleConfig ruleConfig);

        /**
         * <p>
         * The criteria that you set for specific assertion controls (routing controls) that designate how many control
         * states must be ON as the result of a transaction. For example, if you have three assertion controls, you
         * might specify ATLEAST 2for your rule configuration. This means that at least two assertion controls must be
         * ON, so that at least two Amazon Web Services Regions have traffic flowing to them.
         * </p>
         * This is a convenience that creates an instance of the {@link RuleConfig.Builder} avoiding the need to create
         * one manually via {@link RuleConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #ruleConfig(RuleConfig)}.
         * 
         * @param ruleConfig
         *        a consumer that will call methods on {@link RuleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleConfig(RuleConfig)
         */
        default Builder ruleConfig(Consumer<RuleConfig.Builder> ruleConfig) {
            return ruleConfig(RuleConfig.builder().applyMutation(ruleConfig).build());
        }

        /**
         * <p>
         * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will
         * fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a
         * custom value.
         * </p>
         * 
         * @param waitPeriodMs
         *        An evaluation period, in milliseconds (ms), during which any request against the target routing
         *        controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but
         *        you can choose a custom value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitPeriodMs(Integer waitPeriodMs);
    }

    static final class BuilderImpl implements Builder {
        private List<String> assertedControls = DefaultSdkAutoConstructList.getInstance();

        private String controlPanelArn;

        private String name;

        private RuleConfig ruleConfig;

        private Integer waitPeriodMs;

        private BuilderImpl() {
        }

        private BuilderImpl(NewAssertionRule model) {
            assertedControls(model.assertedControls);
            controlPanelArn(model.controlPanelArn);
            name(model.name);
            ruleConfig(model.ruleConfig);
            waitPeriodMs(model.waitPeriodMs);
        }

        public final Collection<String> getAssertedControls() {
            if (assertedControls instanceof SdkAutoConstructList) {
                return null;
            }
            return assertedControls;
        }

        public final void setAssertedControls(Collection<String> assertedControls) {
            this.assertedControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(assertedControls);
        }

        @Override
        @Transient
        public final Builder assertedControls(Collection<String> assertedControls) {
            this.assertedControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(assertedControls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assertedControls(String... assertedControls) {
            assertedControls(Arrays.asList(assertedControls));
            return this;
        }

        public final String getControlPanelArn() {
            return controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        @Transient
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleConfig.Builder getRuleConfig() {
            return ruleConfig != null ? ruleConfig.toBuilder() : null;
        }

        public final void setRuleConfig(RuleConfig.BuilderImpl ruleConfig) {
            this.ruleConfig = ruleConfig != null ? ruleConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder ruleConfig(RuleConfig ruleConfig) {
            this.ruleConfig = ruleConfig;
            return this;
        }

        public final Integer getWaitPeriodMs() {
            return waitPeriodMs;
        }

        public final void setWaitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
        }

        @Override
        @Transient
        public final Builder waitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
            return this;
        }

        @Override
        public NewAssertionRule build() {
            return new NewAssertionRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
