/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A new gating rule for a control panel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewGatingRule implements SdkPojo, Serializable, ToCopyableBuilder<NewGatingRule.Builder, NewGatingRule> {
    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlPanelArn").getter(getter(NewGatingRule::controlPanelArn))
            .setter(setter(Builder::controlPanelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()).build();

    private static final SdkField<List<String>> GATING_CONTROLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GatingControls")
            .getter(getter(NewGatingRule::gatingControls))
            .setter(setter(Builder::gatingControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatingControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(NewGatingRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<RuleConfig> RULE_CONFIG_FIELD = SdkField.<RuleConfig> builder(MarshallingType.SDK_POJO)
            .memberName("RuleConfig").getter(getter(NewGatingRule::ruleConfig)).setter(setter(Builder::ruleConfig))
            .constructor(RuleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleConfig").build()).build();

    private static final SdkField<List<String>> TARGET_CONTROLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetControls")
            .getter(getter(NewGatingRule::targetControls))
            .setter(setter(Builder::targetControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> WAIT_PERIOD_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WaitPeriodMs").getter(getter(NewGatingRule::waitPeriodMs)).setter(setter(Builder::waitPeriodMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitPeriodMs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_PANEL_ARN_FIELD,
            GATING_CONTROLS_FIELD, NAME_FIELD, RULE_CONFIG_FIELD, TARGET_CONTROLS_FIELD, WAIT_PERIOD_MS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String controlPanelArn;

    private final List<String> gatingControls;

    private final String name;

    private final RuleConfig ruleConfig;

    private final List<String> targetControls;

    private final Integer waitPeriodMs;

    private NewGatingRule(BuilderImpl builder) {
        this.controlPanelArn = builder.controlPanelArn;
        this.gatingControls = builder.gatingControls;
        this.name = builder.name;
        this.ruleConfig = builder.ruleConfig;
        this.targetControls = builder.targetControls;
        this.waitPeriodMs = builder.waitPeriodMs;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the control panel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the control panel.
     */
    public final String controlPanelArn() {
        return controlPanelArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the GatingControls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGatingControls() {
        return gatingControls != null && !(gatingControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The gating controls for the new gating rule. That is, routing controls that are evaluated by the rule
     * configuration that you specify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGatingControls} method.
     * </p>
     * 
     * @return The gating controls for the new gating rule. That is, routing controls that are evaluated by the rule
     *         configuration that you specify.
     */
    public final List<String> gatingControls() {
        return gatingControls;
    }

    /**
     * <p>
     * The name for the new gating rule.
     * </p>
     * 
     * @return The name for the new gating rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The criteria that you set for specific gating controls (routing controls) that designates how many control states
     * must be ON to allow you to change (set or unset) the target control states.
     * </p>
     * 
     * @return The criteria that you set for specific gating controls (routing controls) that designates how many
     *         control states must be ON to allow you to change (set or unset) the target control states.
     */
    public final RuleConfig ruleConfig() {
        return ruleConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetControls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetControls() {
        return targetControls != null && !(targetControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified
     * GatingControls. For example, say you have three gating controls, one for each of three Amazon Web Services
     * Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only change (set or unset)
     * the routing controls that you have specified as TargetControls if that rule evaluates to true.
     * </p>
     * <p>
     * In other words, your ability to change the routing controls that you have specified as TargetControls is gated by
     * the rule that you set for the routing controls in GatingControls.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetControls} method.
     * </p>
     * 
     * @return Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the
     *         specified GatingControls. For example, say you have three gating controls, one for each of three Amazon
     *         Web Services Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only
     *         change (set or unset) the routing controls that you have specified as TargetControls if that rule
     *         evaluates to true.</p>
     *         <p>
     *         In other words, your ability to change the routing controls that you have specified as TargetControls is
     *         gated by the rule that you set for the routing controls in GatingControls.
     */
    public final List<String> targetControls() {
        return targetControls;
    }

    /**
     * <p>
     * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will
     * fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom
     * value.
     * </p>
     * 
     * @return An evaluation period, in milliseconds (ms), during which any request against the target routing controls
     *         will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can
     *         choose a custom value.
     */
    public final Integer waitPeriodMs() {
        return waitPeriodMs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasGatingControls() ? gatingControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetControls() ? targetControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(waitPeriodMs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewGatingRule)) {
            return false;
        }
        NewGatingRule other = (NewGatingRule) obj;
        return Objects.equals(controlPanelArn(), other.controlPanelArn()) && hasGatingControls() == other.hasGatingControls()
                && Objects.equals(gatingControls(), other.gatingControls()) && Objects.equals(name(), other.name())
                && Objects.equals(ruleConfig(), other.ruleConfig()) && hasTargetControls() == other.hasTargetControls()
                && Objects.equals(targetControls(), other.targetControls())
                && Objects.equals(waitPeriodMs(), other.waitPeriodMs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NewGatingRule").add("ControlPanelArn", controlPanelArn())
                .add("GatingControls", hasGatingControls() ? gatingControls() : null).add("Name", name())
                .add("RuleConfig", ruleConfig()).add("TargetControls", hasTargetControls() ? targetControls() : null)
                .add("WaitPeriodMs", waitPeriodMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlPanelArn":
            return Optional.ofNullable(clazz.cast(controlPanelArn()));
        case "GatingControls":
            return Optional.ofNullable(clazz.cast(gatingControls()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuleConfig":
            return Optional.ofNullable(clazz.cast(ruleConfig()));
        case "TargetControls":
            return Optional.ofNullable(clazz.cast(targetControls()));
        case "WaitPeriodMs":
            return Optional.ofNullable(clazz.cast(waitPeriodMs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NewGatingRule, T> g) {
        return obj -> g.apply((NewGatingRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NewGatingRule> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the control panel.
         * </p>
         * 
         * @param controlPanelArn
         *        The Amazon Resource Name (ARN) of the control panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPanelArn(String controlPanelArn);

        /**
         * <p>
         * The gating controls for the new gating rule. That is, routing controls that are evaluated by the rule
         * configuration that you specify.
         * </p>
         * 
         * @param gatingControls
         *        The gating controls for the new gating rule. That is, routing controls that are evaluated by the rule
         *        configuration that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatingControls(Collection<String> gatingControls);

        /**
         * <p>
         * The gating controls for the new gating rule. That is, routing controls that are evaluated by the rule
         * configuration that you specify.
         * </p>
         * 
         * @param gatingControls
         *        The gating controls for the new gating rule. That is, routing controls that are evaluated by the rule
         *        configuration that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatingControls(String... gatingControls);

        /**
         * <p>
         * The name for the new gating rule.
         * </p>
         * 
         * @param name
         *        The name for the new gating rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The criteria that you set for specific gating controls (routing controls) that designates how many control
         * states must be ON to allow you to change (set or unset) the target control states.
         * </p>
         * 
         * @param ruleConfig
         *        The criteria that you set for specific gating controls (routing controls) that designates how many
         *        control states must be ON to allow you to change (set or unset) the target control states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleConfig(RuleConfig ruleConfig);

        /**
         * <p>
         * The criteria that you set for specific gating controls (routing controls) that designates how many control
         * states must be ON to allow you to change (set or unset) the target control states.
         * </p>
         * This is a convenience that creates an instance of the {@link RuleConfig.Builder} avoiding the need to create
         * one manually via {@link RuleConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #ruleConfig(RuleConfig)}.
         * 
         * @param ruleConfig
         *        a consumer that will call methods on {@link RuleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleConfig(RuleConfig)
         */
        default Builder ruleConfig(Consumer<RuleConfig.Builder> ruleConfig) {
            return ruleConfig(RuleConfig.builder().applyMutation(ruleConfig).build());
        }

        /**
         * <p>
         * Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the
         * specified GatingControls. For example, say you have three gating controls, one for each of three Amazon Web
         * Services Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only change (set
         * or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true.
         * </p>
         * <p>
         * In other words, your ability to change the routing controls that you have specified as TargetControls is
         * gated by the rule that you set for the routing controls in GatingControls.
         * </p>
         * 
         * @param targetControls
         *        Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the
         *        specified GatingControls. For example, say you have three gating controls, one for each of three
         *        Amazon Web Services Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you
         *        can only change (set or unset) the routing controls that you have specified as TargetControls if that
         *        rule evaluates to true.</p>
         *        <p>
         *        In other words, your ability to change the routing controls that you have specified as TargetControls
         *        is gated by the rule that you set for the routing controls in GatingControls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetControls(Collection<String> targetControls);

        /**
         * <p>
         * Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the
         * specified GatingControls. For example, say you have three gating controls, one for each of three Amazon Web
         * Services Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only change (set
         * or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true.
         * </p>
         * <p>
         * In other words, your ability to change the routing controls that you have specified as TargetControls is
         * gated by the rule that you set for the routing controls in GatingControls.
         * </p>
         * 
         * @param targetControls
         *        Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the
         *        specified GatingControls. For example, say you have three gating controls, one for each of three
         *        Amazon Web Services Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you
         *        can only change (set or unset) the routing controls that you have specified as TargetControls if that
         *        rule evaluates to true.</p>
         *        <p>
         *        In other words, your ability to change the routing controls that you have specified as TargetControls
         *        is gated by the rule that you set for the routing controls in GatingControls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetControls(String... targetControls);

        /**
         * <p>
         * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will
         * fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a
         * custom value.
         * </p>
         * 
         * @param waitPeriodMs
         *        An evaluation period, in milliseconds (ms), during which any request against the target routing
         *        controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but
         *        you can choose a custom value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitPeriodMs(Integer waitPeriodMs);
    }

    static final class BuilderImpl implements Builder {
        private String controlPanelArn;

        private List<String> gatingControls = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private RuleConfig ruleConfig;

        private List<String> targetControls = DefaultSdkAutoConstructList.getInstance();

        private Integer waitPeriodMs;

        private BuilderImpl() {
        }

        private BuilderImpl(NewGatingRule model) {
            controlPanelArn(model.controlPanelArn);
            gatingControls(model.gatingControls);
            name(model.name);
            ruleConfig(model.ruleConfig);
            targetControls(model.targetControls);
            waitPeriodMs(model.waitPeriodMs);
        }

        public final String getControlPanelArn() {
            return controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        @Transient
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final Collection<String> getGatingControls() {
            if (gatingControls instanceof SdkAutoConstructList) {
                return null;
            }
            return gatingControls;
        }

        public final void setGatingControls(Collection<String> gatingControls) {
            this.gatingControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(gatingControls);
        }

        @Override
        @Transient
        public final Builder gatingControls(Collection<String> gatingControls) {
            this.gatingControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(gatingControls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gatingControls(String... gatingControls) {
            gatingControls(Arrays.asList(gatingControls));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleConfig.Builder getRuleConfig() {
            return ruleConfig != null ? ruleConfig.toBuilder() : null;
        }

        public final void setRuleConfig(RuleConfig.BuilderImpl ruleConfig) {
            this.ruleConfig = ruleConfig != null ? ruleConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder ruleConfig(RuleConfig ruleConfig) {
            this.ruleConfig = ruleConfig;
            return this;
        }

        public final Collection<String> getTargetControls() {
            if (targetControls instanceof SdkAutoConstructList) {
                return null;
            }
            return targetControls;
        }

        public final void setTargetControls(Collection<String> targetControls) {
            this.targetControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(targetControls);
        }

        @Override
        @Transient
        public final Builder targetControls(Collection<String> targetControls) {
            this.targetControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(targetControls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetControls(String... targetControls) {
            targetControls(Arrays.asList(targetControls));
            return this;
        }

        public final Integer getWaitPeriodMs() {
            return waitPeriodMs;
        }

        public final void setWaitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
        }

        @Override
        @Transient
        public final Builder waitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
            return this;
        }

        @Override
        public NewGatingRule build() {
            return new NewGatingRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
