/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The rule configuration for an assertion rule. That is, the criteria that you set for specific assertion controls
 * (routing controls) that specify how many control states must be ON after a transaction completes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleConfig implements SdkPojo, Serializable, ToCopyableBuilder<RuleConfig.Builder, RuleConfig> {
    private static final SdkField<Boolean> INVERTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Inverted").getter(getter(RuleConfig::inverted)).setter(setter(Builder::inverted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inverted").build()).build();

    private static final SdkField<Integer> THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Threshold").getter(getter(RuleConfig::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RuleConfig::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVERTED_FIELD,
            THRESHOLD_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean inverted;

    private final Integer threshold;

    private final String type;

    private RuleConfig(BuilderImpl builder) {
        this.inverted = builder.inverted;
        this.threshold = builder.threshold;
        this.type = builder.type;
    }

    /**
     * <p>
     * Logical negation of the rule. If the rule would usually evaluate true, it's evaluated as false, and vice versa.
     * </p>
     * 
     * @return Logical negation of the rule. If the rule would usually evaluate true, it's evaluated as false, and vice
     *         versa.
     */
    public final Boolean inverted() {
        return inverted;
    }

    /**
     * <p>
     * The value of N, when you specify an ATLEAST rule type. That is, Threshold is the number of controls that must be
     * set when you specify an ATLEAST type.
     * </p>
     * 
     * @return The value of N, when you specify an ATLEAST rule type. That is, Threshold is the number of controls that
     *         must be set when you specify an ATLEAST type.
     */
    public final Integer threshold() {
        return threshold;
    }

    /**
     * <p>
     * A rule can be one of the following: ATLEAST, AND, or OR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return A rule can be one of the following: ATLEAST, AND, or OR.
     * @see RuleType
     */
    public final RuleType type() {
        return RuleType.fromValue(type);
    }

    /**
     * <p>
     * A rule can be one of the following: ATLEAST, AND, or OR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return A rule can be one of the following: ATLEAST, AND, or OR.
     * @see RuleType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inverted());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleConfig)) {
            return false;
        }
        RuleConfig other = (RuleConfig) obj;
        return Objects.equals(inverted(), other.inverted()) && Objects.equals(threshold(), other.threshold())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleConfig").add("Inverted", inverted()).add("Threshold", threshold())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Inverted":
            return Optional.ofNullable(clazz.cast(inverted()));
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleConfig, T> g) {
        return obj -> g.apply((RuleConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleConfig> {
        /**
         * <p>
         * Logical negation of the rule. If the rule would usually evaluate true, it's evaluated as false, and vice
         * versa.
         * </p>
         * 
         * @param inverted
         *        Logical negation of the rule. If the rule would usually evaluate true, it's evaluated as false, and
         *        vice versa.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inverted(Boolean inverted);

        /**
         * <p>
         * The value of N, when you specify an ATLEAST rule type. That is, Threshold is the number of controls that must
         * be set when you specify an ATLEAST type.
         * </p>
         * 
         * @param threshold
         *        The value of N, when you specify an ATLEAST rule type. That is, Threshold is the number of controls
         *        that must be set when you specify an ATLEAST type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Integer threshold);

        /**
         * <p>
         * A rule can be one of the following: ATLEAST, AND, or OR.
         * </p>
         * 
         * @param type
         *        A rule can be one of the following: ATLEAST, AND, or OR.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder type(String type);

        /**
         * <p>
         * A rule can be one of the following: ATLEAST, AND, or OR.
         * </p>
         * 
         * @param type
         *        A rule can be one of the following: ATLEAST, AND, or OR.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder type(RuleType type);
    }

    static final class BuilderImpl implements Builder {
        private Boolean inverted;

        private Integer threshold;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleConfig model) {
            inverted(model.inverted);
            threshold(model.threshold);
            type(model.type);
        }

        public final Boolean getInverted() {
            return inverted;
        }

        public final void setInverted(Boolean inverted) {
            this.inverted = inverted;
        }

        @Override
        @Transient
        public final Builder inverted(Boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public final Integer getThreshold() {
            return threshold;
        }

        public final void setThreshold(Integer threshold) {
            this.threshold = threshold;
        }

        @Override
        @Transient
        public final Builder threshold(Integer threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(RuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RuleConfig build() {
            return new RuleConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
