/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.AccessDeniedException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ConflictException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateSafetyRuleRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateSafetyRuleResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteClusterRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteClusterResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteControlPanelRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteControlPanelResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteRoutingControlRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteRoutingControlResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteSafetyRuleRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteSafetyRuleResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeSafetyRuleRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeSafetyRuleResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.InternalServerException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ResourceNotFoundException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Route53RecoveryControlConfigException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.TagResourceRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.TagResourceResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ThrottlingException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UntagResourceRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UntagResourceResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateControlPanelRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateControlPanelResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateRoutingControlRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateRoutingControlResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ValidationException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListAssociatedRoute53HealthChecksIterable;
import software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListClustersIterable;
import software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListControlPanelsIterable;
import software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListRoutingControlsIterable;
import software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListSafetyRulesIterable;
import software.amazon.awssdk.services.route53recoverycontrolconfig.waiters.Route53RecoveryControlConfigWaiter;

/**
 * Service client for accessing AWS Route53 Recovery Control Config. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Recovery Control Configuration API Reference for Amazon Route 53 Application Recovery Controller
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Route53RecoveryControlConfigClient extends SdkClient {
    String SERVICE_NAME = "route53-recovery-control-config";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "route53-recovery-control-config";

    /**
     * Create a {@link Route53RecoveryControlConfigClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Route53RecoveryControlConfigClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Route53RecoveryControlConfigClient}.
     */
    static Route53RecoveryControlConfigClientBuilder builder() {
        return new DefaultRoute53RecoveryControlConfigClientBuilder();
    }

    /**
     * <p>
     * Create a new cluster. A cluster is a set of redundant Regional endpoints against which you can run API calls to
     * update or get the state of one or more routing controls. Each cluster has a name, status, Amazon Resource Name
     * (ARN), and an array of the five cluster endpoints (one for each supported Amazon Web Services Region) that you
     * can use with API calls to the cluster data plane.
     * </p>
     *
     * @param createClusterRequest
     *        Creates a cluster.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws ServiceQuotaExceededException
     *         402 response
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ValidationException,
            InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new cluster. A cluster is a set of redundant Regional endpoints against which you can run API calls to
     * update or get the state of one or more routing controls. Each cluster has a name, status, Amazon Resource Name
     * (ARN), and an array of the five cluster endpoints (one for each supported Amazon Web Services Region) that you
     * can use with API calls to the cluster data plane.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterRequest.Builder} to create a request.
     *        Creates a cluster.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws ServiceQuotaExceededException
     *         402 response
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest)
            throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new control panel. A control panel represents a group of routing controls that can be changed together
     * in a single transaction. You can use a control panel to centrally view the operational status of applications
     * across your organization, and trigger multi-app failovers in a single transaction, for example, to fail over an
     * Availability Zone or Amazon Web Services Region.
     * </p>
     *
     * @param createControlPanelRequest
     *        The details of the control panel that you're creating.
     * @return Result of the CreateControlPanel operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws ServiceQuotaExceededException
     *         402 response
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.CreateControlPanel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateControlPanel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateControlPanelResponse createControlPanel(CreateControlPanelRequest createControlPanelRequest)
            throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new control panel. A control panel represents a group of routing controls that can be changed together
     * in a single transaction. You can use a control panel to centrally view the operational status of applications
     * across your organization, and trigger multi-app failovers in a single transaction, for example, to fail over an
     * Availability Zone or Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateControlPanelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateControlPanelRequest#builder()}
     * </p>
     *
     * @param createControlPanelRequest
     *        A {@link Consumer} that will call methods on {@link CreateControlPanelRequest.Builder} to create a
     *        request. The details of the control panel that you're creating.
     * @return Result of the CreateControlPanel operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws ServiceQuotaExceededException
     *         402 response
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.CreateControlPanel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateControlPanel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateControlPanelResponse createControlPanel(Consumer<CreateControlPanelRequest.Builder> createControlPanelRequest)
            throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        return createControlPanel(CreateControlPanelRequest.builder().applyMutation(createControlPanelRequest).build());
    }

    /**
     * <p>
     * Creates a new routing control.
     * </p>
     * <p>
     * A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an
     * Amazon Route 53 health check, which can be used to control traffic routing.
     * </p>
     * <p>
     * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53
     * Application Recovery Controller.
     * </p>
     *
     * @param createRoutingControlRequest
     *        The details of the routing control that you're creating.
     * @return Result of the CreateRoutingControl operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws ServiceQuotaExceededException
     *         402 response
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.CreateRoutingControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateRoutingControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRoutingControlResponse createRoutingControl(CreateRoutingControlRequest createRoutingControlRequest)
            throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new routing control.
     * </p>
     * <p>
     * A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an
     * Amazon Route 53 health check, which can be used to control traffic routing.
     * </p>
     * <p>
     * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53
     * Application Recovery Controller.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoutingControlRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRoutingControlRequest#builder()}
     * </p>
     *
     * @param createRoutingControlRequest
     *        A {@link Consumer} that will call methods on {@link CreateRoutingControlRequest.Builder} to create a
     *        request. The details of the routing control that you're creating.
     * @return Result of the CreateRoutingControl operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws ServiceQuotaExceededException
     *         402 response
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.CreateRoutingControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateRoutingControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRoutingControlResponse createRoutingControl(
            Consumer<CreateRoutingControlRequest.Builder> createRoutingControlRequest) throws ValidationException,
            InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        return createRoutingControl(CreateRoutingControlRequest.builder().applyMutation(createRoutingControlRequest).build());
    }

    /**
     * <p>
     * Creates a safety rule in a control panel. Safety rules let you add safeguards around changing routing control
     * states, and for enabling and disabling routing controls, to help prevent unexpected outcomes.
     * </p>
     * <p>
     * There are two types of safety rules: assertion rules and gating rules.
     * </p>
     * <p>
     * Assertion rule: An assertion rule enforces that, when you change a routing control state, that a certain criteria
     * is met. For example, the criteria might be that at least one routing control state is On after the transation so
     * that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open
     * scenario.
     * </p>
     * <p>
     * Gating rule: A gating rule lets you configure a gating routing control as an overall "on/off" switch for a group
     * of routing controls. Or, you can configure more complex gating scenarios, for example by configuring multiple
     * gating routing controls.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.safety-rules.html">Safety rules</a> in
     * the Amazon Route 53 Application Recovery Controller Developer Guide.
     * </p>
     *
     * @param createSafetyRuleRequest
     *        The request body that you include when you create a safety rule.
     * @return Result of the CreateSafetyRule operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.CreateSafetyRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateSafetyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSafetyRuleResponse createSafetyRule(CreateSafetyRuleRequest createSafetyRuleRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a safety rule in a control panel. Safety rules let you add safeguards around changing routing control
     * states, and for enabling and disabling routing controls, to help prevent unexpected outcomes.
     * </p>
     * <p>
     * There are two types of safety rules: assertion rules and gating rules.
     * </p>
     * <p>
     * Assertion rule: An assertion rule enforces that, when you change a routing control state, that a certain criteria
     * is met. For example, the criteria might be that at least one routing control state is On after the transation so
     * that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open
     * scenario.
     * </p>
     * <p>
     * Gating rule: A gating rule lets you configure a gating routing control as an overall "on/off" switch for a group
     * of routing controls. Or, you can configure more complex gating scenarios, for example by configuring multiple
     * gating routing controls.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.safety-rules.html">Safety rules</a> in
     * the Amazon Route 53 Application Recovery Controller Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSafetyRuleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSafetyRuleRequest#builder()}
     * </p>
     *
     * @param createSafetyRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateSafetyRuleRequest.Builder} to create a request.
     *        The request body that you include when you create a safety rule.
     * @return Result of the CreateSafetyRule operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.CreateSafetyRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateSafetyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSafetyRuleResponse createSafetyRule(Consumer<CreateSafetyRuleRequest.Builder> createSafetyRuleRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        return createSafetyRule(CreateSafetyRuleRequest.builder().applyMutation(createSafetyRuleRequest).build());
    }

    /**
     * <p>
     * Delete a cluster.
     * </p>
     *
     * @param deleteClusterRequest
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterRequest.Builder} to create a request.
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Deletes a control panel.
     * </p>
     *
     * @param deleteControlPanelRequest
     * @return Result of the DeleteControlPanel operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DeleteControlPanel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteControlPanel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteControlPanelResponse deleteControlPanel(DeleteControlPanelRequest deleteControlPanelRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a control panel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteControlPanelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteControlPanelRequest#builder()}
     * </p>
     *
     * @param deleteControlPanelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteControlPanelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteControlPanel operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DeleteControlPanel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteControlPanel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteControlPanelResponse deleteControlPanel(Consumer<DeleteControlPanelRequest.Builder> deleteControlPanelRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        return deleteControlPanel(DeleteControlPanelRequest.builder().applyMutation(deleteControlPanelRequest).build());
    }

    /**
     * <p>
     * Deletes a routing control.
     * </p>
     *
     * @param deleteRoutingControlRequest
     * @return Result of the DeleteRoutingControl operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DeleteRoutingControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteRoutingControl"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRoutingControlResponse deleteRoutingControl(DeleteRoutingControlRequest deleteRoutingControlRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a routing control.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoutingControlRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRoutingControlRequest#builder()}
     * </p>
     *
     * @param deleteRoutingControlRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRoutingControlRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRoutingControl operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DeleteRoutingControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteRoutingControl"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRoutingControlResponse deleteRoutingControl(
            Consumer<DeleteRoutingControlRequest.Builder> deleteRoutingControlRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        return deleteRoutingControl(DeleteRoutingControlRequest.builder().applyMutation(deleteRoutingControlRequest).build());
    }

    /**
     * <p>
     * Deletes a safety rule.
     * </p>
     * /&gt;
     *
     * @param deleteSafetyRuleRequest
     * @return Result of the DeleteSafetyRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DeleteSafetyRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteSafetyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSafetyRuleResponse deleteSafetyRule(DeleteSafetyRuleRequest deleteSafetyRuleRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a safety rule.
     * </p>
     * /&gt;<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSafetyRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSafetyRuleRequest#builder()}
     * </p>
     *
     * @param deleteSafetyRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSafetyRuleRequest.Builder} to create a request.
     * @return Result of the DeleteSafetyRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DeleteSafetyRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteSafetyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSafetyRuleResponse deleteSafetyRule(Consumer<DeleteSafetyRuleRequest.Builder> deleteSafetyRuleRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        return deleteSafetyRule(DeleteSafetyRuleRequest.builder().applyMutation(deleteSafetyRuleRequest).build());
    }

    /**
     * <p>
     * Display the details about a cluster. The response includes the cluster name, endpoints, status, and Amazon
     * Resource Name (ARN).
     * </p>
     *
     * @param describeClusterRequest
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Display the details about a cluster. The response includes the cluster name, endpoints, status, and Amazon
     * Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterRequest#builder()}
     * </p>
     *
     * @param describeClusterRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterRequest.Builder} to create a request.
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterResponse describeCluster(Consumer<DescribeClusterRequest.Builder> describeClusterRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        return describeCluster(DescribeClusterRequest.builder().applyMutation(describeClusterRequest).build());
    }

    /**
     * <p>
     * Displays details about a control panel.
     * </p>
     *
     * @param describeControlPanelRequest
     * @return Result of the DescribeControlPanel operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DescribeControlPanel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeControlPanel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeControlPanelResponse describeControlPanel(DescribeControlPanelRequest describeControlPanelRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays details about a control panel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeControlPanelRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeControlPanelRequest#builder()}
     * </p>
     *
     * @param describeControlPanelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeControlPanelRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeControlPanel operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DescribeControlPanel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeControlPanel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeControlPanelResponse describeControlPanel(
            Consumer<DescribeControlPanelRequest.Builder> describeControlPanelRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        return describeControlPanel(DescribeControlPanelRequest.builder().applyMutation(describeControlPanelRequest).build());
    }

    /**
     * <p>
     * Displays details about a routing control. A routing control has one of two states: ON and OFF. You can map the
     * routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
     * </p>
     * <p>
     * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53
     * Application Recovery Controller.
     * </p>
     *
     * @param describeRoutingControlRequest
     * @return Result of the DescribeRoutingControl operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DescribeRoutingControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeRoutingControl"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRoutingControlResponse describeRoutingControl(DescribeRoutingControlRequest describeRoutingControlRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays details about a routing control. A routing control has one of two states: ON and OFF. You can map the
     * routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
     * </p>
     * <p>
     * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53
     * Application Recovery Controller.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRoutingControlRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRoutingControlRequest#builder()}
     * </p>
     *
     * @param describeRoutingControlRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRoutingControlRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRoutingControl operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DescribeRoutingControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeRoutingControl"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRoutingControlResponse describeRoutingControl(
            Consumer<DescribeRoutingControlRequest.Builder> describeRoutingControlRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        return describeRoutingControl(DescribeRoutingControlRequest.builder().applyMutation(describeRoutingControlRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a safety rule.
     * </p>
     *
     * @param describeSafetyRuleRequest
     * @return Result of the DescribeSafetyRule operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DescribeSafetyRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeSafetyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSafetyRuleResponse describeSafetyRule(DescribeSafetyRuleRequest describeSafetyRuleRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a safety rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSafetyRuleRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSafetyRuleRequest#builder()}
     * </p>
     *
     * @param describeSafetyRuleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSafetyRuleRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSafetyRule operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.DescribeSafetyRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeSafetyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSafetyRuleResponse describeSafetyRule(Consumer<DescribeSafetyRuleRequest.Builder> describeSafetyRuleRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        return describeSafetyRule(DescribeSafetyRuleRequest.builder().applyMutation(describeSafetyRuleRequest).build());
    }

    /**
     * <p>
     * Returns an array of all Amazon Route 53 health checks associated with a specific routing control.
     * </p>
     *
     * @param listAssociatedRoute53HealthChecksRequest
     * @return Result of the ListAssociatedRoute53HealthChecks operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListAssociatedRoute53HealthChecks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListAssociatedRoute53HealthChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedRoute53HealthChecksResponse listAssociatedRoute53HealthChecks(
            ListAssociatedRoute53HealthChecksRequest listAssociatedRoute53HealthChecksRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of all Amazon Route 53 health checks associated with a specific routing control.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedRoute53HealthChecksRequest.Builder}
     * avoiding the need to create one manually via {@link ListAssociatedRoute53HealthChecksRequest#builder()}
     * </p>
     *
     * @param listAssociatedRoute53HealthChecksRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedRoute53HealthChecksRequest.Builder} to
     *        create a request.
     * @return Result of the ListAssociatedRoute53HealthChecks operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListAssociatedRoute53HealthChecks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListAssociatedRoute53HealthChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedRoute53HealthChecksResponse listAssociatedRoute53HealthChecks(
            Consumer<ListAssociatedRoute53HealthChecksRequest.Builder> listAssociatedRoute53HealthChecksRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        return listAssociatedRoute53HealthChecks(ListAssociatedRoute53HealthChecksRequest.builder()
                .applyMutation(listAssociatedRoute53HealthChecksRequest).build());
    }

    /**
     * <p>
     * Returns an array of all Amazon Route 53 health checks associated with a specific routing control.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedRoute53HealthChecks(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListAssociatedRoute53HealthChecksIterable responses = client.listAssociatedRoute53HealthChecksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListAssociatedRoute53HealthChecksIterable responses = client
     *             .listAssociatedRoute53HealthChecksPaginator(request);
     *     for (software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListAssociatedRoute53HealthChecksIterable responses = client.listAssociatedRoute53HealthChecksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedRoute53HealthChecks(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociatedRoute53HealthChecksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListAssociatedRoute53HealthChecks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListAssociatedRoute53HealthChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedRoute53HealthChecksIterable listAssociatedRoute53HealthChecksPaginator(
            ListAssociatedRoute53HealthChecksRequest listAssociatedRoute53HealthChecksRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of all Amazon Route 53 health checks associated with a specific routing control.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedRoute53HealthChecks(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListAssociatedRoute53HealthChecksIterable responses = client.listAssociatedRoute53HealthChecksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListAssociatedRoute53HealthChecksIterable responses = client
     *             .listAssociatedRoute53HealthChecksPaginator(request);
     *     for (software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListAssociatedRoute53HealthChecksIterable responses = client.listAssociatedRoute53HealthChecksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedRoute53HealthChecks(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedRoute53HealthChecksRequest.Builder}
     * avoiding the need to create one manually via {@link ListAssociatedRoute53HealthChecksRequest#builder()}
     * </p>
     *
     * @param listAssociatedRoute53HealthChecksRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedRoute53HealthChecksRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListAssociatedRoute53HealthChecks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListAssociatedRoute53HealthChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedRoute53HealthChecksIterable listAssociatedRoute53HealthChecksPaginator(
            Consumer<ListAssociatedRoute53HealthChecksRequest.Builder> listAssociatedRoute53HealthChecksRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        return listAssociatedRoute53HealthChecksPaginator(ListAssociatedRoute53HealthChecksRequest.builder()
                .applyMutation(listAssociatedRoute53HealthChecksRequest).build());
    }

    /**
     * <p>
     * Returns an array of all the clusters in an account.
     * </p>
     *
     * @param listClustersRequest
     * @return Result of the ListClusters operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of all the clusters in an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on {@link ListClustersRequest.Builder} to create a request.
     * @return Result of the ListClusters operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Returns an array of all the clusters in an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClusters(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListClustersIterable responses = client
     *             .listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(ListClustersRequest listClustersRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of all the clusters in an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClusters(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListClustersIterable responses = client
     *             .listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on {@link ListClustersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Returns an array of control panels in an account or in a cluster.
     * </p>
     *
     * @param listControlPanelsRequest
     * @return Result of the ListControlPanels operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListControlPanels
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListControlPanels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlPanelsResponse listControlPanels(ListControlPanelsRequest listControlPanelsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of control panels in an account or in a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlPanelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListControlPanelsRequest#builder()}
     * </p>
     *
     * @param listControlPanelsRequest
     *        A {@link Consumer} that will call methods on {@link ListControlPanelsRequest.Builder} to create a request.
     * @return Result of the ListControlPanels operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListControlPanels
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListControlPanels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlPanelsResponse listControlPanels(Consumer<ListControlPanelsRequest.Builder> listControlPanelsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        return listControlPanels(ListControlPanelsRequest.builder().applyMutation(listControlPanelsRequest).build());
    }

    /**
     * <p>
     * Returns an array of control panels in an account or in a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listControlPanels(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListControlPanelsIterable responses = client.listControlPanelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListControlPanelsIterable responses = client
     *             .listControlPanelsPaginator(request);
     *     for (software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListControlPanelsIterable responses = client.listControlPanelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlPanels(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listControlPanelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListControlPanels
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListControlPanels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlPanelsIterable listControlPanelsPaginator(ListControlPanelsRequest listControlPanelsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of control panels in an account or in a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listControlPanels(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListControlPanelsIterable responses = client.listControlPanelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListControlPanelsIterable responses = client
     *             .listControlPanelsPaginator(request);
     *     for (software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListControlPanelsIterable responses = client.listControlPanelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlPanels(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlPanelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListControlPanelsRequest#builder()}
     * </p>
     *
     * @param listControlPanelsRequest
     *        A {@link Consumer} that will call methods on {@link ListControlPanelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListControlPanels
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListControlPanels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlPanelsIterable listControlPanelsPaginator(
            Consumer<ListControlPanelsRequest.Builder> listControlPanelsRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        return listControlPanelsPaginator(ListControlPanelsRequest.builder().applyMutation(listControlPanelsRequest).build());
    }

    /**
     * <p>
     * Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application
     * Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to
     * the state of an Amazon Route 53 health check, which can be used to control routing.
     * </p>
     *
     * @param listRoutingControlsRequest
     * @return Result of the ListRoutingControls operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListRoutingControls
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListRoutingControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRoutingControlsResponse listRoutingControls(ListRoutingControlsRequest listRoutingControlsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application
     * Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to
     * the state of an Amazon Route 53 health check, which can be used to control routing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoutingControlsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRoutingControlsRequest#builder()}
     * </p>
     *
     * @param listRoutingControlsRequest
     *        A {@link Consumer} that will call methods on {@link ListRoutingControlsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRoutingControls operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListRoutingControls
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListRoutingControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRoutingControlsResponse listRoutingControls(
            Consumer<ListRoutingControlsRequest.Builder> listRoutingControlsRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        return listRoutingControls(ListRoutingControlsRequest.builder().applyMutation(listRoutingControlsRequest).build());
    }

    /**
     * <p>
     * Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application
     * Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to
     * the state of an Amazon Route 53 health check, which can be used to control routing.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRoutingControls(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListRoutingControlsIterable responses = client.listRoutingControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListRoutingControlsIterable responses = client
     *             .listRoutingControlsPaginator(request);
     *     for (software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListRoutingControlsIterable responses = client.listRoutingControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoutingControls(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRoutingControlsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListRoutingControls
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListRoutingControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRoutingControlsIterable listRoutingControlsPaginator(ListRoutingControlsRequest listRoutingControlsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application
     * Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to
     * the state of an Amazon Route 53 health check, which can be used to control routing.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRoutingControls(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListRoutingControlsIterable responses = client.listRoutingControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListRoutingControlsIterable responses = client
     *             .listRoutingControlsPaginator(request);
     *     for (software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListRoutingControlsIterable responses = client.listRoutingControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoutingControls(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoutingControlsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRoutingControlsRequest#builder()}
     * </p>
     *
     * @param listRoutingControlsRequest
     *        A {@link Consumer} that will call methods on {@link ListRoutingControlsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListRoutingControls
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListRoutingControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRoutingControlsIterable listRoutingControlsPaginator(
            Consumer<ListRoutingControlsRequest.Builder> listRoutingControlsRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        return listRoutingControlsPaginator(ListRoutingControlsRequest.builder().applyMutation(listRoutingControlsRequest)
                .build());
    }

    /**
     * <p>
     * List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a
     * control panel.
     * </p>
     *
     * @param listSafetyRulesRequest
     * @return Result of the ListSafetyRules operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListSafetyRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListSafetyRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSafetyRulesResponse listSafetyRules(ListSafetyRulesRequest listSafetyRulesRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a
     * control panel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSafetyRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListSafetyRulesRequest#builder()}
     * </p>
     *
     * @param listSafetyRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListSafetyRulesRequest.Builder} to create a request.
     * @return Result of the ListSafetyRules operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListSafetyRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListSafetyRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSafetyRulesResponse listSafetyRules(Consumer<ListSafetyRulesRequest.Builder> listSafetyRulesRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        return listSafetyRules(ListSafetyRulesRequest.builder().applyMutation(listSafetyRulesRequest).build());
    }

    /**
     * <p>
     * List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a
     * control panel.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSafetyRules(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListSafetyRulesIterable responses = client.listSafetyRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListSafetyRulesIterable responses = client
     *             .listSafetyRulesPaginator(request);
     *     for (software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListSafetyRulesIterable responses = client.listSafetyRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSafetyRules(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSafetyRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListSafetyRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListSafetyRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSafetyRulesIterable listSafetyRulesPaginator(ListSafetyRulesRequest listSafetyRulesRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a
     * control panel.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSafetyRules(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListSafetyRulesIterable responses = client.listSafetyRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListSafetyRulesIterable responses = client
     *             .listSafetyRulesPaginator(request);
     *     for (software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoverycontrolconfig.paginators.ListSafetyRulesIterable responses = client.listSafetyRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSafetyRules(software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSafetyRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListSafetyRulesRequest#builder()}
     * </p>
     *
     * @param listSafetyRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListSafetyRulesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListSafetyRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListSafetyRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSafetyRulesIterable listSafetyRulesPaginator(Consumer<ListSafetyRulesRequest.Builder> listSafetyRulesRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        return listSafetyRulesPaginator(ListSafetyRulesRequest.builder().applyMutation(listSafetyRulesRequest).build());
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListTagsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.ListTagsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     *        Request of adding tag to the resource
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     *        Request of adding tag to the resource
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a control panel. The only update you can make to a control panel is to change the name of the control
     * panel.
     * </p>
     *
     * @param updateControlPanelRequest
     *        The details of the control panel that you're updating.
     * @return Result of the UpdateControlPanel operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.UpdateControlPanel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateControlPanel"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateControlPanelResponse updateControlPanel(UpdateControlPanelRequest updateControlPanelRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a control panel. The only update you can make to a control panel is to change the name of the control
     * panel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateControlPanelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateControlPanelRequest#builder()}
     * </p>
     *
     * @param updateControlPanelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateControlPanelRequest.Builder} to create a
     *        request. The details of the control panel that you're updating.
     * @return Result of the UpdateControlPanel operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.UpdateControlPanel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateControlPanel"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateControlPanelResponse updateControlPanel(Consumer<UpdateControlPanelRequest.Builder> updateControlPanelRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        return updateControlPanel(UpdateControlPanelRequest.builder().applyMutation(updateControlPanelRequest).build());
    }

    /**
     * <p>
     * Updates a routing control. You can only update the name of the routing control. To get or update the routing
     * control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery
     * Controller.
     * </p>
     *
     * @param updateRoutingControlRequest
     *        The details of the routing control that you're updating.
     * @return Result of the UpdateRoutingControl operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.UpdateRoutingControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateRoutingControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRoutingControlResponse updateRoutingControl(UpdateRoutingControlRequest updateRoutingControlRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException,
            Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a routing control. You can only update the name of the routing control. To get or update the routing
     * control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery
     * Controller.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRoutingControlRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRoutingControlRequest#builder()}
     * </p>
     *
     * @param updateRoutingControlRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRoutingControlRequest.Builder} to create a
     *        request. The details of the routing control that you're updating.
     * @return Result of the UpdateRoutingControl operation returned by the service.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws AccessDeniedException
     *         403 response - AccessDeniedException. You do not hace sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ThrottlingException
     *         429 response - LimitExceededException or TooManyRequestsException.
     * @throws ConflictException
     *         409 response - ConflictException. You might be using a predefined variable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.UpdateRoutingControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateRoutingControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRoutingControlResponse updateRoutingControl(
            Consumer<UpdateRoutingControlRequest.Builder> updateRoutingControlRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        return updateRoutingControl(UpdateRoutingControlRequest.builder().applyMutation(updateRoutingControlRequest).build());
    }

    /**
     * <p>
     * Update a safety rule (an assertion rule or gating rule). You can only update the name and the waiting period for
     * a safety rule. To make other updates, delete the safety rule and create a new one.
     * </p>
     *
     * @param updateSafetyRuleRequest
     *        A rule that you add to Application Recovery Controller to ensure that recovery actions don't accidentally
     *        impair your application's availability.
     * @return Result of the UpdateSafetyRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.UpdateSafetyRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateSafetyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSafetyRuleResponse updateSafetyRule(UpdateSafetyRuleRequest updateSafetyRuleRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a safety rule (an assertion rule or gating rule). You can only update the name and the waiting period for
     * a safety rule. To make other updates, delete the safety rule and create a new one.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSafetyRuleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSafetyRuleRequest#builder()}
     * </p>
     *
     * @param updateSafetyRuleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSafetyRuleRequest.Builder} to create a request.
     *        A rule that you add to Application Recovery Controller to ensure that recovery actions don't accidentally
     *        impair your application's availability.
     * @return Result of the UpdateSafetyRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response - MalformedQueryString. The query string contains a syntax error or resource not found.
     * @throws ValidationException
     *         400 response - Multiple causes. For example, you might have a malformed query string and input parameter
     *         might be out of range, or you used parameters together incorrectly.
     * @throws InternalServerException
     *         500 response - InternalServiceError. Temporary service error. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53RecoveryControlConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53RecoveryControlConfigClient.UpdateSafetyRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateSafetyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSafetyRuleResponse updateSafetyRule(Consumer<UpdateSafetyRuleRequest.Builder> updateSafetyRuleRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, Route53RecoveryControlConfigException {
        return updateSafetyRule(UpdateSafetyRuleRequest.builder().applyMutation(updateSafetyRuleRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    /**
     * Create an instance of {@link Route53RecoveryControlConfigWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link Route53RecoveryControlConfigWaiter}
     */
    default Route53RecoveryControlConfigWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
