/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule that you add to Application Recovery Controller to ensure that recovery actions don't accidentally impair your
 * application's availability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSafetyRuleRequest extends Route53RecoveryControlConfigRequest implements
        ToCopyableBuilder<UpdateSafetyRuleRequest.Builder, UpdateSafetyRuleRequest> {
    private static final SdkField<AssertionRuleUpdate> ASSERTION_RULE_UPDATE_FIELD = SdkField
            .<AssertionRuleUpdate> builder(MarshallingType.SDK_POJO).memberName("AssertionRuleUpdate")
            .getter(getter(UpdateSafetyRuleRequest::assertionRuleUpdate)).setter(setter(Builder::assertionRuleUpdate))
            .constructor(AssertionRuleUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssertionRuleUpdate").build())
            .build();

    private static final SdkField<GatingRuleUpdate> GATING_RULE_UPDATE_FIELD = SdkField
            .<GatingRuleUpdate> builder(MarshallingType.SDK_POJO).memberName("GatingRuleUpdate")
            .getter(getter(UpdateSafetyRuleRequest::gatingRuleUpdate)).setter(setter(Builder::gatingRuleUpdate))
            .constructor(GatingRuleUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatingRuleUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSERTION_RULE_UPDATE_FIELD,
            GATING_RULE_UPDATE_FIELD));

    private final AssertionRuleUpdate assertionRuleUpdate;

    private final GatingRuleUpdate gatingRuleUpdate;

    private UpdateSafetyRuleRequest(BuilderImpl builder) {
        super(builder);
        this.assertionRuleUpdate = builder.assertionRuleUpdate;
        this.gatingRuleUpdate = builder.gatingRuleUpdate;
    }

    /**
     * <p>
     * The assertion rule to update.
     * </p>
     * 
     * @return The assertion rule to update.
     */
    public final AssertionRuleUpdate assertionRuleUpdate() {
        return assertionRuleUpdate;
    }

    /**
     * <p>
     * The gating rule to update.
     * </p>
     * 
     * @return The gating rule to update.
     */
    public final GatingRuleUpdate gatingRuleUpdate() {
        return gatingRuleUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assertionRuleUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(gatingRuleUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSafetyRuleRequest)) {
            return false;
        }
        UpdateSafetyRuleRequest other = (UpdateSafetyRuleRequest) obj;
        return Objects.equals(assertionRuleUpdate(), other.assertionRuleUpdate())
                && Objects.equals(gatingRuleUpdate(), other.gatingRuleUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSafetyRuleRequest").add("AssertionRuleUpdate", assertionRuleUpdate())
                .add("GatingRuleUpdate", gatingRuleUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssertionRuleUpdate":
            return Optional.ofNullable(clazz.cast(assertionRuleUpdate()));
        case "GatingRuleUpdate":
            return Optional.ofNullable(clazz.cast(gatingRuleUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSafetyRuleRequest, T> g) {
        return obj -> g.apply((UpdateSafetyRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryControlConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSafetyRuleRequest> {
        /**
         * <p>
         * The assertion rule to update.
         * </p>
         * 
         * @param assertionRuleUpdate
         *        The assertion rule to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assertionRuleUpdate(AssertionRuleUpdate assertionRuleUpdate);

        /**
         * <p>
         * The assertion rule to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssertionRuleUpdate.Builder} avoiding the
         * need to create one manually via {@link AssertionRuleUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssertionRuleUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #assertionRuleUpdate(AssertionRuleUpdate)}.
         * 
         * @param assertionRuleUpdate
         *        a consumer that will call methods on {@link AssertionRuleUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assertionRuleUpdate(AssertionRuleUpdate)
         */
        default Builder assertionRuleUpdate(Consumer<AssertionRuleUpdate.Builder> assertionRuleUpdate) {
            return assertionRuleUpdate(AssertionRuleUpdate.builder().applyMutation(assertionRuleUpdate).build());
        }

        /**
         * <p>
         * The gating rule to update.
         * </p>
         * 
         * @param gatingRuleUpdate
         *        The gating rule to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatingRuleUpdate(GatingRuleUpdate gatingRuleUpdate);

        /**
         * <p>
         * The gating rule to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link GatingRuleUpdate.Builder} avoiding the
         * need to create one manually via {@link GatingRuleUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link GatingRuleUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #gatingRuleUpdate(GatingRuleUpdate)}.
         * 
         * @param gatingRuleUpdate
         *        a consumer that will call methods on {@link GatingRuleUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatingRuleUpdate(GatingRuleUpdate)
         */
        default Builder gatingRuleUpdate(Consumer<GatingRuleUpdate.Builder> gatingRuleUpdate) {
            return gatingRuleUpdate(GatingRuleUpdate.builder().applyMutation(gatingRuleUpdate).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryControlConfigRequest.BuilderImpl implements Builder {
        private AssertionRuleUpdate assertionRuleUpdate;

        private GatingRuleUpdate gatingRuleUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSafetyRuleRequest model) {
            super(model);
            assertionRuleUpdate(model.assertionRuleUpdate);
            gatingRuleUpdate(model.gatingRuleUpdate);
        }

        public final AssertionRuleUpdate.Builder getAssertionRuleUpdate() {
            return assertionRuleUpdate != null ? assertionRuleUpdate.toBuilder() : null;
        }

        public final void setAssertionRuleUpdate(AssertionRuleUpdate.BuilderImpl assertionRuleUpdate) {
            this.assertionRuleUpdate = assertionRuleUpdate != null ? assertionRuleUpdate.build() : null;
        }

        @Override
        public final Builder assertionRuleUpdate(AssertionRuleUpdate assertionRuleUpdate) {
            this.assertionRuleUpdate = assertionRuleUpdate;
            return this;
        }

        public final GatingRuleUpdate.Builder getGatingRuleUpdate() {
            return gatingRuleUpdate != null ? gatingRuleUpdate.toBuilder() : null;
        }

        public final void setGatingRuleUpdate(GatingRuleUpdate.BuilderImpl gatingRuleUpdate) {
            this.gatingRuleUpdate = gatingRuleUpdate != null ? gatingRuleUpdate.build() : null;
        }

        @Override
        public final Builder gatingRuleUpdate(GatingRuleUpdate gatingRuleUpdate) {
            this.gatingRuleUpdate = gatingRuleUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSafetyRuleRequest build() {
            return new UpdateSafetyRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
