/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the control panel that you're creating.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateControlPanelRequest extends Route53RecoveryControlConfigRequest implements
        ToCopyableBuilder<CreateControlPanelRequest.Builder, CreateControlPanelRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateControlPanelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(CreateControlPanelRequest::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> CONTROL_PANEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlPanelName").getter(getter(CreateControlPanelRequest::controlPanelName))
            .setter(setter(Builder::controlPanelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CLUSTER_ARN_FIELD, CONTROL_PANEL_NAME_FIELD));

    private final String clientToken;

    private final String clusterArn;

    private final String controlPanelName;

    private CreateControlPanelRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.clusterArn = builder.clusterArn;
        this.controlPanelName = builder.controlPanelName;
    }

    /**
     * <p>
     * Unique client idempotency token.
     * </p>
     * 
     * @return Unique client idempotency token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cluster for the control panel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cluster for the control panel.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The name of the control panel.
     * </p>
     * 
     * @return The name of the control panel.
     */
    public final String controlPanelName() {
        return controlPanelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(controlPanelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateControlPanelRequest)) {
            return false;
        }
        CreateControlPanelRequest other = (CreateControlPanelRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(controlPanelName(), other.controlPanelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateControlPanelRequest").add("ClientToken", clientToken()).add("ClusterArn", clusterArn())
                .add("ControlPanelName", controlPanelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ControlPanelName":
            return Optional.ofNullable(clazz.cast(controlPanelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateControlPanelRequest, T> g) {
        return obj -> g.apply((CreateControlPanelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryControlConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateControlPanelRequest> {
        /**
         * <p>
         * Unique client idempotency token.
         * </p>
         * 
         * @param clientToken
         *        Unique client idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cluster for the control panel.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the cluster for the control panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The name of the control panel.
         * </p>
         * 
         * @param controlPanelName
         *        The name of the control panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPanelName(String controlPanelName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryControlConfigRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String clusterArn;

        private String controlPanelName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateControlPanelRequest model) {
            super(model);
            clientToken(model.clientToken);
            clusterArn(model.clusterArn);
            controlPanelName(model.controlPanelName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        @Transient
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getControlPanelName() {
            return controlPanelName;
        }

        public final void setControlPanelName(String controlPanelName) {
            this.controlPanelName = controlPanelName;
        }

        @Override
        @Transient
        public final Builder controlPanelName(String controlPanelName) {
            this.controlPanelName = controlPanelName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateControlPanelRequest build() {
            return new CreateControlPanelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
