/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSafetyRuleResponse extends Route53RecoveryControlConfigResponse implements
        ToCopyableBuilder<DescribeSafetyRuleResponse.Builder, DescribeSafetyRuleResponse> {
    private static final SdkField<AssertionRule> ASSERTION_RULE_FIELD = SdkField
            .<AssertionRule> builder(MarshallingType.SDK_POJO).memberName("AssertionRule")
            .getter(getter(DescribeSafetyRuleResponse::assertionRule)).setter(setter(Builder::assertionRule))
            .constructor(AssertionRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssertionRule").build()).build();

    private static final SdkField<GatingRule> GATING_RULE_FIELD = SdkField.<GatingRule> builder(MarshallingType.SDK_POJO)
            .memberName("GatingRule").getter(getter(DescribeSafetyRuleResponse::gatingRule)).setter(setter(Builder::gatingRule))
            .constructor(GatingRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatingRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSERTION_RULE_FIELD,
            GATING_RULE_FIELD));

    private final AssertionRule assertionRule;

    private final GatingRule gatingRule;

    private DescribeSafetyRuleResponse(BuilderImpl builder) {
        super(builder);
        this.assertionRule = builder.assertionRule;
        this.gatingRule = builder.gatingRule;
    }

    /**
     * Returns the value of the AssertionRule property for this object.
     * 
     * @return The value of the AssertionRule property for this object.
     */
    public final AssertionRule assertionRule() {
        return assertionRule;
    }

    /**
     * Returns the value of the GatingRule property for this object.
     * 
     * @return The value of the GatingRule property for this object.
     */
    public final GatingRule gatingRule() {
        return gatingRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assertionRule());
        hashCode = 31 * hashCode + Objects.hashCode(gatingRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSafetyRuleResponse)) {
            return false;
        }
        DescribeSafetyRuleResponse other = (DescribeSafetyRuleResponse) obj;
        return Objects.equals(assertionRule(), other.assertionRule()) && Objects.equals(gatingRule(), other.gatingRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSafetyRuleResponse").add("AssertionRule", assertionRule())
                .add("GatingRule", gatingRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssertionRule":
            return Optional.ofNullable(clazz.cast(assertionRule()));
        case "GatingRule":
            return Optional.ofNullable(clazz.cast(gatingRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSafetyRuleResponse, T> g) {
        return obj -> g.apply((DescribeSafetyRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryControlConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSafetyRuleResponse> {
        /**
         * Sets the value of the AssertionRule property for this object.
         *
         * @param assertionRule
         *        The new value for the AssertionRule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assertionRule(AssertionRule assertionRule);

        /**
         * Sets the value of the AssertionRule property for this object.
         *
         * This is a convenience that creates an instance of the {@link AssertionRule.Builder} avoiding the need to
         * create one manually via {@link AssertionRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssertionRule.Builder#build()} is called immediately and its
         * result is passed to {@link #assertionRule(AssertionRule)}.
         * 
         * @param assertionRule
         *        a consumer that will call methods on {@link AssertionRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assertionRule(AssertionRule)
         */
        default Builder assertionRule(Consumer<AssertionRule.Builder> assertionRule) {
            return assertionRule(AssertionRule.builder().applyMutation(assertionRule).build());
        }

        /**
         * Sets the value of the GatingRule property for this object.
         *
         * @param gatingRule
         *        The new value for the GatingRule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatingRule(GatingRule gatingRule);

        /**
         * Sets the value of the GatingRule property for this object.
         *
         * This is a convenience that creates an instance of the {@link GatingRule.Builder} avoiding the need to create
         * one manually via {@link GatingRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link GatingRule.Builder#build()} is called immediately and its result
         * is passed to {@link #gatingRule(GatingRule)}.
         * 
         * @param gatingRule
         *        a consumer that will call methods on {@link GatingRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatingRule(GatingRule)
         */
        default Builder gatingRule(Consumer<GatingRule.Builder> gatingRule) {
            return gatingRule(GatingRule.builder().applyMutation(gatingRule).build());
        }
    }

    static final class BuilderImpl extends Route53RecoveryControlConfigResponse.BuilderImpl implements Builder {
        private AssertionRule assertionRule;

        private GatingRule gatingRule;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSafetyRuleResponse model) {
            super(model);
            assertionRule(model.assertionRule);
            gatingRule(model.gatingRule);
        }

        public final AssertionRule.Builder getAssertionRule() {
            return assertionRule != null ? assertionRule.toBuilder() : null;
        }

        public final void setAssertionRule(AssertionRule.BuilderImpl assertionRule) {
            this.assertionRule = assertionRule != null ? assertionRule.build() : null;
        }

        @Override
        @Transient
        public final Builder assertionRule(AssertionRule assertionRule) {
            this.assertionRule = assertionRule;
            return this;
        }

        public final GatingRule.Builder getGatingRule() {
            return gatingRule != null ? gatingRule.toBuilder() : null;
        }

        public final void setGatingRule(GatingRule.BuilderImpl gatingRule) {
            this.gatingRule = gatingRule != null ? gatingRule.build() : null;
        }

        @Override
        @Transient
        public final Builder gatingRule(GatingRule gatingRule) {
            this.gatingRule = gatingRule;
            return this;
        }

        @Override
        public DescribeSafetyRuleResponse build() {
            return new DescribeSafetyRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
