/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSafetyRuleRequest extends Route53RecoveryControlConfigRequest implements
        ToCopyableBuilder<DeleteSafetyRuleRequest.Builder, DeleteSafetyRuleRequest> {
    private static final SdkField<String> SAFETY_RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SafetyRuleArn").getter(getter(DeleteSafetyRuleRequest::safetyRuleArn))
            .setter(setter(Builder::safetyRuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SafetyRuleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAFETY_RULE_ARN_FIELD));

    private final String safetyRuleArn;

    private DeleteSafetyRuleRequest(BuilderImpl builder) {
        super(builder);
        this.safetyRuleArn = builder.safetyRuleArn;
    }

    /**
     * <p>
     * The request body that you include when you update a safety rule.
     * </p>
     * 
     * @return The request body that you include when you update a safety rule.
     */
    public final String safetyRuleArn() {
        return safetyRuleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(safetyRuleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSafetyRuleRequest)) {
            return false;
        }
        DeleteSafetyRuleRequest other = (DeleteSafetyRuleRequest) obj;
        return Objects.equals(safetyRuleArn(), other.safetyRuleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSafetyRuleRequest").add("SafetyRuleArn", safetyRuleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SafetyRuleArn":
            return Optional.ofNullable(clazz.cast(safetyRuleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSafetyRuleRequest, T> g) {
        return obj -> g.apply((DeleteSafetyRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryControlConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteSafetyRuleRequest> {
        /**
         * <p>
         * The request body that you include when you update a safety rule.
         * </p>
         * 
         * @param safetyRuleArn
         *        The request body that you include when you update a safety rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder safetyRuleArn(String safetyRuleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryControlConfigRequest.BuilderImpl implements Builder {
        private String safetyRuleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSafetyRuleRequest model) {
            super(model);
            safetyRuleArn(model.safetyRuleArn);
        }

        public final String getSafetyRuleArn() {
            return safetyRuleArn;
        }

        public final void setSafetyRuleArn(String safetyRuleArn) {
            this.safetyRuleArn = safetyRuleArn;
        }

        @Override
        @Transient
        public final Builder safetyRuleArn(String safetyRuleArn) {
            this.safetyRuleArn = safetyRuleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSafetyRuleRequest build() {
            return new DeleteSafetyRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
