/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request body that you include when you create a safety rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSafetyRuleRequest extends Route53RecoveryControlConfigRequest implements
        ToCopyableBuilder<CreateSafetyRuleRequest.Builder, CreateSafetyRuleRequest> {
    private static final SdkField<NewAssertionRule> ASSERTION_RULE_FIELD = SdkField
            .<NewAssertionRule> builder(MarshallingType.SDK_POJO).memberName("AssertionRule")
            .getter(getter(CreateSafetyRuleRequest::assertionRule)).setter(setter(Builder::assertionRule))
            .constructor(NewAssertionRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssertionRule").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateSafetyRuleRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<NewGatingRule> GATING_RULE_FIELD = SdkField.<NewGatingRule> builder(MarshallingType.SDK_POJO)
            .memberName("GatingRule").getter(getter(CreateSafetyRuleRequest::gatingRule)).setter(setter(Builder::gatingRule))
            .constructor(NewGatingRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatingRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSERTION_RULE_FIELD,
            CLIENT_TOKEN_FIELD, GATING_RULE_FIELD));

    private final NewAssertionRule assertionRule;

    private final String clientToken;

    private final NewGatingRule gatingRule;

    private CreateSafetyRuleRequest(BuilderImpl builder) {
        super(builder);
        this.assertionRule = builder.assertionRule;
        this.clientToken = builder.clientToken;
        this.gatingRule = builder.gatingRule;
    }

    /**
     * Returns the value of the AssertionRule property for this object.
     * 
     * @return The value of the AssertionRule property for this object.
     */
    public final NewAssertionRule assertionRule() {
        return assertionRule;
    }

    /**
     * <p>
     * Unique client idempotency token.
     * </p>
     * 
     * @return Unique client idempotency token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the GatingRule property for this object.
     * 
     * @return The value of the GatingRule property for this object.
     */
    public final NewGatingRule gatingRule() {
        return gatingRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assertionRule());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(gatingRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSafetyRuleRequest)) {
            return false;
        }
        CreateSafetyRuleRequest other = (CreateSafetyRuleRequest) obj;
        return Objects.equals(assertionRule(), other.assertionRule()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(gatingRule(), other.gatingRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSafetyRuleRequest").add("AssertionRule", assertionRule())
                .add("ClientToken", clientToken()).add("GatingRule", gatingRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssertionRule":
            return Optional.ofNullable(clazz.cast(assertionRule()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "GatingRule":
            return Optional.ofNullable(clazz.cast(gatingRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSafetyRuleRequest, T> g) {
        return obj -> g.apply((CreateSafetyRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryControlConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSafetyRuleRequest> {
        /**
         * Sets the value of the AssertionRule property for this object.
         *
         * @param assertionRule
         *        The new value for the AssertionRule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assertionRule(NewAssertionRule assertionRule);

        /**
         * Sets the value of the AssertionRule property for this object.
         *
         * This is a convenience that creates an instance of the {@link NewAssertionRule.Builder} avoiding the need to
         * create one manually via {@link NewAssertionRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link NewAssertionRule.Builder#build()} is called immediately and its
         * result is passed to {@link #assertionRule(NewAssertionRule)}.
         * 
         * @param assertionRule
         *        a consumer that will call methods on {@link NewAssertionRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assertionRule(NewAssertionRule)
         */
        default Builder assertionRule(Consumer<NewAssertionRule.Builder> assertionRule) {
            return assertionRule(NewAssertionRule.builder().applyMutation(assertionRule).build());
        }

        /**
         * <p>
         * Unique client idempotency token.
         * </p>
         * 
         * @param clientToken
         *        Unique client idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the GatingRule property for this object.
         *
         * @param gatingRule
         *        The new value for the GatingRule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatingRule(NewGatingRule gatingRule);

        /**
         * Sets the value of the GatingRule property for this object.
         *
         * This is a convenience that creates an instance of the {@link NewGatingRule.Builder} avoiding the need to
         * create one manually via {@link NewGatingRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link NewGatingRule.Builder#build()} is called immediately and its
         * result is passed to {@link #gatingRule(NewGatingRule)}.
         * 
         * @param gatingRule
         *        a consumer that will call methods on {@link NewGatingRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatingRule(NewGatingRule)
         */
        default Builder gatingRule(Consumer<NewGatingRule.Builder> gatingRule) {
            return gatingRule(NewGatingRule.builder().applyMutation(gatingRule).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryControlConfigRequest.BuilderImpl implements Builder {
        private NewAssertionRule assertionRule;

        private String clientToken;

        private NewGatingRule gatingRule;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSafetyRuleRequest model) {
            super(model);
            assertionRule(model.assertionRule);
            clientToken(model.clientToken);
            gatingRule(model.gatingRule);
        }

        public final NewAssertionRule.Builder getAssertionRule() {
            return assertionRule != null ? assertionRule.toBuilder() : null;
        }

        public final void setAssertionRule(NewAssertionRule.BuilderImpl assertionRule) {
            this.assertionRule = assertionRule != null ? assertionRule.build() : null;
        }

        @Override
        @Transient
        public final Builder assertionRule(NewAssertionRule assertionRule) {
            this.assertionRule = assertionRule;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final NewGatingRule.Builder getGatingRule() {
            return gatingRule != null ? gatingRule.toBuilder() : null;
        }

        public final void setGatingRule(NewGatingRule.BuilderImpl gatingRule) {
            this.gatingRule = gatingRule != null ? gatingRule.build() : null;
        }

        @Override
        @Transient
        public final Builder gatingRule(NewGatingRule gatingRule) {
            this.gatingRule = gatingRule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSafetyRuleRequest build() {
            return new CreateSafetyRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
