/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleConfig;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Status;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.___listOf__stringMin1Max256PatternAZaZ09Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatingRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatingRule> {
    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlPanelArn").getter(GatingRule.getter(GatingRule::controlPanelArn)).setter(GatingRule.setter(Builder::controlPanelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()}).build();
    private static final SdkField<List<String>> GATING_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GatingControls").getter(GatingRule.getter(GatingRule::gatingControls)).setter(GatingRule.setter(Builder::gatingControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatingControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GatingRule.getter(GatingRule::name)).setter(GatingRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<RuleConfig> RULE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuleConfig").getter(GatingRule.getter(GatingRule::ruleConfig)).setter(GatingRule.setter(Builder::ruleConfig)).constructor(RuleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleConfig").build()}).build();
    private static final SdkField<String> SAFETY_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SafetyRuleArn").getter(GatingRule.getter(GatingRule::safetyRuleArn)).setter(GatingRule.setter(Builder::safetyRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafetyRuleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GatingRule.getter(GatingRule::statusAsString)).setter(GatingRule.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> TARGET_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetControls").getter(GatingRule.getter(GatingRule::targetControls)).setter(GatingRule.setter(Builder::targetControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> WAIT_PERIOD_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WaitPeriodMs").getter(GatingRule.getter(GatingRule::waitPeriodMs)).setter(GatingRule.setter(Builder::waitPeriodMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitPeriodMs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_PANEL_ARN_FIELD, GATING_CONTROLS_FIELD, NAME_FIELD, RULE_CONFIG_FIELD, SAFETY_RULE_ARN_FIELD, STATUS_FIELD, TARGET_CONTROLS_FIELD, WAIT_PERIOD_MS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String controlPanelArn;
    private final List<String> gatingControls;
    private final String name;
    private final RuleConfig ruleConfig;
    private final String safetyRuleArn;
    private final String status;
    private final List<String> targetControls;
    private final Integer waitPeriodMs;

    private GatingRule(BuilderImpl builder) {
        this.controlPanelArn = builder.controlPanelArn;
        this.gatingControls = builder.gatingControls;
        this.name = builder.name;
        this.ruleConfig = builder.ruleConfig;
        this.safetyRuleArn = builder.safetyRuleArn;
        this.status = builder.status;
        this.targetControls = builder.targetControls;
        this.waitPeriodMs = builder.waitPeriodMs;
    }

    public final String controlPanelArn() {
        return this.controlPanelArn;
    }

    public final boolean hasGatingControls() {
        return this.gatingControls != null && !(this.gatingControls instanceof SdkAutoConstructList);
    }

    public final List<String> gatingControls() {
        return this.gatingControls;
    }

    public final String name() {
        return this.name;
    }

    public final RuleConfig ruleConfig() {
        return this.ruleConfig;
    }

    public final String safetyRuleArn() {
        return this.safetyRuleArn;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTargetControls() {
        return this.targetControls != null && !(this.targetControls instanceof SdkAutoConstructList);
    }

    public final List<String> targetControls() {
        return this.targetControls;
    }

    public final Integer waitPeriodMs() {
        return this.waitPeriodMs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatingControls() ? this.gatingControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.safetyRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetControls() ? this.targetControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.waitPeriodMs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatingRule)) {
            return false;
        }
        GatingRule other = (GatingRule)obj;
        return Objects.equals(this.controlPanelArn(), other.controlPanelArn()) && this.hasGatingControls() == other.hasGatingControls() && Objects.equals(this.gatingControls(), other.gatingControls()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ruleConfig(), other.ruleConfig()) && Objects.equals(this.safetyRuleArn(), other.safetyRuleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTargetControls() == other.hasTargetControls() && Objects.equals(this.targetControls(), other.targetControls()) && Objects.equals(this.waitPeriodMs(), other.waitPeriodMs());
    }

    public final String toString() {
        return ToString.builder((String)"GatingRule").add("ControlPanelArn", (Object)this.controlPanelArn()).add("GatingControls", this.hasGatingControls() ? this.gatingControls() : null).add("Name", (Object)this.name()).add("RuleConfig", (Object)this.ruleConfig()).add("SafetyRuleArn", (Object)this.safetyRuleArn()).add("Status", (Object)this.statusAsString()).add("TargetControls", this.hasTargetControls() ? this.targetControls() : null).add("WaitPeriodMs", (Object)this.waitPeriodMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ControlPanelArn": {
                return Optional.ofNullable(clazz.cast(this.controlPanelArn()));
            }
            case "GatingControls": {
                return Optional.ofNullable(clazz.cast(this.gatingControls()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuleConfig": {
                return Optional.ofNullable(clazz.cast(this.ruleConfig()));
            }
            case "SafetyRuleArn": {
                return Optional.ofNullable(clazz.cast(this.safetyRuleArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TargetControls": {
                return Optional.ofNullable(clazz.cast(this.targetControls()));
            }
            case "WaitPeriodMs": {
                return Optional.ofNullable(clazz.cast(this.waitPeriodMs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatingRule, T> g) {
        return obj -> g.apply((GatingRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String controlPanelArn;
        private List<String> gatingControls = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private RuleConfig ruleConfig;
        private String safetyRuleArn;
        private String status;
        private List<String> targetControls = DefaultSdkAutoConstructList.getInstance();
        private Integer waitPeriodMs;

        private BuilderImpl() {
        }

        private BuilderImpl(GatingRule model) {
            this.controlPanelArn(model.controlPanelArn);
            this.gatingControls(model.gatingControls);
            this.name(model.name);
            this.ruleConfig(model.ruleConfig);
            this.safetyRuleArn(model.safetyRuleArn);
            this.status(model.status);
            this.targetControls(model.targetControls);
            this.waitPeriodMs(model.waitPeriodMs);
        }

        public final String getControlPanelArn() {
            return this.controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        @Transient
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final Collection<String> getGatingControls() {
            if (this.gatingControls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gatingControls;
        }

        public final void setGatingControls(Collection<String> gatingControls) {
            this.gatingControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(gatingControls);
        }

        @Override
        @Transient
        public final Builder gatingControls(Collection<String> gatingControls) {
            this.gatingControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(gatingControls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gatingControls(String ... gatingControls) {
            this.gatingControls(Arrays.asList(gatingControls));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleConfig.Builder getRuleConfig() {
            return this.ruleConfig != null ? this.ruleConfig.toBuilder() : null;
        }

        public final void setRuleConfig(RuleConfig.BuilderImpl ruleConfig) {
            this.ruleConfig = ruleConfig != null ? ruleConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder ruleConfig(RuleConfig ruleConfig) {
            this.ruleConfig = ruleConfig;
            return this;
        }

        public final String getSafetyRuleArn() {
            return this.safetyRuleArn;
        }

        public final void setSafetyRuleArn(String safetyRuleArn) {
            this.safetyRuleArn = safetyRuleArn;
        }

        @Override
        @Transient
        public final Builder safetyRuleArn(String safetyRuleArn) {
            this.safetyRuleArn = safetyRuleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getTargetControls() {
            if (this.targetControls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetControls;
        }

        public final void setTargetControls(Collection<String> targetControls) {
            this.targetControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(targetControls);
        }

        @Override
        @Transient
        public final Builder targetControls(Collection<String> targetControls) {
            this.targetControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(targetControls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetControls(String ... targetControls) {
            this.targetControls(Arrays.asList(targetControls));
            return this;
        }

        public final Integer getWaitPeriodMs() {
            return this.waitPeriodMs;
        }

        public final void setWaitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
        }

        @Override
        @Transient
        public final Builder waitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
            return this;
        }

        public GatingRule build() {
            return new GatingRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatingRule> {
        public Builder controlPanelArn(String var1);

        public Builder gatingControls(Collection<String> var1);

        public Builder gatingControls(String ... var1);

        public Builder name(String var1);

        public Builder ruleConfig(RuleConfig var1);

        default public Builder ruleConfig(Consumer<RuleConfig.Builder> ruleConfig) {
            return this.ruleConfig((RuleConfig)((RuleConfig.Builder)RuleConfig.builder().applyMutation(ruleConfig)).build());
        }

        public Builder safetyRuleArn(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder targetControls(Collection<String> var1);

        public Builder targetControls(String ... var1);

        public Builder waitPeriodMs(Integer var1);
    }
}

