/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A safety rule. A safety rule can be an assertion rule or a gating rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements SdkPojo, Serializable, ToCopyableBuilder<Rule.Builder, Rule> {
    private static final SdkField<AssertionRule> ASSERTION_FIELD = SdkField.<AssertionRule> builder(MarshallingType.SDK_POJO)
            .memberName("ASSERTION").getter(getter(Rule::assertion)).setter(setter(Builder::assertion))
            .constructor(AssertionRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ASSERTION").build()).build();

    private static final SdkField<GatingRule> GATING_FIELD = SdkField.<GatingRule> builder(MarshallingType.SDK_POJO)
            .memberName("GATING").getter(getter(Rule::gating)).setter(setter(Builder::gating)).constructor(GatingRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GATING").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ASSERTION_FIELD, GATING_FIELD));

    private static final long serialVersionUID = 1L;

    private final AssertionRule assertion;

    private final GatingRule gating;

    private Rule(BuilderImpl builder) {
        this.assertion = builder.assertion;
        this.gating = builder.gating;
    }

    /**
     * <p>
     * An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule
     * configuration is met. Otherwise, the change to the routing control state is not accepted. For example, the
     * criteria might be that at least one routing control state is On after the transation so that traffic continues to
     * flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
     * </p>
     * 
     * @return An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule
     *         configuration is met. Otherwise, the change to the routing control state is not accepted. For example,
     *         the criteria might be that at least one routing control state is On after the transation so that traffic
     *         continues to flow to at least one cell for the application. This ensures that you avoid a fail-open
     *         scenario.
     */
    public final AssertionRule assertion() {
        return assertion;
    }

    /**
     * <p>
     * A gating rule verifies that a gating routing control or set of gating rounting controls, evaluates as true, based
     * on a rule configuration that you specify, which allows a set of routing control state changes to complete.
     * </p>
     * <p>
     * For example, if you specify one gating routing control and you set the Type in the rule configuration to OR, that
     * indicates that you must set the gating routing control to On for the rule to evaluate as true; that is, for the
     * gating control "switch" to be "On". When you do that, then you can update the routing control states for the
     * target routing controls that you specify in the gating rule.
     * </p>
     * 
     * @return A gating rule verifies that a gating routing control or set of gating rounting controls, evaluates as
     *         true, based on a rule configuration that you specify, which allows a set of routing control state changes
     *         to complete.</p>
     *         <p>
     *         For example, if you specify one gating routing control and you set the Type in the rule configuration to
     *         OR, that indicates that you must set the gating routing control to On for the rule to evaluate as true;
     *         that is, for the gating control "switch" to be "On". When you do that, then you can update the routing
     *         control states for the target routing controls that you specify in the gating rule.
     */
    public final GatingRule gating() {
        return gating;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assertion());
        hashCode = 31 * hashCode + Objects.hashCode(gating());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return Objects.equals(assertion(), other.assertion()) && Objects.equals(gating(), other.gating());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rule").add("ASSERTION", assertion()).add("GATING", gating()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ASSERTION":
            return Optional.ofNullable(clazz.cast(assertion()));
        case "GATING":
            return Optional.ofNullable(clazz.cast(gating()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule
         * configuration is met. Otherwise, the change to the routing control state is not accepted. For example, the
         * criteria might be that at least one routing control state is On after the transation so that traffic
         * continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
         * </p>
         * 
         * @param assertion
         *        An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule
         *        configuration is met. Otherwise, the change to the routing control state is not accepted. For example,
         *        the criteria might be that at least one routing control state is On after the transation so that
         *        traffic continues to flow to at least one cell for the application. This ensures that you avoid a
         *        fail-open scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assertion(AssertionRule assertion);

        /**
         * <p>
         * An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule
         * configuration is met. Otherwise, the change to the routing control state is not accepted. For example, the
         * criteria might be that at least one routing control state is On after the transation so that traffic
         * continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssertionRule.Builder} avoiding the need
         * to create one manually via {@link AssertionRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssertionRule.Builder#build()} is called immediately and its
         * result is passed to {@link #assertion(AssertionRule)}.
         * 
         * @param assertion
         *        a consumer that will call methods on {@link AssertionRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assertion(AssertionRule)
         */
        default Builder assertion(Consumer<AssertionRule.Builder> assertion) {
            return assertion(AssertionRule.builder().applyMutation(assertion).build());
        }

        /**
         * <p>
         * A gating rule verifies that a gating routing control or set of gating rounting controls, evaluates as true,
         * based on a rule configuration that you specify, which allows a set of routing control state changes to
         * complete.
         * </p>
         * <p>
         * For example, if you specify one gating routing control and you set the Type in the rule configuration to OR,
         * that indicates that you must set the gating routing control to On for the rule to evaluate as true; that is,
         * for the gating control "switch" to be "On". When you do that, then you can update the routing control states
         * for the target routing controls that you specify in the gating rule.
         * </p>
         * 
         * @param gating
         *        A gating rule verifies that a gating routing control or set of gating rounting controls, evaluates as
         *        true, based on a rule configuration that you specify, which allows a set of routing control state
         *        changes to complete.</p>
         *        <p>
         *        For example, if you specify one gating routing control and you set the Type in the rule configuration
         *        to OR, that indicates that you must set the gating routing control to On for the rule to evaluate as
         *        true; that is, for the gating control "switch" to be "On". When you do that, then you can update the
         *        routing control states for the target routing controls that you specify in the gating rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gating(GatingRule gating);

        /**
         * <p>
         * A gating rule verifies that a gating routing control or set of gating rounting controls, evaluates as true,
         * based on a rule configuration that you specify, which allows a set of routing control state changes to
         * complete.
         * </p>
         * <p>
         * For example, if you specify one gating routing control and you set the Type in the rule configuration to OR,
         * that indicates that you must set the gating routing control to On for the rule to evaluate as true; that is,
         * for the gating control "switch" to be "On". When you do that, then you can update the routing control states
         * for the target routing controls that you specify in the gating rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link GatingRule.Builder} avoiding the need to
         * create one manually via {@link GatingRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GatingRule.Builder#build()} is called immediately and its result
         * is passed to {@link #gating(GatingRule)}.
         * 
         * @param gating
         *        a consumer that will call methods on {@link GatingRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gating(GatingRule)
         */
        default Builder gating(Consumer<GatingRule.Builder> gating) {
            return gating(GatingRule.builder().applyMutation(gating).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AssertionRule assertion;

        private GatingRule gating;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            assertion(model.assertion);
            gating(model.gating);
        }

        public final AssertionRule.Builder getAssertion() {
            return assertion != null ? assertion.toBuilder() : null;
        }

        public final void setAssertion(AssertionRule.BuilderImpl assertion) {
            this.assertion = assertion != null ? assertion.build() : null;
        }

        @Override
        public final Builder assertion(AssertionRule assertion) {
            this.assertion = assertion;
            return this;
        }

        public final GatingRule.Builder getGating() {
            return gating != null ? gating.toBuilder() : null;
        }

        public final void setGating(GatingRule.BuilderImpl gating) {
            this.gating = gating != null ? gating.build() : null;
        }

        @Override
        public final Builder gating(GatingRule gating) {
            this.gating = gating;
            return this;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
