/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigClient;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse;

public class ListRoutingControlsIterable
implements SdkIterable<ListRoutingControlsResponse> {
    private final Route53RecoveryControlConfigClient client;
    private final ListRoutingControlsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoutingControlsIterable(Route53RecoveryControlConfigClient client, ListRoutingControlsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRoutingControlsResponseFetcher();
    }

    public Iterator<ListRoutingControlsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRoutingControlsResponseFetcher
    implements SyncPageFetcher<ListRoutingControlsResponse> {
        private ListRoutingControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListRoutingControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRoutingControlsResponse nextPage(ListRoutingControlsResponse previousPage) {
            if (previousPage == null) {
                return ListRoutingControlsIterable.this.client.listRoutingControls(ListRoutingControlsIterable.this.firstRequest);
            }
            return ListRoutingControlsIterable.this.client.listRoutingControls((ListRoutingControlsRequest)((Object)ListRoutingControlsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

