/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleConfig;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Status;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.___listOf__stringMin1Max256PatternAZaZ09Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssertionRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssertionRule> {
    private static final SdkField<List<String>> ASSERTED_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssertedControls").getter(AssertionRule.getter(AssertionRule::assertedControls)).setter(AssertionRule.setter(Builder::assertedControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssertedControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlPanelArn").getter(AssertionRule.getter(AssertionRule::controlPanelArn)).setter(AssertionRule.setter(Builder::controlPanelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AssertionRule.getter(AssertionRule::name)).setter(AssertionRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<RuleConfig> RULE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuleConfig").getter(AssertionRule.getter(AssertionRule::ruleConfig)).setter(AssertionRule.setter(Builder::ruleConfig)).constructor(RuleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleConfig").build()}).build();
    private static final SdkField<String> SAFETY_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SafetyRuleArn").getter(AssertionRule.getter(AssertionRule::safetyRuleArn)).setter(AssertionRule.setter(Builder::safetyRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafetyRuleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AssertionRule.getter(AssertionRule::statusAsString)).setter(AssertionRule.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> WAIT_PERIOD_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WaitPeriodMs").getter(AssertionRule.getter(AssertionRule::waitPeriodMs)).setter(AssertionRule.setter(Builder::waitPeriodMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitPeriodMs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSERTED_CONTROLS_FIELD, CONTROL_PANEL_ARN_FIELD, NAME_FIELD, RULE_CONFIG_FIELD, SAFETY_RULE_ARN_FIELD, STATUS_FIELD, WAIT_PERIOD_MS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> assertedControls;
    private final String controlPanelArn;
    private final String name;
    private final RuleConfig ruleConfig;
    private final String safetyRuleArn;
    private final String status;
    private final Integer waitPeriodMs;

    private AssertionRule(BuilderImpl builder) {
        this.assertedControls = builder.assertedControls;
        this.controlPanelArn = builder.controlPanelArn;
        this.name = builder.name;
        this.ruleConfig = builder.ruleConfig;
        this.safetyRuleArn = builder.safetyRuleArn;
        this.status = builder.status;
        this.waitPeriodMs = builder.waitPeriodMs;
    }

    public final boolean hasAssertedControls() {
        return this.assertedControls != null && !(this.assertedControls instanceof SdkAutoConstructList);
    }

    public final List<String> assertedControls() {
        return this.assertedControls;
    }

    public final String controlPanelArn() {
        return this.controlPanelArn;
    }

    public final String name() {
        return this.name;
    }

    public final RuleConfig ruleConfig() {
        return this.ruleConfig;
    }

    public final String safetyRuleArn() {
        return this.safetyRuleArn;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer waitPeriodMs() {
        return this.waitPeriodMs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssertedControls() ? this.assertedControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.safetyRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitPeriodMs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssertionRule)) {
            return false;
        }
        AssertionRule other = (AssertionRule)obj;
        return this.hasAssertedControls() == other.hasAssertedControls() && Objects.equals(this.assertedControls(), other.assertedControls()) && Objects.equals(this.controlPanelArn(), other.controlPanelArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ruleConfig(), other.ruleConfig()) && Objects.equals(this.safetyRuleArn(), other.safetyRuleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.waitPeriodMs(), other.waitPeriodMs());
    }

    public final String toString() {
        return ToString.builder((String)"AssertionRule").add("AssertedControls", this.hasAssertedControls() ? this.assertedControls() : null).add("ControlPanelArn", (Object)this.controlPanelArn()).add("Name", (Object)this.name()).add("RuleConfig", (Object)this.ruleConfig()).add("SafetyRuleArn", (Object)this.safetyRuleArn()).add("Status", (Object)this.statusAsString()).add("WaitPeriodMs", (Object)this.waitPeriodMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssertedControls": {
                return Optional.ofNullable(clazz.cast(this.assertedControls()));
            }
            case "ControlPanelArn": {
                return Optional.ofNullable(clazz.cast(this.controlPanelArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuleConfig": {
                return Optional.ofNullable(clazz.cast(this.ruleConfig()));
            }
            case "SafetyRuleArn": {
                return Optional.ofNullable(clazz.cast(this.safetyRuleArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "WaitPeriodMs": {
                return Optional.ofNullable(clazz.cast(this.waitPeriodMs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssertionRule, T> g) {
        return obj -> g.apply((AssertionRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> assertedControls = DefaultSdkAutoConstructList.getInstance();
        private String controlPanelArn;
        private String name;
        private RuleConfig ruleConfig;
        private String safetyRuleArn;
        private String status;
        private Integer waitPeriodMs;

        private BuilderImpl() {
        }

        private BuilderImpl(AssertionRule model) {
            this.assertedControls(model.assertedControls);
            this.controlPanelArn(model.controlPanelArn);
            this.name(model.name);
            this.ruleConfig(model.ruleConfig);
            this.safetyRuleArn(model.safetyRuleArn);
            this.status(model.status);
            this.waitPeriodMs(model.waitPeriodMs);
        }

        public final Collection<String> getAssertedControls() {
            if (this.assertedControls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assertedControls;
        }

        public final void setAssertedControls(Collection<String> assertedControls) {
            this.assertedControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(assertedControls);
        }

        @Override
        public final Builder assertedControls(Collection<String> assertedControls) {
            this.assertedControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(assertedControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assertedControls(String ... assertedControls) {
            this.assertedControls(Arrays.asList(assertedControls));
            return this;
        }

        public final String getControlPanelArn() {
            return this.controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleConfig.Builder getRuleConfig() {
            return this.ruleConfig != null ? this.ruleConfig.toBuilder() : null;
        }

        public final void setRuleConfig(RuleConfig.BuilderImpl ruleConfig) {
            this.ruleConfig = ruleConfig != null ? ruleConfig.build() : null;
        }

        @Override
        public final Builder ruleConfig(RuleConfig ruleConfig) {
            this.ruleConfig = ruleConfig;
            return this;
        }

        public final String getSafetyRuleArn() {
            return this.safetyRuleArn;
        }

        public final void setSafetyRuleArn(String safetyRuleArn) {
            this.safetyRuleArn = safetyRuleArn;
        }

        @Override
        public final Builder safetyRuleArn(String safetyRuleArn) {
            this.safetyRuleArn = safetyRuleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getWaitPeriodMs() {
            return this.waitPeriodMs;
        }

        public final void setWaitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
        }

        @Override
        public final Builder waitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
            return this;
        }

        public AssertionRule build() {
            return new AssertionRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssertionRule> {
        public Builder assertedControls(Collection<String> var1);

        public Builder assertedControls(String ... var1);

        public Builder controlPanelArn(String var1);

        public Builder name(String var1);

        public Builder ruleConfig(RuleConfig var1);

        default public Builder ruleConfig(Consumer<RuleConfig.Builder> ruleConfig) {
            return this.ruleConfig((RuleConfig)((RuleConfig.Builder)RuleConfig.builder().applyMutation(ruleConfig)).build());
        }

        public Builder safetyRuleArn(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder waitPeriodMs(Integer var1);
    }
}

