/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of five redundant Regional endpoints against which you can execute API calls to update or get the state of
 * routing controls. You can host multiple control panels and routing controls on one cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cluster implements SdkPojo, Serializable, ToCopyableBuilder<Cluster.Builder, Cluster> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(Cluster::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<List<ClusterEndpoint>> CLUSTER_ENDPOINTS_FIELD = SdkField
            .<List<ClusterEndpoint>> builder(MarshallingType.LIST)
            .memberName("ClusterEndpoints")
            .getter(getter(Cluster::clusterEndpoints))
            .setter(setter(Builder::clusterEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Cluster::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Cluster::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CLUSTER_ENDPOINTS_FIELD, NAME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterArn;

    private final List<ClusterEndpoint> clusterEndpoints;

    private final String name;

    private final String status;

    private Cluster(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterEndpoints = builder.clusterEndpoints;
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterEndpoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterEndpoints() {
        return clusterEndpoints != null && !(clusterEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Endpoints for a cluster. Specify one of these endpoints when you want to set or retrieve a routing control state
     * in the cluster.
     * </p>
     * <p>
     * To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller Routing
     * Control Actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterEndpoints} method.
     * </p>
     * 
     * @return Endpoints for a cluster. Specify one of these endpoints when you want to set or retrieve a routing
     *         control state in the cluster.</p>
     *         <p>
     *         To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller
     *         Routing Control Actions.
     */
    public final List<ClusterEndpoint> clusterEndpoints() {
        return clusterEndpoints;
    }

    /**
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return The name of the cluster.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterEndpoints() ? clusterEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && hasClusterEndpoints() == other.hasClusterEndpoints()
                && Objects.equals(clusterEndpoints(), other.clusterEndpoints()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Cluster").add("ClusterArn", clusterArn())
                .add("ClusterEndpoints", hasClusterEndpoints() ? clusterEndpoints() : null).add("Name", name())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ClusterEndpoints":
            return Optional.ofNullable(clazz.cast(clusterEndpoints()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cluster> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * Endpoints for a cluster. Specify one of these endpoints when you want to set or retrieve a routing control
         * state in the cluster.
         * </p>
         * <p>
         * To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller Routing
         * Control Actions.
         * </p>
         * 
         * @param clusterEndpoints
         *        Endpoints for a cluster. Specify one of these endpoints when you want to set or retrieve a routing
         *        control state in the cluster.</p>
         *        <p>
         *        To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller
         *        Routing Control Actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterEndpoints(Collection<ClusterEndpoint> clusterEndpoints);

        /**
         * <p>
         * Endpoints for a cluster. Specify one of these endpoints when you want to set or retrieve a routing control
         * state in the cluster.
         * </p>
         * <p>
         * To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller Routing
         * Control Actions.
         * </p>
         * 
         * @param clusterEndpoints
         *        Endpoints for a cluster. Specify one of these endpoints when you want to set or retrieve a routing
         *        control state in the cluster.</p>
         *        <p>
         *        To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller
         *        Routing Control Actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterEndpoints(ClusterEndpoint... clusterEndpoints);

        /**
         * <p>
         * Endpoints for a cluster. Specify one of these endpoints when you want to set or retrieve a routing control
         * state in the cluster.
         * </p>
         * <p>
         * To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller Routing
         * Control Actions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53recoverycontrolconfig.model.ClusterEndpoint.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.route53recoverycontrolconfig.model.ClusterEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53recoverycontrolconfig.model.ClusterEndpoint.Builder#build()} is
         * called immediately and its result is passed to {@link #clusterEndpoints(List<ClusterEndpoint>)}.
         * 
         * @param clusterEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53recoverycontrolconfig.model.ClusterEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterEndpoints(java.util.Collection<ClusterEndpoint>)
         */
        Builder clusterEndpoints(Consumer<ClusterEndpoint.Builder>... clusterEndpoints);

        /**
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param name
         *        The name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
         * </p>
         * 
         * @param status
         *        Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED,
         *        PENDING_DELETION.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
         * </p>
         * 
         * @param status
         *        Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED,
         *        PENDING_DELETION.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl implements Builder {
        private String clusterArn;

        private List<ClusterEndpoint> clusterEndpoints = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            clusterArn(model.clusterArn);
            clusterEndpoints(model.clusterEndpoints);
            name(model.name);
            status(model.status);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final List<ClusterEndpoint.Builder> getClusterEndpoints() {
            List<ClusterEndpoint.Builder> result = ___listOfClusterEndpointCopier.copyToBuilder(this.clusterEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterEndpoints(Collection<ClusterEndpoint.BuilderImpl> clusterEndpoints) {
            this.clusterEndpoints = ___listOfClusterEndpointCopier.copyFromBuilder(clusterEndpoints);
        }

        @Override
        public final Builder clusterEndpoints(Collection<ClusterEndpoint> clusterEndpoints) {
            this.clusterEndpoints = ___listOfClusterEndpointCopier.copy(clusterEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterEndpoints(ClusterEndpoint... clusterEndpoints) {
            clusterEndpoints(Arrays.asList(clusterEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterEndpoints(Consumer<ClusterEndpoint.Builder>... clusterEndpoints) {
            clusterEndpoints(Stream.of(clusterEndpoints).map(c -> ClusterEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Cluster build() {
            return new Cluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
