/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigAsyncClient;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.RoutingControl;

public class ListRoutingControlsPublisher
implements SdkPublisher<ListRoutingControlsResponse> {
    private final Route53RecoveryControlConfigAsyncClient client;
    private final ListRoutingControlsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRoutingControlsPublisher(Route53RecoveryControlConfigAsyncClient client, ListRoutingControlsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRoutingControlsPublisher(Route53RecoveryControlConfigAsyncClient client, ListRoutingControlsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRoutingControlsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRoutingControlsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RoutingControl> routingControls() {
        Function<ListRoutingControlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.routingControls() != null) {
                return response.routingControls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRoutingControlsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRoutingControlsResponseFetcher
    implements AsyncPageFetcher<ListRoutingControlsResponse> {
        private ListRoutingControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListRoutingControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRoutingControlsResponse> nextPage(ListRoutingControlsResponse previousPage) {
            if (previousPage == null) {
                return ListRoutingControlsPublisher.this.client.listRoutingControls(ListRoutingControlsPublisher.this.firstRequest);
            }
            return ListRoutingControlsPublisher.this.client.listRoutingControls((ListRoutingControlsRequest)((Object)ListRoutingControlsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

