/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigClient;
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigServiceClientConfiguration;
import software.amazon.awssdk.services.route53recoverycontrolconfig.internal.Route53RecoveryControlConfigServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.AccessDeniedException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ConflictException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateSafetyRuleRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateSafetyRuleResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteClusterRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteClusterResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteControlPanelRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteControlPanelResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteRoutingControlRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteRoutingControlResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteSafetyRuleRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteSafetyRuleResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeSafetyRuleRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeSafetyRuleResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.InternalServerException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ResourceNotFoundException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Route53RecoveryControlConfigException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.TagResourceRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.TagResourceResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ThrottlingException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UntagResourceRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UntagResourceResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateControlPanelRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateControlPanelResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateRoutingControlRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateRoutingControlResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ValidationException;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.CreateControlPanelRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.CreateRoutingControlRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.CreateSafetyRuleRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.DeleteControlPanelRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.DeleteRoutingControlRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.DeleteSafetyRuleRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.DescribeClusterRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.DescribeControlPanelRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.DescribeRoutingControlRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.DescribeSafetyRuleRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.ListAssociatedRoute53HealthChecksRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.ListControlPanelsRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.ListRoutingControlsRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.ListSafetyRulesRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.UpdateControlPanelRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.UpdateRoutingControlRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.transform.UpdateSafetyRuleRequestMarshaller;
import software.amazon.awssdk.services.route53recoverycontrolconfig.waiters.Route53RecoveryControlConfigWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultRoute53RecoveryControlConfigClient
implements Route53RecoveryControlConfigClient {
    private static final Logger log = Logger.loggerFor(DefaultRoute53RecoveryControlConfigClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53RecoveryControlConfigClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            CreateClusterResponse createClusterResponse = (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$createCluster$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateControlPanelResponse createControlPanel(CreateControlPanelRequest createControlPanelRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateControlPanelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createControlPanelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, createControlPanelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateControlPanel");
            CreateControlPanelResponse createControlPanelResponse = (CreateControlPanelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateControlPanel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createControlPanelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateControlPanelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createControlPanelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$createControlPanel$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRoutingControlResponse createRoutingControl(CreateRoutingControlRequest createRoutingControlRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRoutingControlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRoutingControlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, createRoutingControlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRoutingControl");
            CreateRoutingControlResponse createRoutingControlResponse = (CreateRoutingControlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRoutingControl").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createRoutingControlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRoutingControlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRoutingControlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$createRoutingControl$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSafetyRuleResponse createSafetyRule(CreateSafetyRuleRequest createSafetyRuleRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSafetyRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSafetyRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, createSafetyRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSafetyRule");
            CreateSafetyRuleResponse createSafetyRuleResponse = (CreateSafetyRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSafetyRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSafetyRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSafetyRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSafetyRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$createSafetyRule$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            DeleteClusterResponse deleteClusterResponse = (DeleteClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$deleteCluster$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteControlPanelResponse deleteControlPanel(DeleteControlPanelRequest deleteControlPanelRequest) throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteControlPanelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteControlPanelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, deleteControlPanelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteControlPanel");
            DeleteControlPanelResponse deleteControlPanelResponse = (DeleteControlPanelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteControlPanel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteControlPanelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteControlPanelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteControlPanelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$deleteControlPanel$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRoutingControlResponse deleteRoutingControl(DeleteRoutingControlRequest deleteRoutingControlRequest) throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRoutingControlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRoutingControlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, deleteRoutingControlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRoutingControl");
            DeleteRoutingControlResponse deleteRoutingControlResponse = (DeleteRoutingControlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRoutingControl").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRoutingControlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRoutingControlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRoutingControlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$deleteRoutingControl$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSafetyRuleResponse deleteSafetyRule(DeleteSafetyRuleRequest deleteSafetyRuleRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSafetyRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSafetyRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, deleteSafetyRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSafetyRule");
            DeleteSafetyRuleResponse deleteSafetyRuleResponse = (DeleteSafetyRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSafetyRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSafetyRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSafetyRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSafetyRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$deleteSafetyRule$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, describeClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCluster");
            DescribeClusterResponse describeClusterResponse = (DescribeClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$describeCluster$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeControlPanelResponse describeControlPanel(DescribeControlPanelRequest describeControlPanelRequest) throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeControlPanelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeControlPanelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, describeControlPanelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeControlPanel");
            DescribeControlPanelResponse describeControlPanelResponse = (DescribeControlPanelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeControlPanel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeControlPanelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeControlPanelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeControlPanelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$describeControlPanel$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRoutingControlResponse describeRoutingControl(DescribeRoutingControlRequest describeRoutingControlRequest) throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRoutingControlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRoutingControlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, describeRoutingControlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRoutingControl");
            DescribeRoutingControlResponse describeRoutingControlResponse = (DescribeRoutingControlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRoutingControl").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRoutingControlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRoutingControlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRoutingControlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$describeRoutingControl$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSafetyRuleResponse describeSafetyRule(DescribeSafetyRuleRequest describeSafetyRuleRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSafetyRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSafetyRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, describeSafetyRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSafetyRule");
            DescribeSafetyRuleResponse describeSafetyRuleResponse = (DescribeSafetyRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSafetyRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSafetyRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSafetyRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSafetyRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$describeSafetyRule$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) throws ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            GetResourcePolicyResponse getResourcePolicyResponse = (GetResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$getResourcePolicy$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssociatedRoute53HealthChecksResponse listAssociatedRoute53HealthChecks(ListAssociatedRoute53HealthChecksRequest listAssociatedRoute53HealthChecksRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssociatedRoute53HealthChecksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssociatedRoute53HealthChecksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, listAssociatedRoute53HealthChecksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssociatedRoute53HealthChecks");
            ListAssociatedRoute53HealthChecksResponse listAssociatedRoute53HealthChecksResponse = (ListAssociatedRoute53HealthChecksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssociatedRoute53HealthChecks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAssociatedRoute53HealthChecksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssociatedRoute53HealthChecksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssociatedRoute53HealthChecksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$listAssociatedRoute53HealthChecks$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClustersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, listClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusters");
            ListClustersResponse listClustersResponse = (ListClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$listClusters$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListControlPanelsResponse listControlPanels(ListControlPanelsRequest listControlPanelsRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListControlPanelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listControlPanelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, listControlPanelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListControlPanels");
            ListControlPanelsResponse listControlPanelsResponse = (ListControlPanelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListControlPanels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listControlPanelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListControlPanelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listControlPanelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$listControlPanels$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRoutingControlsResponse listRoutingControls(ListRoutingControlsRequest listRoutingControlsRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRoutingControlsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRoutingControlsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, listRoutingControlsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRoutingControls");
            ListRoutingControlsResponse listRoutingControlsResponse = (ListRoutingControlsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRoutingControls").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRoutingControlsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRoutingControlsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRoutingControlsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$listRoutingControls$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSafetyRulesResponse listSafetyRules(ListSafetyRulesRequest listSafetyRulesRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSafetyRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSafetyRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, listSafetyRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSafetyRules");
            ListSafetyRulesResponse listSafetyRulesResponse = (ListSafetyRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSafetyRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSafetyRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSafetyRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSafetyRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$listSafetyRules$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$listTagsForResource$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$tagResource$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$untagResource$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateControlPanelResponse updateControlPanel(UpdateControlPanelRequest updateControlPanelRequest) throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateControlPanelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateControlPanelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, updateControlPanelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateControlPanel");
            UpdateControlPanelResponse updateControlPanelResponse = (UpdateControlPanelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateControlPanel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateControlPanelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateControlPanelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateControlPanelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$updateControlPanel$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRoutingControlResponse updateRoutingControl(UpdateRoutingControlRequest updateRoutingControlRequest) throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRoutingControlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRoutingControlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, updateRoutingControlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRoutingControl");
            UpdateRoutingControlResponse updateRoutingControlResponse = (UpdateRoutingControlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRoutingControl").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateRoutingControlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRoutingControlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRoutingControlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$updateRoutingControl$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSafetyRuleResponse updateSafetyRule(UpdateSafetyRuleRequest updateSafetyRuleRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, Route53RecoveryControlConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSafetyRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSafetyRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryControlConfigClient.resolveMetricPublishers(clientConfiguration, updateSafetyRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Control Config");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSafetyRule");
            UpdateSafetyRuleResponse updateSafetyRuleResponse = (UpdateSafetyRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSafetyRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateSafetyRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSafetyRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSafetyRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryControlConfigClient.lambda$updateSafetyRule$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public Route53RecoveryControlConfigWaiter waiter() {
        return Route53RecoveryControlConfigWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "route53-recovery-control-config";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        Route53RecoveryControlConfigServiceClientConfigurationBuilder serviceConfigBuilder = new Route53RecoveryControlConfigServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Route53RecoveryControlConfigException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final Route53RecoveryControlConfigServiceClientConfiguration serviceClientConfiguration() {
        return new Route53RecoveryControlConfigServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateSafetyRule$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRoutingControl$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateControlPanel$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSafetyRules$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRoutingControls$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listControlPanels$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusters$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssociatedRoute53HealthChecks$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSafetyRule$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRoutingControl$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeControlPanel$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCluster$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSafetyRule$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRoutingControl$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteControlPanel$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSafetyRule$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRoutingControl$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createControlPanel$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

