/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssociatedRoute53HealthChecksResponse extends Route53RecoveryControlConfigResponse implements
        ToCopyableBuilder<ListAssociatedRoute53HealthChecksResponse.Builder, ListAssociatedRoute53HealthChecksResponse> {
    private static final SdkField<List<String>> HEALTH_CHECK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HealthCheckIds")
            .getter(getter(ListAssociatedRoute53HealthChecksResponse::healthCheckIds))
            .setter(setter(Builder::healthCheckIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAssociatedRoute53HealthChecksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> healthCheckIds;

    private final String nextToken;

    private ListAssociatedRoute53HealthChecksResponse(BuilderImpl builder) {
        super(builder);
        this.healthCheckIds = builder.healthCheckIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the HealthCheckIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHealthCheckIds() {
        return healthCheckIds != null && !(healthCheckIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifiers for the health checks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHealthCheckIds} method.
     * </p>
     * 
     * @return Identifiers for the health checks.
     */
    public final List<String> healthCheckIds() {
        return healthCheckIds;
    }

    /**
     * <p>
     * Next token for listing health checks.
     * </p>
     * 
     * @return Next token for listing health checks.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHealthCheckIds() ? healthCheckIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedRoute53HealthChecksResponse)) {
            return false;
        }
        ListAssociatedRoute53HealthChecksResponse other = (ListAssociatedRoute53HealthChecksResponse) obj;
        return hasHealthCheckIds() == other.hasHealthCheckIds() && Objects.equals(healthCheckIds(), other.healthCheckIds())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssociatedRoute53HealthChecksResponse")
                .add("HealthCheckIds", hasHealthCheckIds() ? healthCheckIds() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheckIds":
            return Optional.ofNullable(clazz.cast(healthCheckIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedRoute53HealthChecksResponse, T> g) {
        return obj -> g.apply((ListAssociatedRoute53HealthChecksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryControlConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAssociatedRoute53HealthChecksResponse> {
        /**
         * <p>
         * Identifiers for the health checks.
         * </p>
         * 
         * @param healthCheckIds
         *        Identifiers for the health checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckIds(Collection<String> healthCheckIds);

        /**
         * <p>
         * Identifiers for the health checks.
         * </p>
         * 
         * @param healthCheckIds
         *        Identifiers for the health checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckIds(String... healthCheckIds);

        /**
         * <p>
         * Next token for listing health checks.
         * </p>
         * 
         * @param nextToken
         *        Next token for listing health checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Route53RecoveryControlConfigResponse.BuilderImpl implements Builder {
        private List<String> healthCheckIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedRoute53HealthChecksResponse model) {
            super(model);
            healthCheckIds(model.healthCheckIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getHealthCheckIds() {
            if (healthCheckIds instanceof SdkAutoConstructList) {
                return null;
            }
            return healthCheckIds;
        }

        public final void setHealthCheckIds(Collection<String> healthCheckIds) {
            this.healthCheckIds = ___listOf__stringMax36PatternSCopier.copy(healthCheckIds);
        }

        @Override
        public final Builder healthCheckIds(Collection<String> healthCheckIds) {
            this.healthCheckIds = ___listOf__stringMax36PatternSCopier.copy(healthCheckIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckIds(String... healthCheckIds) {
            healthCheckIds(Arrays.asList(healthCheckIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssociatedRoute53HealthChecksResponse build() {
            return new ListAssociatedRoute53HealthChecksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
