/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ClusterEndpoint;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Status;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.___listOfClusterEndpointCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(Cluster.getter(Cluster::clusterArn)).setter(Cluster.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<List<ClusterEndpoint>> CLUSTER_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterEndpoints").getter(Cluster.getter(Cluster::clusterEndpoints)).setter(Cluster.setter(Builder::clusterEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Cluster.getter(Cluster::name)).setter(Cluster.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Cluster.getter(Cluster::statusAsString)).setter(Cluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(Cluster.getter(Cluster::owner)).setter(Cluster.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CLUSTER_ENDPOINTS_FIELD, NAME_FIELD, STATUS_FIELD, OWNER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final List<ClusterEndpoint> clusterEndpoints;
    private final String name;
    private final String status;
    private final String owner;

    private Cluster(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterEndpoints = builder.clusterEndpoints;
        this.name = builder.name;
        this.status = builder.status;
        this.owner = builder.owner;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final boolean hasClusterEndpoints() {
        return this.clusterEndpoints != null && !(this.clusterEndpoints instanceof SdkAutoConstructList);
    }

    public final List<ClusterEndpoint> clusterEndpoints() {
        return this.clusterEndpoints;
    }

    public final String name() {
        return this.name;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String owner() {
        return this.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterEndpoints() ? this.clusterEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && this.hasClusterEndpoints() == other.hasClusterEndpoints() && Objects.equals(this.clusterEndpoints(), other.clusterEndpoints()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.owner(), other.owner());
    }

    public final String toString() {
        return ToString.builder((String)"Cluster").add("ClusterArn", (Object)this.clusterArn()).add("ClusterEndpoints", this.hasClusterEndpoints() ? this.clusterEndpoints() : null).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Owner", (Object)this.owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ClusterEndpoints": {
                return Optional.ofNullable(clazz.cast(this.clusterEndpoints()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private List<ClusterEndpoint> clusterEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String status;
        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.clusterArn(model.clusterArn);
            this.clusterEndpoints(model.clusterEndpoints);
            this.name(model.name);
            this.status(model.status);
            this.owner(model.owner);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final List<ClusterEndpoint.Builder> getClusterEndpoints() {
            List<ClusterEndpoint.Builder> result = ___listOfClusterEndpointCopier.copyToBuilder(this.clusterEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterEndpoints(Collection<ClusterEndpoint.BuilderImpl> clusterEndpoints) {
            this.clusterEndpoints = ___listOfClusterEndpointCopier.copyFromBuilder(clusterEndpoints);
        }

        @Override
        public final Builder clusterEndpoints(Collection<ClusterEndpoint> clusterEndpoints) {
            this.clusterEndpoints = ___listOfClusterEndpointCopier.copy(clusterEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterEndpoints(ClusterEndpoint ... clusterEndpoints) {
            this.clusterEndpoints(Arrays.asList(clusterEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterEndpoints(Consumer<ClusterEndpoint.Builder> ... clusterEndpoints) {
            this.clusterEndpoints(Stream.of(clusterEndpoints).map(c -> (ClusterEndpoint)((ClusterEndpoint.Builder)ClusterEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder clusterArn(String var1);

        public Builder clusterEndpoints(Collection<ClusterEndpoint> var1);

        public Builder clusterEndpoints(ClusterEndpoint ... var1);

        public Builder clusterEndpoints(Consumer<ClusterEndpoint.Builder> ... var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder owner(String var1);
    }
}

