/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigAsyncClient;
import software.amazon.awssdk.services.route53recoverycontrolconfig.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse;

public class ListControlPanelsPublisher
implements SdkPublisher<ListControlPanelsResponse> {
    private final Route53RecoveryControlConfigAsyncClient client;
    private final ListControlPanelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListControlPanelsPublisher(Route53RecoveryControlConfigAsyncClient client, ListControlPanelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListControlPanelsPublisher(Route53RecoveryControlConfigAsyncClient client, ListControlPanelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListControlPanelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListControlPanelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ControlPanel> controlPanels() {
        Function<ListControlPanelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.controlPanels() != null) {
                return response.controlPanels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListControlPanelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListControlPanelsResponseFetcher
    implements AsyncPageFetcher<ListControlPanelsResponse> {
        private ListControlPanelsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlPanelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListControlPanelsResponse> nextPage(ListControlPanelsResponse previousPage) {
            if (previousPage == null) {
                return ListControlPanelsPublisher.this.client.listControlPanels(ListControlPanelsPublisher.this.firstRequest);
            }
            return ListControlPanelsPublisher.this.client.listControlPanels((ListControlPanelsRequest)((Object)ListControlPanelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

