/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListControlPanelsResponse extends Route53RecoveryControlConfigResponse implements
        ToCopyableBuilder<ListControlPanelsResponse.Builder, ListControlPanelsResponse> {
    private static final SdkField<List<ControlPanel>> CONTROL_PANELS_FIELD = SdkField
            .<List<ControlPanel>> builder(MarshallingType.LIST)
            .memberName("ControlPanels")
            .getter(getter(ListControlPanelsResponse::controlPanels))
            .setter(setter(Builder::controlPanels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlPanel> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlPanel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListControlPanelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_PANELS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ControlPanel> controlPanels;

    private final String nextToken;

    private ListControlPanelsResponse(BuilderImpl builder) {
        super(builder);
        this.controlPanels = builder.controlPanels;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlPanels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasControlPanels() {
        return controlPanels != null && !(controlPanels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The result of a successful ListControlPanel request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlPanels} method.
     * </p>
     * 
     * @return The result of a successful ListControlPanel request.
     */
    public final List<ControlPanel> controlPanels() {
        return controlPanels;
    }

    /**
     * <p>
     * The token that identifies which batch of results you want to see.
     * </p>
     * 
     * @return The token that identifies which batch of results you want to see.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasControlPanels() ? controlPanels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlPanelsResponse)) {
            return false;
        }
        ListControlPanelsResponse other = (ListControlPanelsResponse) obj;
        return hasControlPanels() == other.hasControlPanels() && Objects.equals(controlPanels(), other.controlPanels())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListControlPanelsResponse").add("ControlPanels", hasControlPanels() ? controlPanels() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlPanels":
            return Optional.ofNullable(clazz.cast(controlPanels()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListControlPanelsResponse, T> g) {
        return obj -> g.apply((ListControlPanelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryControlConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListControlPanelsResponse> {
        /**
         * <p>
         * The result of a successful ListControlPanel request.
         * </p>
         * 
         * @param controlPanels
         *        The result of a successful ListControlPanel request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPanels(Collection<ControlPanel> controlPanels);

        /**
         * <p>
         * The result of a successful ListControlPanel request.
         * </p>
         * 
         * @param controlPanels
         *        The result of a successful ListControlPanel request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPanels(ControlPanel... controlPanels);

        /**
         * <p>
         * The result of a successful ListControlPanel request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel.Builder#build()} is
         * called immediately and its result is passed to {@link #controlPanels(List<ControlPanel>)}.
         * 
         * @param controlPanels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlPanels(java.util.Collection<ControlPanel>)
         */
        Builder controlPanels(Consumer<ControlPanel.Builder>... controlPanels);

        /**
         * <p>
         * The token that identifies which batch of results you want to see.
         * </p>
         * 
         * @param nextToken
         *        The token that identifies which batch of results you want to see.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Route53RecoveryControlConfigResponse.BuilderImpl implements Builder {
        private List<ControlPanel> controlPanels = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlPanelsResponse model) {
            super(model);
            controlPanels(model.controlPanels);
            nextToken(model.nextToken);
        }

        public final List<ControlPanel.Builder> getControlPanels() {
            List<ControlPanel.Builder> result = ___listOfControlPanelCopier.copyToBuilder(this.controlPanels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlPanels(Collection<ControlPanel.BuilderImpl> controlPanels) {
            this.controlPanels = ___listOfControlPanelCopier.copyFromBuilder(controlPanels);
        }

        @Override
        public final Builder controlPanels(Collection<ControlPanel> controlPanels) {
            this.controlPanels = ___listOfControlPanelCopier.copy(controlPanels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlPanels(ControlPanel... controlPanels) {
            controlPanels(Arrays.asList(controlPanels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlPanels(Consumer<ControlPanel.Builder>... controlPanels) {
            controlPanels(Stream.of(controlPanels).map(c -> ControlPanel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListControlPanelsResponse build() {
            return new ListControlPanelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
