/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request body that you include when you create a safety rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSafetyRuleRequest extends Route53RecoveryControlConfigRequest implements
        ToCopyableBuilder<CreateSafetyRuleRequest.Builder, CreateSafetyRuleRequest> {
    private static final SdkField<NewAssertionRule> ASSERTION_RULE_FIELD = SdkField
            .<NewAssertionRule> builder(MarshallingType.SDK_POJO).memberName("AssertionRule")
            .getter(getter(CreateSafetyRuleRequest::assertionRule)).setter(setter(Builder::assertionRule))
            .constructor(NewAssertionRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssertionRule").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateSafetyRuleRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<NewGatingRule> GATING_RULE_FIELD = SdkField.<NewGatingRule> builder(MarshallingType.SDK_POJO)
            .memberName("GatingRule").getter(getter(CreateSafetyRuleRequest::gatingRule)).setter(setter(Builder::gatingRule))
            .constructor(NewGatingRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatingRule").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateSafetyRuleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSERTION_RULE_FIELD,
            CLIENT_TOKEN_FIELD, GATING_RULE_FIELD, TAGS_FIELD));

    private final NewAssertionRule assertionRule;

    private final String clientToken;

    private final NewGatingRule gatingRule;

    private final Map<String, String> tags;

    private CreateSafetyRuleRequest(BuilderImpl builder) {
        super(builder);
        this.assertionRule = builder.assertionRule;
        this.clientToken = builder.clientToken;
        this.gatingRule = builder.gatingRule;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The assertion rule requested.
     * </p>
     * 
     * @return The assertion rule requested.
     */
    public final NewAssertionRule assertionRule() {
        return assertionRule;
    }

    /**
     * <p>
     * A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action,
     * specify a client token in the request.
     * </p>
     * 
     * @return A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an
     *         action, specify a client token in the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The gating rule requested.
     * </p>
     * 
     * @return The gating rule requested.
     */
    public final NewGatingRule gatingRule() {
        return gatingRule;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the safety rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the safety rule.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assertionRule());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(gatingRule());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSafetyRuleRequest)) {
            return false;
        }
        CreateSafetyRuleRequest other = (CreateSafetyRuleRequest) obj;
        return Objects.equals(assertionRule(), other.assertionRule()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(gatingRule(), other.gatingRule()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSafetyRuleRequest").add("AssertionRule", assertionRule())
                .add("ClientToken", clientToken()).add("GatingRule", gatingRule()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssertionRule":
            return Optional.ofNullable(clazz.cast(assertionRule()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "GatingRule":
            return Optional.ofNullable(clazz.cast(gatingRule()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSafetyRuleRequest, T> g) {
        return obj -> g.apply((CreateSafetyRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryControlConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSafetyRuleRequest> {
        /**
         * <p>
         * The assertion rule requested.
         * </p>
         * 
         * @param assertionRule
         *        The assertion rule requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assertionRule(NewAssertionRule assertionRule);

        /**
         * <p>
         * The assertion rule requested.
         * </p>
         * This is a convenience method that creates an instance of the {@link NewAssertionRule.Builder} avoiding the
         * need to create one manually via {@link NewAssertionRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NewAssertionRule.Builder#build()} is called immediately and its
         * result is passed to {@link #assertionRule(NewAssertionRule)}.
         * 
         * @param assertionRule
         *        a consumer that will call methods on {@link NewAssertionRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assertionRule(NewAssertionRule)
         */
        default Builder assertionRule(Consumer<NewAssertionRule.Builder> assertionRule) {
            return assertionRule(NewAssertionRule.builder().applyMutation(assertionRule).build());
        }

        /**
         * <p>
         * A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an
         * action, specify a client token in the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with
         *        an action, specify a client token in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The gating rule requested.
         * </p>
         * 
         * @param gatingRule
         *        The gating rule requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatingRule(NewGatingRule gatingRule);

        /**
         * <p>
         * The gating rule requested.
         * </p>
         * This is a convenience method that creates an instance of the {@link NewGatingRule.Builder} avoiding the need
         * to create one manually via {@link NewGatingRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NewGatingRule.Builder#build()} is called immediately and its
         * result is passed to {@link #gatingRule(NewGatingRule)}.
         * 
         * @param gatingRule
         *        a consumer that will call methods on {@link NewGatingRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatingRule(NewGatingRule)
         */
        default Builder gatingRule(Consumer<NewGatingRule.Builder> gatingRule) {
            return gatingRule(NewGatingRule.builder().applyMutation(gatingRule).build());
        }

        /**
         * <p>
         * The tags associated with the safety rule.
         * </p>
         * 
         * @param tags
         *        The tags associated with the safety rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryControlConfigRequest.BuilderImpl implements Builder {
        private NewAssertionRule assertionRule;

        private String clientToken;

        private NewGatingRule gatingRule;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSafetyRuleRequest model) {
            super(model);
            assertionRule(model.assertionRule);
            clientToken(model.clientToken);
            gatingRule(model.gatingRule);
            tags(model.tags);
        }

        public final NewAssertionRule.Builder getAssertionRule() {
            return assertionRule != null ? assertionRule.toBuilder() : null;
        }

        public final void setAssertionRule(NewAssertionRule.BuilderImpl assertionRule) {
            this.assertionRule = assertionRule != null ? assertionRule.build() : null;
        }

        @Override
        public final Builder assertionRule(NewAssertionRule assertionRule) {
            this.assertionRule = assertionRule;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final NewGatingRule.Builder getGatingRule() {
            return gatingRule != null ? gatingRule.toBuilder() : null;
        }

        public final void setGatingRule(NewGatingRule.BuilderImpl gatingRule) {
            this.gatingRule = gatingRule != null ? gatingRule.build() : null;
        }

        @Override
        public final Builder gatingRule(NewGatingRule gatingRule) {
            this.gatingRule = gatingRule;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringMin0Max256PatternSCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringMin0Max256PatternSCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSafetyRuleRequest build() {
            return new CreateSafetyRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
