/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigClient;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Route53RecoveryControlConfigRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.waiters.Route53RecoveryControlConfigWaiter;
import software.amazon.awssdk.services.route53recoverycontrolconfig.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultRoute53RecoveryControlConfigWaiter
implements Route53RecoveryControlConfigWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final Route53RecoveryControlConfigClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeClusterResponse> clusterCreatedWaiter;
    private final Waiter<DescribeClusterResponse> clusterDeletedWaiter;
    private final Waiter<DescribeControlPanelResponse> controlPanelCreatedWaiter;
    private final Waiter<DescribeControlPanelResponse> controlPanelDeletedWaiter;
    private final Waiter<DescribeRoutingControlResponse> routingControlCreatedWaiter;
    private final Waiter<DescribeRoutingControlResponse> routingControlDeletedWaiter;

    private DefaultRoute53RecoveryControlConfigWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (Route53RecoveryControlConfigClient)Route53RecoveryControlConfigClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.clusterCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeClusterResponse.class).acceptors(DefaultRoute53RecoveryControlConfigWaiter.clusterCreatedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigWaiter.clusterCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.clusterDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeClusterResponse.class).acceptors(DefaultRoute53RecoveryControlConfigWaiter.clusterDeletedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigWaiter.clusterDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.controlPanelCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeControlPanelResponse.class).acceptors(DefaultRoute53RecoveryControlConfigWaiter.controlPanelCreatedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigWaiter.controlPanelCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.controlPanelDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeControlPanelResponse.class).acceptors(DefaultRoute53RecoveryControlConfigWaiter.controlPanelDeletedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigWaiter.controlPanelDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.routingControlCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeRoutingControlResponse.class).acceptors(DefaultRoute53RecoveryControlConfigWaiter.routingControlCreatedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigWaiter.routingControlCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.routingControlDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeRoutingControlResponse.class).acceptors(DefaultRoute53RecoveryControlConfigWaiter.routingControlDeletedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigWaiter.routingControlDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterCreated(DescribeClusterRequest describeClusterRequest) {
        return this.clusterCreatedWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterCreated(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterCreatedWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultRoute53RecoveryControlConfigWaiter.clusterCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest) {
        return this.clusterDeletedWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterDeletedWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultRoute53RecoveryControlConfigWaiter.clusterDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeControlPanelResponse> waitUntilControlPanelCreated(DescribeControlPanelRequest describeControlPanelRequest) {
        return this.controlPanelCreatedWaiter.run(() -> this.client.describeControlPanel(this.applyWaitersUserAgent(describeControlPanelRequest)));
    }

    @Override
    public WaiterResponse<DescribeControlPanelResponse> waitUntilControlPanelCreated(DescribeControlPanelRequest describeControlPanelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.controlPanelCreatedWaiter.run(() -> this.client.describeControlPanel(this.applyWaitersUserAgent(describeControlPanelRequest)), DefaultRoute53RecoveryControlConfigWaiter.controlPanelCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeControlPanelResponse> waitUntilControlPanelDeleted(DescribeControlPanelRequest describeControlPanelRequest) {
        return this.controlPanelDeletedWaiter.run(() -> this.client.describeControlPanel(this.applyWaitersUserAgent(describeControlPanelRequest)));
    }

    @Override
    public WaiterResponse<DescribeControlPanelResponse> waitUntilControlPanelDeleted(DescribeControlPanelRequest describeControlPanelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.controlPanelDeletedWaiter.run(() -> this.client.describeControlPanel(this.applyWaitersUserAgent(describeControlPanelRequest)), DefaultRoute53RecoveryControlConfigWaiter.controlPanelDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeRoutingControlResponse> waitUntilRoutingControlCreated(DescribeRoutingControlRequest describeRoutingControlRequest) {
        return this.routingControlCreatedWaiter.run(() -> this.client.describeRoutingControl(this.applyWaitersUserAgent(describeRoutingControlRequest)));
    }

    @Override
    public WaiterResponse<DescribeRoutingControlResponse> waitUntilRoutingControlCreated(DescribeRoutingControlRequest describeRoutingControlRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.routingControlCreatedWaiter.run(() -> this.client.describeRoutingControl(this.applyWaitersUserAgent(describeRoutingControlRequest)), DefaultRoute53RecoveryControlConfigWaiter.routingControlCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeRoutingControlResponse> waitUntilRoutingControlDeleted(DescribeRoutingControlRequest describeRoutingControlRequest) {
        return this.routingControlDeletedWaiter.run(() -> this.client.describeRoutingControl(this.applyWaitersUserAgent(describeRoutingControlRequest)));
    }

    @Override
    public WaiterResponse<DescribeRoutingControlResponse> waitUntilRoutingControlDeleted(DescribeRoutingControlRequest describeRoutingControlRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.routingControlDeletedWaiter.run(() -> this.client.describeRoutingControl(this.applyWaitersUserAgent(describeRoutingControlRequest)), DefaultRoute53RecoveryControlConfigWaiter.routingControlDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").value(), "DEPLOYED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").value(), "PENDING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").value(), "PENDING_DELETION");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeControlPanelResponse>> controlPanelCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeControlPanelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeControlPanelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ControlPanel").field("Status").value(), "DEPLOYED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ControlPanel").field("Status").value(), "PENDING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeControlPanelResponse>> controlPanelDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeControlPanelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeControlPanelResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ControlPanel").field("Status").value(), "PENDING_DELETION");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeRoutingControlResponse>> routingControlCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeRoutingControlResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeRoutingControlResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("RoutingControl").field("Status").value(), "DEPLOYED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("RoutingControl").field("Status").value(), "PENDING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeRoutingControlResponse>> routingControlDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeRoutingControlResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeRoutingControlResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("RoutingControl").field("Status").value(), "PENDING_DELETION");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration clusterCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration controlPanelCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration controlPanelDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration routingControlCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration routingControlDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static Route53RecoveryControlConfigWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends Route53RecoveryControlConfigRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Route53RecoveryControlConfigRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements Route53RecoveryControlConfigWaiter.Builder {
        private Route53RecoveryControlConfigClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public Route53RecoveryControlConfigWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public Route53RecoveryControlConfigWaiter.Builder client(Route53RecoveryControlConfigClient client) {
            this.client = client;
            return this;
        }

        @Override
        public Route53RecoveryControlConfigWaiter build() {
            return new DefaultRoute53RecoveryControlConfigWaiter(this);
        }
    }
}

