/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigAsyncClient;
import software.amazon.awssdk.services.route53recoverycontrolconfig.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Route53RecoveryControlConfigRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.waiters.Route53RecoveryControlConfigAsyncWaiter;
import software.amazon.awssdk.services.route53recoverycontrolconfig.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultRoute53RecoveryControlConfigAsyncWaiter
implements Route53RecoveryControlConfigAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final Route53RecoveryControlConfigAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeClusterResponse> clusterCreatedWaiter;
    private final AsyncWaiter<DescribeClusterResponse> clusterDeletedWaiter;
    private final AsyncWaiter<DescribeControlPanelResponse> controlPanelCreatedWaiter;
    private final AsyncWaiter<DescribeControlPanelResponse> controlPanelDeletedWaiter;
    private final AsyncWaiter<DescribeRoutingControlResponse> routingControlCreatedWaiter;
    private final AsyncWaiter<DescribeRoutingControlResponse> routingControlDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultRoute53RecoveryControlConfigAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (Route53RecoveryControlConfigAsyncClient)Route53RecoveryControlConfigAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.clusterCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClusterResponse.class).acceptors(DefaultRoute53RecoveryControlConfigAsyncWaiter.clusterCreatedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigAsyncWaiter.clusterCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.clusterDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClusterResponse.class).acceptors(DefaultRoute53RecoveryControlConfigAsyncWaiter.clusterDeletedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigAsyncWaiter.clusterDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.controlPanelCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeControlPanelResponse.class).acceptors(DefaultRoute53RecoveryControlConfigAsyncWaiter.controlPanelCreatedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigAsyncWaiter.controlPanelCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.controlPanelDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeControlPanelResponse.class).acceptors(DefaultRoute53RecoveryControlConfigAsyncWaiter.controlPanelDeletedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigAsyncWaiter.controlPanelDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.routingControlCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeRoutingControlResponse.class).acceptors(DefaultRoute53RecoveryControlConfigAsyncWaiter.routingControlCreatedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigAsyncWaiter.routingControlCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.routingControlDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeRoutingControlResponse.class).acceptors(DefaultRoute53RecoveryControlConfigAsyncWaiter.routingControlDeletedWaiterAcceptors())).overrideConfiguration(DefaultRoute53RecoveryControlConfigAsyncWaiter.routingControlDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterCreated(DescribeClusterRequest describeClusterRequest) {
        return this.clusterCreatedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterCreated(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterCreatedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultRoute53RecoveryControlConfigAsyncWaiter.clusterCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest) {
        return this.clusterDeletedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterDeletedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultRoute53RecoveryControlConfigAsyncWaiter.clusterDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeControlPanelResponse>> waitUntilControlPanelCreated(DescribeControlPanelRequest describeControlPanelRequest) {
        return this.controlPanelCreatedWaiter.runAsync(() -> this.client.describeControlPanel(this.applyWaitersUserAgent(describeControlPanelRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeControlPanelResponse>> waitUntilControlPanelCreated(DescribeControlPanelRequest describeControlPanelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.controlPanelCreatedWaiter.runAsync(() -> this.client.describeControlPanel(this.applyWaitersUserAgent(describeControlPanelRequest)), DefaultRoute53RecoveryControlConfigAsyncWaiter.controlPanelCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeControlPanelResponse>> waitUntilControlPanelDeleted(DescribeControlPanelRequest describeControlPanelRequest) {
        return this.controlPanelDeletedWaiter.runAsync(() -> this.client.describeControlPanel(this.applyWaitersUserAgent(describeControlPanelRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeControlPanelResponse>> waitUntilControlPanelDeleted(DescribeControlPanelRequest describeControlPanelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.controlPanelDeletedWaiter.runAsync(() -> this.client.describeControlPanel(this.applyWaitersUserAgent(describeControlPanelRequest)), DefaultRoute53RecoveryControlConfigAsyncWaiter.controlPanelDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeRoutingControlResponse>> waitUntilRoutingControlCreated(DescribeRoutingControlRequest describeRoutingControlRequest) {
        return this.routingControlCreatedWaiter.runAsync(() -> this.client.describeRoutingControl(this.applyWaitersUserAgent(describeRoutingControlRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeRoutingControlResponse>> waitUntilRoutingControlCreated(DescribeRoutingControlRequest describeRoutingControlRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.routingControlCreatedWaiter.runAsync(() -> this.client.describeRoutingControl(this.applyWaitersUserAgent(describeRoutingControlRequest)), DefaultRoute53RecoveryControlConfigAsyncWaiter.routingControlCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeRoutingControlResponse>> waitUntilRoutingControlDeleted(DescribeRoutingControlRequest describeRoutingControlRequest) {
        return this.routingControlDeletedWaiter.runAsync(() -> this.client.describeRoutingControl(this.applyWaitersUserAgent(describeRoutingControlRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeRoutingControlResponse>> waitUntilRoutingControlDeleted(DescribeRoutingControlRequest describeRoutingControlRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.routingControlDeletedWaiter.runAsync(() -> this.client.describeRoutingControl(this.applyWaitersUserAgent(describeRoutingControlRequest)), DefaultRoute53RecoveryControlConfigAsyncWaiter.routingControlDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").value(), "DEPLOYED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").value(), "PENDING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").value(), "PENDING_DELETION");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeControlPanelResponse>> controlPanelCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeControlPanelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeControlPanelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ControlPanel").field("Status").value(), "DEPLOYED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ControlPanel").field("Status").value(), "PENDING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeControlPanelResponse>> controlPanelDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeControlPanelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeControlPanelResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ControlPanel").field("Status").value(), "PENDING_DELETION");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeRoutingControlResponse>> routingControlCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeRoutingControlResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeRoutingControlResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RoutingControl").field("Status").value(), "DEPLOYED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RoutingControl").field("Status").value(), "PENDING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeRoutingControlResponse>> routingControlDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeRoutingControlResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeRoutingControlResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RoutingControl").field("Status").value(), "PENDING_DELETION");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration clusterCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration controlPanelCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration controlPanelDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration routingControlCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration routingControlDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(26);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static Route53RecoveryControlConfigAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends Route53RecoveryControlConfigRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Route53RecoveryControlConfigRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements Route53RecoveryControlConfigAsyncWaiter.Builder {
        private Route53RecoveryControlConfigAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public Route53RecoveryControlConfigAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public Route53RecoveryControlConfigAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public Route53RecoveryControlConfigAsyncWaiter.Builder client(Route53RecoveryControlConfigAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public Route53RecoveryControlConfigAsyncWaiter build() {
            return new DefaultRoute53RecoveryControlConfigAsyncWaiter(this);
        }
    }
}

