/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon
 * Route 53 health check, which can be used to control traffic routing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingControl implements SdkPojo, Serializable, ToCopyableBuilder<RoutingControl.Builder, RoutingControl> {
    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlPanelArn").getter(getter(RoutingControl::controlPanelArn))
            .setter(setter(Builder::controlPanelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RoutingControl::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlArn").getter(getter(RoutingControl::routingControlArn))
            .setter(setter(Builder::routingControlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RoutingControl::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(RoutingControl::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_PANEL_ARN_FIELD,
            NAME_FIELD, ROUTING_CONTROL_ARN_FIELD, STATUS_FIELD, OWNER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String controlPanelArn;

    private final String name;

    private final String routingControlArn;

    private final String status;

    private final String owner;

    private RoutingControl(BuilderImpl builder) {
        this.controlPanelArn = builder.controlPanelArn;
        this.name = builder.name;
        this.routingControlArn = builder.routingControlArn;
        this.status = builder.status;
        this.owner = builder.owner;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the control panel that includes the routing control.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the control panel that includes the routing control.
     */
    public final String controlPanelArn() {
        return controlPanelArn;
    }

    /**
     * <p>
     * The name of the routing control.
     * </p>
     * 
     * @return The name of the routing control.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the routing control.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the routing control.
     */
    public final String routingControlArn() {
        return routingControlArn;
    }

    /**
     * <p>
     * The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED,
     * PENDING_DELETION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED,
     *         PENDING_DELETION.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED,
     * PENDING_DELETION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED,
     *         PENDING_DELETION.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the routing control owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the routing control owner.
     */
    public final String owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(routingControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingControl)) {
            return false;
        }
        RoutingControl other = (RoutingControl) obj;
        return Objects.equals(controlPanelArn(), other.controlPanelArn()) && Objects.equals(name(), other.name())
                && Objects.equals(routingControlArn(), other.routingControlArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(owner(), other.owner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingControl").add("ControlPanelArn", controlPanelArn()).add("Name", name())
                .add("RoutingControlArn", routingControlArn()).add("Status", statusAsString()).add("Owner", owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlPanelArn":
            return Optional.ofNullable(clazz.cast(controlPanelArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoutingControlArn":
            return Optional.ofNullable(clazz.cast(routingControlArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoutingControl, T> g) {
        return obj -> g.apply((RoutingControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingControl> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the control panel that includes the routing control.
         * </p>
         * 
         * @param controlPanelArn
         *        The Amazon Resource Name (ARN) of the control panel that includes the routing control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPanelArn(String controlPanelArn);

        /**
         * <p>
         * The name of the routing control.
         * </p>
         * 
         * @param name
         *        The name of the routing control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the routing control.
         * </p>
         * 
         * @param routingControlArn
         *        The Amazon Resource Name (ARN) of the routing control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingControlArn(String routingControlArn);

        /**
         * <p>
         * The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED,
         * PENDING_DELETION.
         * </p>
         * 
         * @param status
         *        The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED,
         *        PENDING_DELETION.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED,
         * PENDING_DELETION.
         * </p>
         * 
         * @param status
         *        The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED,
         *        PENDING_DELETION.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The Amazon Web Services account ID of the routing control owner.
         * </p>
         * 
         * @param owner
         *        The Amazon Web Services account ID of the routing control owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);
    }

    static final class BuilderImpl implements Builder {
        private String controlPanelArn;

        private String name;

        private String routingControlArn;

        private String status;

        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingControl model) {
            controlPanelArn(model.controlPanelArn);
            name(model.name);
            routingControlArn(model.routingControlArn);
            status(model.status);
            owner(model.owner);
        }

        public final String getControlPanelArn() {
            return controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoutingControlArn() {
            return routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public RoutingControl build() {
            return new RoutingControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
