/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeControlPanelResponse extends Route53RecoveryControlConfigResponse implements
        ToCopyableBuilder<DescribeControlPanelResponse.Builder, DescribeControlPanelResponse> {
    private static final SdkField<ControlPanel> CONTROL_PANEL_FIELD = SdkField.<ControlPanel> builder(MarshallingType.SDK_POJO)
            .memberName("ControlPanel").getter(getter(DescribeControlPanelResponse::controlPanel))
            .setter(setter(Builder::controlPanel)).constructor(ControlPanel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_PANEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ControlPanel controlPanel;

    private DescribeControlPanelResponse(BuilderImpl builder) {
        super(builder);
        this.controlPanel = builder.controlPanel;
    }

    /**
     * <p>
     * Information about the control panel.
     * </p>
     * 
     * @return Information about the control panel.
     */
    public final ControlPanel controlPanel() {
        return controlPanel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(controlPanel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeControlPanelResponse)) {
            return false;
        }
        DescribeControlPanelResponse other = (DescribeControlPanelResponse) obj;
        return Objects.equals(controlPanel(), other.controlPanel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeControlPanelResponse").add("ControlPanel", controlPanel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlPanel":
            return Optional.ofNullable(clazz.cast(controlPanel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ControlPanel", CONTROL_PANEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeControlPanelResponse, T> g) {
        return obj -> g.apply((DescribeControlPanelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryControlConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeControlPanelResponse> {
        /**
         * <p>
         * Information about the control panel.
         * </p>
         * 
         * @param controlPanel
         *        Information about the control panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPanel(ControlPanel controlPanel);

        /**
         * <p>
         * Information about the control panel.
         * </p>
         * This is a convenience method that creates an instance of the {@link ControlPanel.Builder} avoiding the need
         * to create one manually via {@link ControlPanel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ControlPanel.Builder#build()} is called immediately and its
         * result is passed to {@link #controlPanel(ControlPanel)}.
         * 
         * @param controlPanel
         *        a consumer that will call methods on {@link ControlPanel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlPanel(ControlPanel)
         */
        default Builder controlPanel(Consumer<ControlPanel.Builder> controlPanel) {
            return controlPanel(ControlPanel.builder().applyMutation(controlPanel).build());
        }
    }

    static final class BuilderImpl extends Route53RecoveryControlConfigResponse.BuilderImpl implements Builder {
        private ControlPanel controlPanel;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeControlPanelResponse model) {
            super(model);
            controlPanel(model.controlPanel);
        }

        public final ControlPanel.Builder getControlPanel() {
            return controlPanel != null ? controlPanel.toBuilder() : null;
        }

        public final void setControlPanel(ControlPanel.BuilderImpl controlPanel) {
            this.controlPanel = controlPanel != null ? controlPanel.build() : null;
        }

        @Override
        public final Builder controlPanel(ControlPanel controlPanel) {
            this.controlPanel = controlPanel;
            return this;
        }

        @Override
        public DescribeControlPanelResponse build() {
            return new DescribeControlPanelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
