/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Update to a gating rule. You can update the name or the evaluation period (wait period). If you don't specify one of
 * the items to update, the item is unchanged.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatingRuleUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<GatingRuleUpdate.Builder, GatingRuleUpdate> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GatingRuleUpdate::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SAFETY_RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SafetyRuleArn").getter(getter(GatingRuleUpdate::safetyRuleArn)).setter(setter(Builder::safetyRuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafetyRuleArn").build()).build();

    private static final SdkField<Integer> WAIT_PERIOD_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WaitPeriodMs").getter(getter(GatingRuleUpdate::waitPeriodMs)).setter(setter(Builder::waitPeriodMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitPeriodMs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SAFETY_RULE_ARN_FIELD, WAIT_PERIOD_MS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String safetyRuleArn;

    private final Integer waitPeriodMs;

    private GatingRuleUpdate(BuilderImpl builder) {
        this.name = builder.name;
        this.safetyRuleArn = builder.safetyRuleArn;
        this.waitPeriodMs = builder.waitPeriodMs;
    }

    /**
     * <p>
     * The name for the gating rule. You can use any non-white space character in the name.
     * </p>
     * 
     * @return The name for the gating rule. You can use any non-white space character in the name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gating rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gating rule.
     */
    public final String safetyRuleArn() {
        return safetyRuleArn;
    }

    /**
     * <p>
     * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will
     * fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom
     * value.
     * </p>
     * 
     * @return An evaluation period, in milliseconds (ms), during which any request against the target routing controls
     *         will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can
     *         choose a custom value.
     */
    public final Integer waitPeriodMs() {
        return waitPeriodMs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(safetyRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(waitPeriodMs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatingRuleUpdate)) {
            return false;
        }
        GatingRuleUpdate other = (GatingRuleUpdate) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(safetyRuleArn(), other.safetyRuleArn())
                && Objects.equals(waitPeriodMs(), other.waitPeriodMs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GatingRuleUpdate").add("Name", name()).add("SafetyRuleArn", safetyRuleArn())
                .add("WaitPeriodMs", waitPeriodMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SafetyRuleArn":
            return Optional.ofNullable(clazz.cast(safetyRuleArn()));
        case "WaitPeriodMs":
            return Optional.ofNullable(clazz.cast(waitPeriodMs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("SafetyRuleArn", SAFETY_RULE_ARN_FIELD);
        map.put("WaitPeriodMs", WAIT_PERIOD_MS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GatingRuleUpdate, T> g) {
        return obj -> g.apply((GatingRuleUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatingRuleUpdate> {
        /**
         * <p>
         * The name for the gating rule. You can use any non-white space character in the name.
         * </p>
         * 
         * @param name
         *        The name for the gating rule. You can use any non-white space character in the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gating rule.
         * </p>
         * 
         * @param safetyRuleArn
         *        The Amazon Resource Name (ARN) of the gating rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder safetyRuleArn(String safetyRuleArn);

        /**
         * <p>
         * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will
         * fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a
         * custom value.
         * </p>
         * 
         * @param waitPeriodMs
         *        An evaluation period, in milliseconds (ms), during which any request against the target routing
         *        controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but
         *        you can choose a custom value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitPeriodMs(Integer waitPeriodMs);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String safetyRuleArn;

        private Integer waitPeriodMs;

        private BuilderImpl() {
        }

        private BuilderImpl(GatingRuleUpdate model) {
            name(model.name);
            safetyRuleArn(model.safetyRuleArn);
            waitPeriodMs(model.waitPeriodMs);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSafetyRuleArn() {
            return safetyRuleArn;
        }

        public final void setSafetyRuleArn(String safetyRuleArn) {
            this.safetyRuleArn = safetyRuleArn;
        }

        @Override
        public final Builder safetyRuleArn(String safetyRuleArn) {
            this.safetyRuleArn = safetyRuleArn;
            return this;
        }

        public final Integer getWaitPeriodMs() {
            return waitPeriodMs;
        }

        public final void setWaitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
        }

        @Override
        public final Builder waitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
            return this;
        }

        @Override
        public GatingRuleUpdate build() {
            return new GatingRuleUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
