/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessClient;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsResponse;

public class ListCrossAccountAuthorizationsIterable
implements SdkIterable<ListCrossAccountAuthorizationsResponse> {
    private final Route53RecoveryReadinessClient client;
    private final ListCrossAccountAuthorizationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCrossAccountAuthorizationsIterable(Route53RecoveryReadinessClient client, ListCrossAccountAuthorizationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCrossAccountAuthorizationsResponseFetcher();
    }

    public Iterator<ListCrossAccountAuthorizationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> crossAccountAuthorizations() {
        Function<ListCrossAccountAuthorizationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.crossAccountAuthorizations() != null) {
                return response.crossAccountAuthorizations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCrossAccountAuthorizationsResponseFetcher
    implements SyncPageFetcher<ListCrossAccountAuthorizationsResponse> {
        private ListCrossAccountAuthorizationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCrossAccountAuthorizationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCrossAccountAuthorizationsResponse nextPage(ListCrossAccountAuthorizationsResponse previousPage) {
            if (previousPage == null) {
                return ListCrossAccountAuthorizationsIterable.this.client.listCrossAccountAuthorizations(ListCrossAccountAuthorizationsIterable.this.firstRequest);
            }
            return ListCrossAccountAuthorizationsIterable.this.client.listCrossAccountAuthorizations((ListCrossAccountAuthorizationsRequest)((Object)ListCrossAccountAuthorizationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

