/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessBaseClientBuilder;
import software.amazon.awssdk.services.route53recoveryreadiness.endpoints.Route53RecoveryReadinessEndpointProvider;
import software.amazon.awssdk.services.route53recoveryreadiness.endpoints.internal.Route53RecoveryReadinessEndpointAuthSchemeInterceptor;
import software.amazon.awssdk.services.route53recoveryreadiness.endpoints.internal.Route53RecoveryReadinessRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.route53recoveryreadiness.endpoints.internal.Route53RecoveryReadinessResolveEndpointInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
abstract class DefaultRoute53RecoveryReadinessBaseClientBuilder<B extends Route53RecoveryReadinessBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultRoute53RecoveryReadinessBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "route53-recovery-readiness";
    }

    protected final String serviceName() {
        return "Route53RecoveryReadiness";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new Route53RecoveryReadinessResolveEndpointInterceptor());
        endpointInterceptors.add(new Route53RecoveryReadinessEndpointAuthSchemeInterceptor());
        endpointInterceptors.add(new Route53RecoveryReadinessRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/route53recoveryreadiness/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        return config.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    protected final String signingName() {
        return "route53-recovery-readiness";
    }

    private Route53RecoveryReadinessEndpointProvider defaultEndpointProvider() {
        return Route53RecoveryReadinessEndpointProvider.defaultProvider();
    }

    protected static void validateClientOptions(SdkClientConfiguration c) {
        Validate.notNull((Object)c.option((ClientOption)SdkAdvancedClientOption.SIGNER), (String)"The 'overrideConfiguration.advancedOption[SIGNER]' must be configured in the client builder.", (Object[])new Object[0]);
    }
}

