/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Message;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Readiness;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ResourceResult;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOfMessageCopier;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOfResourceResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReadinessCheckStatusResponse
extends Route53RecoveryReadinessResponse
implements ToCopyableBuilder<Builder, GetReadinessCheckStatusResponse> {
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Messages").getter(GetReadinessCheckStatusResponse.getter(GetReadinessCheckStatusResponse::messages)).setter(GetReadinessCheckStatusResponse.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetReadinessCheckStatusResponse.getter(GetReadinessCheckStatusResponse::nextToken)).setter(GetReadinessCheckStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> READINESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Readiness").getter(GetReadinessCheckStatusResponse.getter(GetReadinessCheckStatusResponse::readinessAsString)).setter(GetReadinessCheckStatusResponse.setter(Builder::readiness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readiness").build()}).build();
    private static final SdkField<List<ResourceResult>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(GetReadinessCheckStatusResponse.getter(GetReadinessCheckStatusResponse::resources)).setter(GetReadinessCheckStatusResponse.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD, NEXT_TOKEN_FIELD, READINESS_FIELD, RESOURCES_FIELD));
    private final List<Message> messages;
    private final String nextToken;
    private final String readiness;
    private final List<ResourceResult> resources;

    private GetReadinessCheckStatusResponse(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
        this.nextToken = builder.nextToken;
        this.readiness = builder.readiness;
        this.resources = builder.resources;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<Message> messages() {
        return this.messages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Readiness readiness() {
        return Readiness.fromValue(this.readiness);
    }

    public final String readinessAsString() {
        return this.readiness;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<ResourceResult> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.readinessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadinessCheckStatusResponse)) {
            return false;
        }
        GetReadinessCheckStatusResponse other = (GetReadinessCheckStatusResponse)((Object)obj);
        return this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.readinessAsString(), other.readinessAsString()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources());
    }

    public final String toString() {
        return ToString.builder((String)"GetReadinessCheckStatusResponse").add("Messages", this.hasMessages() ? this.messages() : null).add("NextToken", (Object)this.nextToken()).add("Readiness", (Object)this.readinessAsString()).add("Resources", this.hasResources() ? this.resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Readiness": {
                return Optional.ofNullable(clazz.cast(this.readinessAsString()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReadinessCheckStatusResponse, T> g) {
        return obj -> g.apply((GetReadinessCheckStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessResponse.BuilderImpl
    implements Builder {
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String readiness;
        private List<ResourceResult> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadinessCheckStatusResponse model) {
            super(model);
            this.messages(model.messages);
            this.nextToken(model.nextToken);
            this.readiness(model.readiness);
            this.resources(model.resources);
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = ___listOfMessageCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = ___listOfMessageCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = ___listOfMessageCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (Message)((Message.Builder)Message.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getReadiness() {
            return this.readiness;
        }

        public final void setReadiness(String readiness) {
            this.readiness = readiness;
        }

        @Override
        public final Builder readiness(String readiness) {
            this.readiness = readiness;
            return this;
        }

        @Override
        public final Builder readiness(Readiness readiness) {
            this.readiness(readiness == null ? null : readiness.toString());
            return this;
        }

        public final List<ResourceResult.Builder> getResources() {
            List<ResourceResult.Builder> result = ___listOfResourceResultCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ResourceResult.BuilderImpl> resources) {
            this.resources = ___listOfResourceResultCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<ResourceResult> resources) {
            this.resources = ___listOfResourceResultCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(ResourceResult ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<ResourceResult.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (ResourceResult)((ResourceResult.Builder)ResourceResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetReadinessCheckStatusResponse build() {
            return new GetReadinessCheckStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReadinessCheckStatusResponse> {
        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);

        public Builder messages(Consumer<Message.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder readiness(String var1);

        public Builder readiness(Readiness var1);

        public Builder resources(Collection<ResourceResult> var1);

        public Builder resources(ResourceResult ... var1);

        public Builder resources(Consumer<ResourceResult.Builder> ... var1);
    }
}

